/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.client.gui.WindowHutSmelter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingSmeltery
extends AbstractBuildingFurnaceUser {
    private static final String SMELTERY_DESC = "smeltery";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int STUFF_TO_KEEP = 10;

    public BuildingSmeltery(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(IColonyManager.getInstance().getCompatibilityManager()::isOre, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(AbstractFurnaceTileEntity::func_213991_b, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(stack -> ItemStackUtils.isEmpty(stack) == false && (stack.func_77973_b() instanceof SwordItem || stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof ArmorItem), new Tuple((Object)10, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SMELTERY_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobSmelter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return "smelter";
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Athletics;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Strength;
    }

    public int ingotMultiplier(int citizenLevel, Random random) {
        switch (this.getBuildingLevel()) {
            case 1: {
                return random.nextInt(100 - citizenLevel) == 0 ? 2 : 1;
            }
            case 2: {
                return random.nextInt(100 - citizenLevel * 2) == 2 ? 2 : 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return random.nextInt(100 - citizenLevel) == 0 ? 3 : 2;
            }
        }
        return 1;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.smeltery;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Smeltery", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutSmelter(this);
        }
    }
}

