/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.gson.JsonObject;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CustomRecipeManager {
    private static CustomRecipeManager instance = new CustomRecipeManager();
    private HashMap<String, Map<ResourceLocation, CustomRecipe>> recipeMap = new HashMap();
    private List<ResourceLocation> removedRecipes = new ArrayList<ResourceLocation>();

    private CustomRecipeManager() {
    }

    public static CustomRecipeManager getInstance() {
        return instance;
    }

    public void addRecipe(@NotNull JsonObject recipeJson, @NotNull ResourceLocation recipeLocation) {
        CustomRecipe recipe = CustomRecipe.parse(recipeJson);
        recipe.setRecipeId(recipeLocation);
        if (!this.recipeMap.containsKey(recipe.getCrafter())) {
            this.recipeMap.put(recipe.getCrafter(), new HashMap());
        }
        this.recipeMap.get(recipe.getCrafter()).put(recipeLocation, recipe);
    }

    public void removeRecipe(@NotNull JsonObject recipeJson, @NotNull ResourceLocation recipeLocation) {
        ResourceLocation toRemove;
        if (recipeJson.has("type") && recipeJson.get("type").getAsString().equals("remove") && recipeJson.has("recipe-id-to-remove") && !this.removedRecipes.contains(toRemove = new ResourceLocation(recipeJson.get("recipe-id-to-remove").getAsString()))) {
            this.removedRecipes.add(toRemove);
        }
    }

    public Set<CustomRecipe> getRecipes(@NotNull String crafter) {
        if (!this.removedRecipes.isEmpty()) {
            for (ResourceLocation toRemove : this.removedRecipes) {
                Optional<Map> crafterMap = this.recipeMap.entrySet().stream().map(r -> (Map)r.getValue()).filter(r1 -> r1.keySet().contains(toRemove)).findFirst();
                if (!crafterMap.isPresent()) continue;
                crafterMap.get().remove(toRemove);
            }
            this.removedRecipes.clear();
        }
        if (this.recipeMap.containsKey(crafter)) {
            return this.recipeMap.get(crafter).entrySet().stream().map(x -> (CustomRecipe)x.getValue()).collect(Collectors.toSet());
        }
        return new HashSet<CustomRecipe>();
    }

    public Map<String, Map<ResourceLocation, CustomRecipe>> getAllRecipes() {
        return this.recipeMap;
    }
}

