/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobStructure<AI extends AbstractAISkeleton<J>, J extends AbstractJobStructure<AI, J>>
extends AbstractJob<AI, J> {
    private static final String TAG_WORK_ORDER = "workorder";
    private int workOrderId;
    protected Blueprint blueprint;

    public AbstractJobStructure(ICitizenData entity) {
        super(entity);
    }

    public boolean hasBlueprint() {
        return this.blueprint != null;
    }

    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    public void setBlueprint(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public boolean hasWorkOrder() {
        return this.workOrderId != 0;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.workOrderId != 0) {
            compound.func_74768_a(TAG_WORK_ORDER, this.workOrderId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains(TAG_WORK_ORDER)) {
            this.workOrderId = compound.func_74762_e(TAG_WORK_ORDER);
        }
    }

    public void complete() {
        CompoundNBT teData;
        this.getWorkOrder().onCompleted(this.getCitizen().getColony(), this.getCitizen());
        TileEntity tileEntity = this.getColony().getWorld().func_175625_s(this.getWorkOrder().getBuildingLocation());
        if (tileEntity instanceof IBlueprintDataProvider && (teData = this.blueprint.getTileEntityData(tileEntity.func_174877_v(), this.blueprint.getPrimaryBlockOffset())) != null && teData.func_74764_b("blueprintDataProvider")) {
            ((IBlueprintDataProvider)tileEntity).readSchematicDataFromNBT(teData);
            Chunk chunk = (Chunk)tileEntity.func_145831_w().func_217349_x(tileEntity.func_174877_v());
            PacketDistributor.TRACKING_CHUNK.with(() -> chunk).send((IPacket)tileEntity.func_189518_D_());
            tileEntity.func_70296_d();
        }
        this.getCitizen().getColony().getWorkManager().removeWorkOrder(this.workOrderId);
        this.setWorkOrder(null);
        this.setBlueprint(null);
    }

    public WorkOrderBuildDecoration getWorkOrder() {
        return this.getColony().getWorkManager().getWorkOrder(this.workOrderId, WorkOrderBuildDecoration.class);
    }

    private void resetNeededItems() {
        IBuildingWorker workerBuilding = this.getCitizen().getWorkBuilding();
        if (workerBuilding instanceof BuildingBuilder) {
            ((BuildingBuilder)workerBuilding).resetNeededResources();
        }
    }

    public void setWorkOrder(@Nullable WorkOrderBuildDecoration order) {
        if (order == null) {
            this.workOrderId = 0;
            this.resetNeededItems();
        } else {
            this.workOrderId = order.getID();
        }
    }
}

