/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemDeliveryManJobDataStore;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.IDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.requestsystem.requests.StandardRequests;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;

public class JobDeliveryman
extends AbstractJob<EntityAIWorkDeliveryman, JobDeliveryman> {
    private IToken<?> rsDataStoreToken;
    public static final double BONUS_SPEED_PER_LEVEL = 0.003;
    private boolean active = false;
    private int ongoingDeliveries;

    public JobDeliveryman(ICitizenData entity) {
        super(entity);
        this.setupRsDataStore();
    }

    private void setupRsDataStore() {
        this.rsDataStoreToken = this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_DELIVERY_MAN_JOB_DATA_STORE).getId();
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            AttributeModifier speedModifier = new AttributeModifier("SkillSpeedBonus", (double)this.getCitizen().getCitizenSkillHandler().getLevel(this.getCitizen().getWorkBuilding().getPrimarySkill()) * 0.003, AttributeModifier.Operation.ADDITION);
            AttributeModifierUtils.addModifier((LivingEntity)worker, speedModifier, SharedMonsterAttributes.field_111263_d);
        }
    }

    @Override
    public JobEntry getJobRegistryEntry() {
        return ModJobs.delivery;
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Deliveryman";
    }

    @Override
    @NotNull
    public BipedModelType getModel() {
        return BipedModelType.DELIVERYMAN;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_218657_a("DataStoreToken", (INBT)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
        compound.func_74757_a("activeNodeNode", this.active);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
        this.active = compound.func_74767_n("activeNodeNode");
        this.ongoingDeliveries = compound.func_74762_e("ongoingDeliveries");
    }

    @Override
    @NotNull
    public EntityAIWorkDeliveryman generateAI() {
        return new EntityAIWorkDeliveryman(this);
    }

    private IRequestSystemDeliveryManJobDataStore getDataStore() {
        return this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_DELIVERY_MAN_JOB_DATA_STORE);
    }

    @Override
    public void serializeToView(PacketBuffer buffer) {
        super.serializeToView(buffer);
        StandardFactoryController.getInstance().serialize(buffer, this.rsDataStoreToken);
    }

    private LinkedList<IToken<?>> getTaskQueueFromDataStore() {
        return this.getDataStore().getQueue();
    }

    public IRequest<IDeliverymanRequestable> getCurrentTask() {
        IToken<?> request = this.getTaskQueueFromDataStore().peekFirst();
        if (request == null) {
            return null;
        }
        return this.getColony().getRequestManager().getRequestForToken(request);
    }

    public void addRequest(@NotNull IToken<?> token, int insertionIndex) {
        IRequestManager requestManager = this.getColony().getRequestManager();
        IRequest<?> newRequest = requestManager.getRequestForToken(token);
        LinkedList<IToken<?>> taskQueue = this.getTaskQueueFromDataStore();
        int offset = 0;
        for (int i = insertionIndex; i < taskQueue.size(); ++i) {
            IToken<?> theToken = taskQueue.get(i);
            IRequest<?> request = requestManager.getRequestForToken(theToken);
            if (request == null || request.getState() == RequestState.COMPLETED) {
                taskQueue.remove(theToken);
                --i;
                --offset;
                continue;
            }
            ((IDeliverymanRequestable)request.getRequest()).incrementPriorityDueToAging();
        }
        this.getTaskQueueFromDataStore().add(Math.max(0, insertionIndex + offset), token);
        if (newRequest instanceof StandardRequests.PickupRequest && ((IDeliverymanRequestable)newRequest.getRequest()).getPriority() == AbstractDeliverymanRequestable.getPlayerActionPriority(true)) {
            this.getCitizen().getEntity().get().getCitizenChatHandler().sendLocalizedChat("entity.deliveryman.forcepickup", new Object[0]);
        }
    }

    public void finishRequest(boolean successful) {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return;
        }
        IToken<?> current = this.getTaskQueueFromDataStore().getFirst();
        IRequest<?> request = this.getColony().getRequestManager().getRequestForToken(current);
        if (request == null) {
            if (!this.getTaskQueueFromDataStore().isEmpty() && current == this.getTaskQueueFromDataStore().getFirst()) {
                this.getTaskQueueFromDataStore().removeFirst();
            }
            return;
        }
        if (request.getRequest() instanceof Delivery) {
            List<IRequest<? extends Delivery>> taskList = this.getTaskListWithSameDestination(request);
            if (this.ongoingDeliveries != 0) {
                for (int i = 0; i < Math.max(1, Math.min(this.ongoingDeliveries, taskList.size())); ++i) {
                    IRequest<? extends Delivery> req = taskList.get(i);
                    if (req.getState() == RequestState.IN_PROGRESS) {
                        this.getColony().getRequestManager().updateRequestState((IToken<?>)req.getId(), successful ? RequestState.RESOLVED : RequestState.FAILED);
                    }
                    this.getTaskQueueFromDataStore().remove(req.getId());
                }
            } else {
                for (IToken<?> token : new ArrayList(this.getDataStore().getOngoingDeliveries())) {
                    IRequest<?> req = this.getColony().getRequestManager().getRequestForToken(token);
                    if (req != null && req.getState() == RequestState.IN_PROGRESS) {
                        this.getColony().getRequestManager().updateRequestState((IToken<?>)req.getId(), successful ? RequestState.RESOLVED : RequestState.FAILED);
                    }
                    this.getTaskQueueFromDataStore().remove(token);
                    this.getDataStore().getOngoingDeliveries().remove(token);
                }
            }
        } else if (request.getRequest() instanceof Pickup) {
            this.getTaskQueueFromDataStore().remove(request.getId());
            this.getColony().getRequestManager().updateRequestState(current, successful ? RequestState.RESOLVED : RequestState.FAILED);
        } else {
            this.getColony().getRequestManager().updateRequestState(current, successful ? RequestState.RESOLVED : RequestState.FAILED);
            if (!this.getTaskQueueFromDataStore().isEmpty() && current == this.getTaskQueueFromDataStore().getFirst()) {
                this.getTaskQueueFromDataStore().removeFirst();
            }
        }
        this.getCitizen().getWorkBuilding().markDirty();
    }

    public void onTaskDeletion(@NotNull IToken<?> token) {
        if (this.getTaskQueueFromDataStore().contains(token)) {
            this.getTaskQueueFromDataStore().remove(token);
        }
        if (this.getCitizen().getWorkBuilding() != null) {
            this.getCitizen().getWorkBuilding().markDirty();
        }
    }

    public List<IToken<?>> getTaskQueue() {
        return ImmutableList.copyOf(this.getTaskQueueFromDataStore());
    }

    @Override
    public void setActive(boolean b) {
        try {
            if (!b && this.active) {
                this.active = b;
                this.cancelAssignedRequests();
            } else if (!this.active && b) {
                this.active = b;
                this.getColony().getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof Delivery || request.getRequest() instanceof Pickup);
            }
        }
        catch (Exception ex) {
            Log.getLogger().warn("Active Triggered resulted in exception", (Throwable)ex);
        }
    }

    private void cancelAssignedRequests() {
        for (IToken<?> t : this.getTaskQueue()) {
            IRequest<?> r = this.getColony().getRequestManager().getRequestForToken(t);
            if (r != null) {
                this.getColony().getRequestManager().updateRequestState(t, RequestState.FAILED);
            } else {
                Log.getLogger().warn("Oops, the request with ID: " + t.toString() + " couldn't be cancelled by the deliveryman because it doesn't exist");
            }
            this.getTaskQueueFromDataStore().remove(t);
        }
    }

    @Override
    public void onRemoval() {
        this.active = false;
        try {
            this.cancelAssignedRequests();
        }
        catch (Exception ex) {
            Log.getLogger().warn("Active Triggered resulted in exception", (Throwable)ex);
        }
        this.getColony().getRequestManager().getDataStoreManager().remove(this.rsDataStoreToken);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public int hasSameDestinationDelivery(@NotNull IRequest<? extends Delivery> request) {
        for (IToken<?> requestToken : this.getTaskQueue()) {
            Delivery newDev;
            Delivery current;
            IRequest<?> compareRequest = this.getColony().getRequestManager().getRequestForToken(requestToken);
            if (compareRequest == null || !(compareRequest.getRequest() instanceof Delivery) || !this.haveTasksSameSourceAndDest(current = (Delivery)compareRequest.getRequest(), newDev = request.getRequest())) continue;
            return 0;
        }
        return 1;
    }

    private boolean haveTasksSameSourceAndDest(@NotNull Delivery requestA, @NotNull Delivery requestB) {
        if (requestA.getTarget().equals(requestB.getTarget())) {
            if (requestA.getStart().equals(requestB.getStart())) {
                return true;
            }
            for (IWareHouse wareHouse : this.getColony().getBuildingManager().getWareHouses()) {
                if (!wareHouse.hasContainerPosition(requestA.getStart().getInDimensionLocation()) || !wareHouse.hasContainerPosition(requestB.getStart().getInDimensionLocation())) continue;
                return true;
            }
        }
        return false;
    }

    public List<IRequest<? extends Delivery>> getTaskListWithSameDestination(IRequest<? extends Delivery> request) {
        ArrayList<IRequest<? extends Delivery>> deliveryList = new ArrayList<IRequest<? extends Delivery>>();
        deliveryList.add(request);
        for (IToken<?> requestToken : this.getTaskQueue()) {
            Delivery newDev;
            Delivery current;
            IRequest<?> compareRequest;
            if (requestToken.equals(request.getId()) || (compareRequest = this.getColony().getRequestManager().getRequestForToken(requestToken)) == null || !(compareRequest.getRequest() instanceof Delivery) || !this.haveTasksSameSourceAndDest(current = (Delivery)compareRequest.getRequest(), newDev = request.getRequest())) continue;
            deliveryList.add(compareRequest);
        }
        return deliveryList;
    }

    @NotNull
    public Tuple<Double, Integer> getScoreForDelivery(IRequest<?> newRequest) {
        LinkedList<IToken<?>> requestTokens = this.getTaskQueueFromDataStore();
        double totalScore = 10000.0;
        int bestRequestIndex = Math.max(0, requestTokens.size());
        if (requestTokens.isEmpty()) {
            totalScore = JobDeliveryman.getClosenessFactorTo(this.getSource(newRequest), this.getTarget(newRequest), this.getCitizen().getLastPosition(), this.getTarget(newRequest));
            totalScore -= (double)((AbstractDeliverymanRequestable)newRequest.getRequest()).getPriority();
        }
        for (int i = 0; i < requestTokens.size(); ++i) {
            double score;
            IRequest<?> compareRequest = this.getColony().getRequestManager().getRequestForToken((IToken)requestTokens.get(i));
            if (compareRequest == null || !(compareRequest.getRequest() instanceof AbstractDeliverymanRequestable) || !((score = this.getScoreOfRequestComparedTo(newRequest, compareRequest, i)) <= totalScore)) continue;
            bestRequestIndex = i + JobDeliveryman.getPickupOrRequestOffset(newRequest, compareRequest);
            totalScore = score;
        }
        return new Tuple<Double, Integer>(totalScore += (double)bestRequestIndex, bestRequestIndex);
    }

    public double getScoreOfRequestComparedTo(IRequest<?> source, IRequest<?> comparing, int comparingIndex) {
        if (comparing == null || !(comparing.getRequest() instanceof AbstractDeliverymanRequestable) || source == null || !(source.getRequest() instanceof AbstractDeliverymanRequestable)) {
            return 100.0;
        }
        double score = JobDeliveryman.getClosenessFactorTo(this.getSource(source), this.getTarget(source), this.getSource(comparing), this.getTarget(comparing));
        score += (double)(((AbstractDeliverymanRequestable)comparing.getRequest()).getPriority() - ((AbstractDeliverymanRequestable)source.getRequest()).getPriority()) * 0.5;
        score += (double)JobDeliveryman.getPickUpRequestScore(source, comparing);
        return score += (double)(this.getTaskQueue().size() - comparingIndex);
    }

    private static int getPickupOrRequestOffset(IRequest<?> newRequest, IRequest<?> existing) {
        if (newRequest.getRequest() instanceof Delivery && existing.getRequest() instanceof Pickup) {
            return 0;
        }
        return 1;
    }

    private static int getPickUpRequestScore(IRequest<?> newRequest, IRequest<?> existing) {
        if (newRequest.getRequest() instanceof Pickup && existing.getRequest() instanceof Delivery || newRequest.getRequest() instanceof Delivery && existing.getRequest() instanceof Pickup) {
            return 0;
        }
        return 3;
    }

    public static double getClosenessFactorTo(BlockPos source1, BlockPos target1, BlockPos source2, BlockPos target2) {
        double newLength = BlockPosUtil.getDistance(target1, source1);
        if (newLength <= 0.0) {
            return 10.0;
        }
        double targetCloseness = BlockPosUtil.getDistance(target1, target2) / newLength;
        double sourceCloseness = BlockPosUtil.getDistance(source1, source2) / newLength;
        return (targetCloseness + sourceCloseness) * 5.0;
    }

    private BlockPos getSource(IRequest<?> request) {
        IWareHouse wareHouse;
        if (request.getRequest() instanceof Delivery) {
            return ((Delivery)request.getRequest()).getStart().getInDimensionLocation();
        }
        if (request.getRequest() instanceof Pickup && (wareHouse = this.findWareHouse()) != null) {
            return wareHouse.getID();
        }
        return null;
    }

    private BlockPos getTarget(IRequest<?> request) {
        if (request.getRequest() instanceof Delivery) {
            return ((Delivery)request.getRequest()).getTarget().getInDimensionLocation();
        }
        if (request.getRequest() instanceof Pickup) {
            return request.getRequester().getLocation().getInDimensionLocation();
        }
        return null;
    }

    private IWareHouse findWareHouse() {
        for (IWareHouse building : this.getColony().getBuildingManager().getWareHouses()) {
            if (!building.getRegisteredDeliverymen().contains(new Vec3d((Vec3i)this.getCitizen().getWorkBuilding().getID()))) continue;
            return building;
        }
        return null;
    }

    public void addConcurrentDelivery(IToken<?> requestToken) {
        this.getDataStore().getOngoingDeliveries().add(requestToken);
    }

    public void removeConcurrentDelivery(IToken<?> requestToken) {
        this.getDataStore().getOngoingDeliveries().remove(requestToken);
    }
}

