/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.locations;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.location.ILocationFactory;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class EntityLocation
implements ILocation {
    @NotNull
    private final UUID uuid;
    @NotNull
    private WeakReference<Entity> entity = new WeakReference<Object>(null);

    public EntityLocation(@NotNull UUID uuid) {
        this.uuid = uuid;
        this.checkEntity();
    }

    private void checkEntity() {
        if (this.entity.get() != null) {
            return;
        }
        for (ServerWorld world : ServerLifecycleHooks.getCurrentServer().field_71305_c.values()) {
            try {
                Entity ent = world.func_217461_a(this.uuid);
                if (ent == null) continue;
                this.entity = new WeakReference<Entity>(ent);
                return;
            }
            catch (NullPointerException nullPointerException) {
            }
        }
    }

    @Override
    @NotNull
    public BlockPos getInDimensionLocation() {
        this.checkEntity();
        Entity entityRef = (Entity)this.entity.get();
        if (entityRef == null) {
            return BlockPos.field_177992_a;
        }
        return entityRef.func_180425_c();
    }

    @Override
    public int getDimension() {
        this.checkEntity();
        Entity entityRef = (Entity)this.entity.get();
        if (entityRef == null) {
            return 0;
        }
        return entityRef.field_71093_bK.func_186068_a();
    }

    @Override
    public boolean isReachableFromLocation(@NotNull ILocation location) {
        this.checkEntity();
        return this.entity.get() != null && location.getDimension() == this.getDimension();
    }

    public PlayerEntity getPlayerEntity() {
        this.checkEntity();
        Entity entityRef = (Entity)this.entity.get();
        return entityRef instanceof PlayerEntity ? (PlayerEntity)entityRef : null;
    }

    public static void serialize(PacketBuffer buffer, EntityLocation location) {
        buffer.func_179252_a(location.uuid);
    }

    public static EntityLocation deserialize(PacketBuffer buffer) {
        UUID uuid = buffer.func_179253_g();
        return new EntityLocation(uuid);
    }

    public static class Factory
    implements ILocationFactory<Entity, EntityLocation> {
        private static final String NBT_MSB = "Id_MSB";
        private static final String NBT_LSB = "Id_LSB";

        @Override
        @NotNull
        public TypeToken<EntityLocation> getFactoryOutputType() {
            return TypeToken.of(EntityLocation.class);
        }

        @Override
        @NotNull
        public TypeToken<Entity> getFactoryInputType() {
            return TypeToken.of(Entity.class);
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull EntityLocation request) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74772_a(NBT_LSB, request.uuid.getLeastSignificantBits());
            compound.func_74772_a(NBT_MSB, request.uuid.getMostSignificantBits());
            return compound;
        }

        @Override
        @NotNull
        public EntityLocation deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
            UUID uuid = new UUID(nbt.func_74763_f(NBT_MSB), nbt.func_74763_f(NBT_LSB));
            return new EntityLocation(uuid);
        }

        @Override
        @NotNull
        public EntityLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull Entity input) {
            return new EntityLocation(input.func_110124_au());
        }

        @Override
        public void serialize(IFactoryController controller, EntityLocation input, PacketBuffer packetBuffer) {
            EntityLocation.serialize(packetBuffer, input);
        }

        @Override
        public EntityLocation deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            return EntityLocation.deserialize(buffer);
        }

        @Override
        public short getSerializationId() {
            return 4;
        }
    }
}

