/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractCraftingRequestResolver;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateWorkerCraftingRequestResolver
extends AbstractCraftingRequestResolver {
    public PrivateWorkerCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token, false);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (!request.hasParent()) {
            return new TranslationTextComponent("com.minecolonies.coremod.resolvers.crafter.private", new Object[0]);
        }
        request = manager.getRequestForToken((IToken<?>)request.getParent());
        if (request == null) {
            return new TranslationTextComponent("com.minecolonies.coremod.resolvers.crafter.private", new Object[0]);
        }
        return request.getRequester().getRequesterDisplayName(manager, request).func_150257_a((ITextComponent)new StringTextComponent(" (")).func_150257_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.resolvers.crafter.private", new Object[0])).func_150257_a((ITextComponent)new StringTextComponent(")"));
    }

    @Override
    public int getPriority() {
        return 125;
    }

    @Override
    public boolean canBuildingCraftStack(@NotNull AbstractBuildingWorker building, Predicate<ItemStack> stackPredicate) {
        IRecipeStorage recipe = building.getFirstRecipe(stackPredicate);
        return recipe != null && (recipe.getIntermediate() == null || recipe.getIntermediate() == Blocks.field_150350_a);
    }

    @Override
    protected IRequestable createNewRequestableForStack(ItemStack stack, int count, int minCount) {
        return new PrivateCrafting(stack, count, minCount);
    }
}

