/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;

public class CommandCitizenKill
implements IMCColonyOfficerCommand {
    private static final DamageSource CONSOLE_DAMAGE_SOURCE = new DamageSource("Console");

    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, ((CommandSource)context.getSource()).func_197023_e().field_73011_w.func_186058_p().func_186068_a());
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        if (!((CommandSource)context.getSource()).func_197034_c(4) && !((Boolean)MineColonies.getConfig().getCommon().canPlayerUseKillCitizensCommand.get()).booleanValue()) {
            ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.notenabledinconfig", (Object[])new Object[0]), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.notfound", (Object[])new Object[0]), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.notloaded", (Object[])new Object[0]), true);
            return 0;
        }
        ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.desc", (Object[])new Object[]{citizenData.getId(), citizenData.getName()}), true);
        BlockPos position = optionalEntityCitizen.get().func_180425_c();
        ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()}), true);
        ((CommandSource)context.getSource()).func_197030_a(LanguageHandler.buildChatComponent((String)"com.minecolonies.command.citizenkill.success", (Object[])new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()}), true);
        optionalEntityCitizen.get().func_70645_a(CONSOLE_DAMAGE_SOURCE);
        return 1;
    }

    @Override
    public String getName() {
        return "kill";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

