/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.BlueprintIterator;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingBuiltEvent;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingDeconstructedEvent;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingUpgradedEvent;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.entity.ai.util.WorkerLoadOnlyStructureHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructureWithWorkOrder<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractEntityAIStructure<J, B> {
    private RequestStage requestState = RequestStage.SOLID;
    private BlockPos requestProgress = null;

    public AbstractEntityAIStructureWithWorkOrder(@NotNull J job) {
        super(job);
        this.worker.func_98053_h(true);
    }

    @Override
    public void storeProgressPos(BlockPos blockPos, BuildingStructureHandler.Stage stage) {
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setProgressPos(blockPos, stage);
    }

    @Override
    public Tuple<BlockPos, BuildingStructureHandler.Stage> getProgressPos() {
        return ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getProgress();
    }

    @Override
    public IAIState loadRequirements() {
        if (!((AbstractJobStructure)this.job).hasBlueprint() || this.structurePlacer == null) {
            this.loadStructure();
            WorkOrderBuildDecoration wo = ((AbstractJobStructure)this.job).getWorkOrder();
            if (wo == null) {
                Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()), (Throwable)new Exception());
                return AIWorkerState.IDLE;
            }
            if (wo instanceof WorkOrderBuildBuilding) {
                IBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()), (Throwable)new Exception());
                    return AIWorkerState.IDLE;
                }
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildstart", ((AbstractJobStructure)this.job).getBlueprint().getName());
                if (building.getBuildingLevel() > 0) {
                    wo.setCleared(true);
                }
            } else if (!(wo instanceof WorkOrderBuildMiner)) {
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildstart", wo.getName());
            }
            return this.getState();
        }
        if (((AbstractJobStructure)this.job).getWorkOrder().isRequested()) {
            return this.afterStructureLoading();
        }
        this.requestMaterialsState();
        return this.getState();
    }

    private void loadStructure() {
        WorkOrderBuildDecoration workOrder = ((AbstractJobStructure)this.job).getWorkOrder();
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getBuildingLocation();
        if (workOrder instanceof WorkOrderBuildBuilding && this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getCitizenColonyHandler().getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        int tempRotation = workOrder.getRotation(this.world);
        boolean removal = workOrder instanceof WorkOrderBuildRemoval;
        super.loadStructure(workOrder.getStructureName(), tempRotation, pos, workOrder.isMirrored(), removal);
        workOrder.setCleared(false);
        workOrder.setRequested(removal);
    }

    private void requestMaterialsState() {
        if (((Boolean)MineColonies.getConfig().getCommon().builderInfiniteResources.get()).booleanValue() || ((AbstractJobStructure)this.job).getWorkOrder().isRequested() || ((AbstractJobStructure)this.job).getWorkOrder() instanceof WorkOrderBuildRemoval) {
            return;
        }
        if (this.requestMaterials()) {
            AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.getOwnBuilding();
            ((AbstractJobStructure)this.job).getWorkOrder().setRequested(true);
            int newQuantity = buildingWorker.getNeededResources().values().stream().mapToInt(ItemStorage::getAmount).sum();
            if (((AbstractJobStructure)this.job).getWorkOrder().getAmountOfRes() == 0 || newQuantity > ((AbstractJobStructure)this.job).getWorkOrder().getAmountOfRes()) {
                ((AbstractJobStructure)this.job).getWorkOrder().setAmountOfRes(newQuantity);
            }
        }
    }

    @Override
    public boolean requestMaterials() {
        WorkerLoadOnlyStructureHandler structure = new WorkerLoadOnlyStructureHandler(this.world, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getWorldPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint(), new PlacementSettings(), true, this);
        StructurePlacer placer = new StructurePlacer(structure);
        if (this.requestProgress == null) {
            AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.getOwnBuilding();
            buildingWorker.resetNeededResources();
            this.requestProgress = BlueprintIterator.NULL_POS;
            this.requestState = RequestStage.SOLID;
        }
        RequestStage currState = this.requestState;
        switch (currState) {
            case SOLID: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !info.getBlockInfo().getState().func_185904_a().func_76220_a() || AbstractEntityAIStructureWithWorkOrder.isDecoItem(info.getBlockInfo().getState().func_177230_c()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).addNeededResource(stack, stack.func_190916_E());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.DECO;
                }
                return false;
            }
            case DECO: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getBlockInfo().getState().func_185904_a().func_76220_a() && !AbstractEntityAIStructureWithWorkOrder.isDecoItem(info.getBlockInfo().getState().func_177230_c()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).addNeededResource(stack, stack.func_190916_E());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.ENTITIES;
                }
                return false;
            }
            case ENTITIES: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getEntities().length == 0)), true);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).addNeededResource(stack, stack.func_190916_E());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.SOLID;
                    this.requestProgress = null;
                    ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).checkOrRequestBucket(((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getRequiredResources(), this.worker.getCitizenData(), true);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void registerBlockAsNeeded(ItemStack stack) {
        int hashCode;
        int n = hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        if (((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getNeededResources().get(stack.func_77977_a() + "-" + hashCode) == null) {
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).addNeededResource(stack, 1);
        }
    }

    @Override
    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        if (ItemStackUtils.isEmpty(deliveredItemStack).booleanValue()) {
            return 0;
        }
        int hashCode = deliveredItemStack.func_77942_o() ? deliveredItemStack.func_77978_p().hashCode() : 0;
        BuildingBuilderResource resource = ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getNeededResources().get(deliveredItemStack.func_77977_a() + "-" + hashCode);
        if (resource != null) {
            return resource.getAmount();
        }
        return super.getTotalRequiredAmount(deliveredItemStack);
    }

    @Override
    public void executeSpecificCompleteActions() {
        WorkOrderBuild wob;
        if (((AbstractJobStructure)this.job).getBlueprint() == null && ((AbstractJobStructure)this.job).hasWorkOrder()) {
            ((AbstractJobStructure)this.job).complete();
        }
        if (((AbstractJobStructure)this.job).getBlueprint() == null) {
            return;
        }
        String structureName = ((AbstractJobStructure)this.job).getBlueprint().getName();
        WorkOrderBuildDecoration wo = ((AbstractJobStructure)this.job).getWorkOrder();
        if (wo instanceof WorkOrderBuildBuilding) {
            this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildcomplete", structureName);
            wob = (WorkOrderBuild)wo;
            String buildingName = wo.getStructureName();
            buildingName = buildingName.substring(buildingName.indexOf(47) + 1, buildingName.lastIndexOf(47)) + " " + buildingName.substring(buildingName.lastIndexOf(47) + 1, buildingName.indexOf(String.valueOf(wob.getUpgradeLevel())));
            ((AbstractJobStructure)this.job).getColony().getEventDescriptionManager().addEventDescription(wob.getUpgradeLevel() > 1 ? new BuildingUpgradedEvent(wo.getBuildingLocation(), buildingName, wob.getUpgradeLevel()) : new BuildingBuiltEvent(wo.getBuildingLocation(), buildingName, wob.getUpgradeLevel()));
        } else if (wo instanceof WorkOrderBuildRemoval) {
            this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messageremovalcomplete", structureName);
            wob = (WorkOrderBuild)wo;
            String buildingName = wo.getStructureName();
            buildingName = buildingName.substring(buildingName.indexOf(47) + 1, buildingName.lastIndexOf(47)) + " " + buildingName.substring(buildingName.lastIndexOf(47) + 1, buildingName.indexOf(String.valueOf(wob.getUpgradeLevel())));
            ((AbstractJobStructure)this.job).getColony().getEventDescriptionManager().addEventDescription(new BuildingDeconstructedEvent(wo.getBuildingLocation(), buildingName, wob.getUpgradeLevel()));
        }
        if (wo == null) {
            Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()));
        } else {
            IBuilding building;
            ((AbstractJobStructure)this.job).complete();
            if (wo instanceof WorkOrderBuildBuilding) {
                building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                } else {
                    building.setBuildingLevel(((WorkOrderBuildBuilding)wo).getUpgradeLevel());
                }
            } else if (wo instanceof WorkOrderBuildRemoval) {
                building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getBuildingLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getBuildingLocation()));
                } else {
                    building.setDeconstructed();
                }
            }
        }
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).resetNeededResources();
    }

    @Override
    public void reduceNeededResources(ItemStack stack) {
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).reduceNeededResource(stack, 1);
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((AbstractJobStructure)this.job).getWorkOrder() == null && ((AbstractJobStructure)this.job).getBlueprint() != null || this.structurePlacer != null && !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint()) {
            ((AbstractJobStructure)this.job).setBlueprint(null);
            if (((AbstractJobStructure)this.job).hasWorkOrder()) {
                ((AbstractJobStructure)this.job).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
            }
            ((AbstractJobStructure)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).setProgressPos(null, BuildingStructureHandler.Stage.CLEAR);
            return true;
        }
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && !WorldUtil.isBlockLoaded((IWorld)this.world, ((AbstractJobStructure)this.job).getWorkOrder().getBuildingLocation()) && this.getState() != AIWorkerState.PICK_UP_RESIDUALS;
    }

    @Override
    protected boolean isAlreadyCleared() {
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && ((AbstractJobStructure)this.job).getWorkOrder().isCleared();
    }

    @Override
    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.getOwnBuilding();
        BuildingBuilderResource resource = buildingWorker.getNeededResources().get(stack.func_77977_a() + "-" + hashCode);
        if (resource == null) {
            this.requestMaterials();
            resource = buildingWorker.getNeededResources().get(stack.func_77977_a() + "-" + hashCode);
        }
        if (resource == null) {
            return stack;
        }
        ItemStack resStack = new ItemStack((IItemProvider)resource.getItem(), Math.min(64, resource.getAmount()));
        resStack.func_77982_d(resource.getItemStack().func_77978_p());
        return resStack;
    }

    @Override
    public void handleSpecificCancelActions() {
        ((AbstractBuildingStructureBuilder)this.getOwnBuilding()).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
        ((AbstractJobStructure)this.job).setWorkOrder(null);
    }

    private static enum RequestStage {
        SOLID,
        DECO,
        ENTITIES;

    }
}

