/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.cook;

import com.google.common.reflect.TypeToken;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIUsesFurnace;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCook
extends AbstractEntityAIUsesFurnace<JobCook, BuildingCook> {
    public static final int SATURATION_TO_SERVE = 16;
    private static final int SERVE_DELAY = 30;
    private static final int LEVEL_TO_FEED_PLAYER = 10;
    private final List<AbstractEntityCitizen> citizenToServe = new ArrayList<AbstractEntityCitizen>();
    private final List<PlayerEntity> playerToServe = new ArrayList<PlayerEntity>();
    private static final VisibleCitizenStatus COOK = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/cook.png"), "com.minecolonies.gui.visiblestatus.cook");
    private Set<ItemStack> assistantTests = new HashSet<ItemStack>();
    private AxisAlignedBB range = null;

    public EntityAIWorkCook(@NotNull JobCook job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.COOK_SERVE_FOOD_TO_CITIZEN, this::serveFoodToCitizen, 30));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingCook> getExpectedBuildingClass() {
        return BuildingCook.class;
    }

    @Override
    protected void extractFromFurnace(FurnaceTileEntity furnace) {
        if (!((BuildingCook)this.getOwnBuilding()).getIsCooking()) {
            InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)furnace), 2, (IItemHandler)this.worker.getInventoryCitizen());
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.incrementActionsDoneAndDecSaturation();
        }
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        if (!((BuildingCook)this.getOwnBuilding()).getIsCooking()) {
            return ItemStackUtils.ISCOOKABLE.test(stack) && !this.isItemStackForAssistant(stack);
        }
        return false;
    }

    @Override
    protected boolean reachedMaxToKeep() {
        return InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), ItemStackUtils.ISFOOD) > Math.max(1, ((BuildingCook)this.getOwnBuilding()).getBuildingLevel() * ((BuildingCook)this.getOwnBuilding()).getBuildingLevel()) * 9;
    }

    @Override
    public void requestSmeltable() {
        if (!((BuildingCook)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(this.getSmeltAbleClass().getClass()))) {
            this.worker.getCitizenData().createRequestAsync(this.getSmeltAbleClass());
        }
    }

    private IAIState serveFoodToCitizen() {
        Object handler;
        Entity living;
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.serving", new Object[0])});
        if (this.citizenToServe.isEmpty() && this.playerToServe.isEmpty()) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(COOK);
        Entity entity = living = this.citizenToServe.isEmpty() ? (Entity)this.playerToServe.get(0) : (Entity)this.citizenToServe.get(0);
        if (this.range == null) {
            this.range = ((BuildingCook)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        if (!this.range.func_72318_a(new Vec3d((Vec3i)living.func_180425_c()))) {
            this.worker.getNavigator().func_75499_g();
            this.removeFromQueue();
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(living.func_180425_c())) {
            return this.getState();
        }
        Object object = handler = this.citizenToServe.isEmpty() ? new InvWrapper((IInventory)this.playerToServe.get((int)0).field_71071_by) : this.citizenToServe.get(0).getInventoryCitizen();
        if (InventoryUtils.isItemHandlerFull((IItemHandler)handler)) {
            ItemStack stack2;
            int foodSlot;
            if (!this.citizenToServe.isEmpty() && (foodSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), ItemStackUtils.CAN_EAT)) != -1 && (stack2 = this.worker.getInventoryCitizen().extractItem(foodSlot, 1, false)).func_77973_b().func_219971_r()) {
                this.citizenToServe.get(0).getCitizenData().increaseSaturation((double)stack2.func_77973_b().func_219967_s().func_221466_a() / 2.0);
            }
            this.removeFromQueue();
            return this.getState();
        }
        InventoryUtils.transferFoodUpToSaturation((ICapabilityProvider)this.worker, (IItemHandler)handler, ((BuildingCook)this.getOwnBuilding()).getBuildingLevel() * 16, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack));
        if (!this.citizenToServe.isEmpty() && this.citizenToServe.get(0).getCitizenData() != null) {
            this.citizenToServe.get(0).getCitizenData().setJustAte(true);
        }
        if (this.citizenToServe.isEmpty() && living instanceof PlayerEntity) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)((PlayerEntity)living), (String)"com.minecolonies.coremod.cook.serve.player", (Object[])new Object[]{this.worker.func_200200_C_()});
        }
        this.removeFromQueue();
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.START_WORKING;
    }

    private void removeFromQueue() {
        if (this.citizenToServe.isEmpty()) {
            this.playerToServe.remove(0);
        } else {
            this.citizenToServe.remove(0);
        }
    }

    @Override
    protected IAIState checkForImportantJobs() {
        this.assistantTests.clear();
        if (this.range == null) {
            this.range = ((BuildingCook)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        this.citizenToServe.clear();
        List citizenList = this.world.func_217357_a(Entity.class, this.range).stream().filter(e -> e instanceof AbstractEntityCitizen).map(e -> (AbstractEntityCitizen)e).filter(cit -> !(cit.getCitizenJobHandler().getColonyJob() instanceof JobCook) && cit.shouldBeFed()).sorted(Comparator.comparingInt(a -> a.getCitizenJobHandler().getColonyJob() == null ? 1 : 0)).collect(Collectors.toList());
        List playerList = this.world.func_175647_a(PlayerEntity.class, this.range, player -> player != null && player.func_71024_bL().func_75116_a() < 10);
        if (!citizenList.isEmpty() || !playerList.isEmpty()) {
            this.citizenToServe.addAll(citizenList);
            this.playerToServe.addAll(playerList);
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack))) {
                return AIWorkerState.COOK_SERVE_FOOD_TO_CITIZEN;
            }
            if (!InventoryUtils.hasItemInProvider(this.getOwnBuilding(), stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && !this.isItemStackForAssistant((ItemStack)stack))) {
                return AIWorkerState.START_WORKING;
            }
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && !this.isItemStackForAssistant((ItemStack)stack), 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return AIWorkerState.START_WORKING;
    }

    private boolean isItemStackForAssistant(ItemStack stack) {
        if (this.assistantTests.isEmpty()) {
            this.assistantTests.addAll(((BuildingCook)this.getOwnBuilding()).getAssistantItems());
        }
        return ItemStackUtils.compareItemStackListIgnoreStackSize(new ArrayList<ItemStack>(this.assistantTests), stack, true, true);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        return new Food(64);
    }
}

