/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingHerder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIHerder<J extends AbstractJob<?, J>, B extends AbstractBuildingHerder, T extends AnimalEntity>
extends AbstractEntityAIInteract<J, B> {
    private static final int ANIMAL_MULTIPLIER = 2;
    private static final int NUM_OF_ANIMALS_TO_BREED = 2;
    protected static final int BUTCHERING_ATTACK_DAMAGE = 5;
    private static final int DISTANCE_TO_BREED = 10;
    private static final int BUTCHER_DELAY = 20;
    private static final int DECIDING_DELAY = 40;
    private static final int BREEDING_DELAY = 40;
    public static final int LIMIT_TO_FEED_CHILDREN = 10;
    private static final int ACTIONS_FOR_DUMP = 10;
    private static final double MAX_ENTITY_AGE = -24000.0;
    protected static final double XP_PER_ACTION = 0.5;
    private AxisAlignedBB targetArea = null;

    public AbstractEntityAIHerder(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForHerding, 20), new AITarget((IAIState)AIWorkerState.DECIDE, this::decideWhatToDo, 40), new AITarget((IAIState)AIWorkerState.HERDER_BREED, this::breedAnimals, 40), new AITarget((IAIState)AIWorkerState.HERDER_BUTCHER, this::butcherAnimals, 20), new AITarget((IAIState)AIWorkerState.HERDER_PICKUP, this::pickupItems, 20), new AITarget((IAIState)AIWorkerState.HERDER_FEED, this::feedAnimals, 20));
        this.worker.func_98053_h(true);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        if (((AbstractBuildingHerder)this.getOwnBuilding()).isBreeding()) {
            list.add(this.getRequestBreedingItems());
        }
        return list;
    }

    @NotNull
    public List<ToolType> getExtraToolsNeeded() {
        ArrayList<ToolType> toolsNeeded = new ArrayList<ToolType>();
        toolsNeeded.add(ToolType.AXE);
        return toolsNeeded;
    }

    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        return new ArrayList<ItemStack>();
    }

    public IAIState decideWhatToDo() {
        boolean hasBreedingItem;
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        ArrayList<T> animals = new ArrayList<T>(this.searchForAnimals());
        if (animals.isEmpty()) {
            return AIWorkerState.DECIDE;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.deciding", new Object[0])});
        int numOfBreedableAnimals = 0;
        int numOfFeedableAnimals = 0;
        for (AnimalEntity entity : animals) {
            if (this.isBreedAble(entity)) {
                ++numOfBreedableAnimals;
                continue;
            }
            if (!(-24000.0 / (double)entity.func_70874_b() <= 1.0 + (double)this.getSecondarySkillLevel() / 100.0)) continue;
            ++numOfFeedableAnimals;
        }
        boolean bl = hasBreedingItem = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.getBreedingItem())) > 1;
        if (!this.searchForItemsInArea().isEmpty()) {
            return AIWorkerState.HERDER_PICKUP;
        }
        if (this.maxAnimals(animals)) {
            return AIWorkerState.HERDER_BUTCHER;
        }
        if (((AbstractBuildingHerder)this.getOwnBuilding()).isBreeding() && numOfBreedableAnimals >= 2 && hasBreedingItem) {
            return AIWorkerState.HERDER_BREED;
        }
        if (this.canFeedChildren() && numOfFeedableAnimals > 0) {
            return AIWorkerState.HERDER_FEED;
        }
        return AIWorkerState.START_WORKING;
    }

    protected boolean isBreedAble(AnimalEntity entity) {
        return entity.func_70874_b() == 0 && entity.func_204701_dC();
    }

    protected boolean canFeedChildren() {
        return false;
    }

    private IAIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.worker.goingtohut", new Object[0])});
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForHerding() {
        for (ToolType tool : this.getExtraToolsNeeded()) {
            if (!this.checkForToolOrWeapon(tool)) continue;
            return this.getState();
        }
        ItemStack breedingItem = this.getBreedingItem();
        this.checkIfRequestForItemExistOrCreateAsynch(breedingItem, breedingItem.func_77976_d(), breedingItem.func_190916_E());
        for (ItemStack item : this.getExtraItemsNeeded()) {
            this.checkIfRequestForItemExistOrCreateAsynch(item);
        }
        return AIWorkerState.DECIDE;
    }

    protected IAIState butcherAnimals() {
        ArrayList<T> animals = new ArrayList<T>(this.searchForAnimals());
        if (!this.maxAnimals(animals)) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipTool(Hand.MAIN_HAND, ToolType.AXE)) {
            return AIWorkerState.START_WORKING;
        }
        AnimalEntity animal = animals.stream().filter(animalToButcher -> !animalToButcher.func_70631_g_()).findFirst().orElse(null);
        if (animal == null) {
            return AIWorkerState.DECIDE;
        }
        this.butcherAnimal(animal);
        if (!animal.func_70089_S()) {
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.incrementActionsDoneAndDecSaturation();
        }
        return AIWorkerState.HERDER_BUTCHER;
    }

    protected IAIState breedAnimals() {
        List<T> animals = this.searchForAnimals();
        AnimalEntity animalOne = animals.stream().filter(this::isBreedAble).findAny().orElse(null);
        if (animalOne == null) {
            return AIWorkerState.DECIDE;
        }
        AnimalEntity animalTwo = animals.stream().filter(animal -> {
            float range = animal.func_70032_d((Entity)animalOne);
            boolean isAnimalOne = animalOne.equals(animal);
            return this.isBreedAble((AnimalEntity)animal) && range <= 10.0f && !isAnimalOne;
        }).findAny().orElse(null);
        if (animalTwo == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(Hand.MAIN_HAND, this.getBreedingItem())) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.herder.breeding", new Object[0])});
        this.breedTwoAnimals(animalOne, animalTwo);
        this.worker.decreaseSaturationForContinuousAction();
        return AIWorkerState.DECIDE;
    }

    protected IAIState feedAnimals() {
        List<T> animals = this.searchForAnimals();
        AnimalEntity animalOne = animals.stream().filter(entity -> entity.func_70631_g_() && -24000.0 / (double)entity.func_70874_b() <= 1.0 + (double)this.getSecondarySkillLevel() / 100.0).findAny().orElse(null);
        if (animalOne == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(Hand.MAIN_HAND, this.getBreedingItem())) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.herder.feeding", new Object[0])});
        if (!this.walkingToAnimal(animalOne)) {
            animalOne.func_175501_a((int)((float)(-animalOne.func_70874_b() / 20) * 0.1f), true);
            this.worker.func_184609_a(Hand.MAIN_HAND);
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.getBreedingItem());
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            animalOne.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            return AIWorkerState.DECIDE;
        }
        this.worker.decreaseSaturationForContinuousAction();
        return this.getState();
    }

    private IAIState pickupItems() {
        List<ItemEntity> items = this.searchForItemsInArea();
        if (!items.isEmpty() && this.walkToBlock(items.get(0).func_180425_c())) {
            return this.getState();
        }
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.DECIDE;
    }

    public List<T> searchForAnimals() {
        if (this.getTargetableArea() != null) {
            return new ArrayList(this.world.func_217357_a(this.getAnimalClass(), this.getTargetableArea()));
        }
        return new ArrayList();
    }

    public int getMaxAnimalMultiplier() {
        return 2;
    }

    public List<ItemEntity> searchForItemsInArea() {
        if (this.getTargetableArea() != null) {
            return new ArrayList<ItemEntity>(this.world.func_217357_a(ItemEntity.class, this.getTargetableArea()));
        }
        return new ArrayList<ItemEntity>();
    }

    public abstract Class<T> getAnimalClass();

    private AxisAlignedBB getTargetableArea() {
        if (this.getOwnBuilding() == null) {
            return null;
        }
        if (this.targetArea == null) {
            this.targetArea = ((AbstractBuildingHerder)this.getOwnBuilding()).getTargetableArea(this.world);
        }
        return this.targetArea;
    }

    public boolean walkingToAnimal(AnimalEntity animal) {
        if (animal != null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.herder.goingToAnimal", new Object[0])});
            return this.walkToBlock(animal.func_180425_c());
        }
        return false;
    }

    private void breedTwoAnimals(AnimalEntity animalOne, AnimalEntity animalTwo) {
        ArrayList<AnimalEntity> animalsToBreed = new ArrayList<AnimalEntity>();
        animalsToBreed.add(animalOne);
        animalsToBreed.add(animalTwo);
        for (AnimalEntity animal : animalsToBreed) {
            if (animal.func_70880_s() || this.walkingToAnimal(animal)) continue;
            animal.func_146082_f(null);
            this.worker.func_184609_a(Hand.MAIN_HAND);
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.getBreedingItem());
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
        }
    }

    public boolean maxAnimals(List<T> allAnimals) {
        if (this.getOwnBuilding() != null) {
            int maxAnimals;
            List animals = allAnimals.stream().filter(animalToButcher -> !animalToButcher.func_70631_g_()).collect(Collectors.toList());
            if (animals.isEmpty()) {
                return false;
            }
            int numOfAnimals = animals.size();
            return numOfAnimals > (maxAnimals = ((AbstractBuildingHerder)this.getOwnBuilding()).getBuildingLevel() * this.getMaxAnimalMultiplier());
        }
        return true;
    }

    public boolean equipTool(Hand hand, ToolType toolType) {
        if (this.getToolSlot(toolType) != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getToolSlot(toolType));
            return true;
        }
        return false;
    }

    private int getToolSlot(ToolType toolType) {
        if (this.getOwnBuilding() != null) {
            int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), toolType, 0, ((AbstractBuildingHerder)this.getOwnBuilding()).getMaxToolLevel());
            if (slot == -1) {
                this.checkForToolOrWeapon(toolType);
            }
            return slot;
        }
        return -1;
    }

    public boolean equipItem(Hand hand, ItemStack itemStack) {
        if (this.checkIfRequestForItemExistOrCreateAsynch(itemStack)) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getItemSlot(itemStack.func_77973_b()));
            return true;
        }
        return false;
    }

    public int getItemSlot(Item item) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), item);
    }

    protected void butcherAnimal(@Nullable AnimalEntity animal) {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.herder.butchering", new Object[0])});
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.func_184614_ca()).booleanValue()) {
            this.worker.func_184609_a(Hand.MAIN_HAND);
            FakePlayer fp = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.worker.func_130014_f_()));
            DamageSource ds = DamageSource.func_76365_a((PlayerEntity)fp);
            animal.func_70097_a(ds, (float)this.getButcheringAttackDamage());
            this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
        }
    }

    public double getButcheringAttackDamage() {
        return 5.0;
    }

    public ItemStack getRequestBreedingItems() {
        ItemStack breedingItem = this.getBreedingItem().func_77946_l();
        ItemStackUtils.setSize(breedingItem, breedingItem.func_190916_E() * 8);
        return breedingItem;
    }

    public abstract ItemStack getBreedingItem();
}

