/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.planter;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingPlantation;
import com.minecolonies.coremod.colony.jobs.JobPlanter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.AirBlock;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkPlanter
extends AbstractEntityAICrafting<JobPlanter, BuildingPlantation> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final Integer PLANT_TO_REQUEST = 16;
    private static final double XP_PER_HARVEST = 1.0;
    private BlockPos workPos;

    public EntityAIWorkPlanter(@NotNull JobPlanter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.PLANTATION_FARM, this::farm, 20), new AITarget((IAIState)AIWorkerState.PLANTATION_PLANT, this::plant, 20));
        this.worker.func_98053_h(true);
    }

    private IAIState plant() {
        if (this.workPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.workPos.func_177984_a())) {
            return this.getState();
        }
        ItemStack currentStack = new ItemStack((IItemProvider)((BuildingPlantation)this.getOwnBuilding()).getCurrentPhase());
        int plantInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.func_77969_a(currentStack));
        if (plantInInv <= 0) {
            return AIWorkerState.START_WORKING;
        }
        if (this.world.func_175656_a(this.workPos.func_177984_a(), BlockUtils.getBlockStateFromStack((ItemStack)currentStack))) {
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), currentStack);
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState farm() {
        if (this.workPos == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.workPos.func_177984_a())) {
            return this.getState();
        }
        if (!this.holdEfficientTool(this.world.func_180495_p(this.workPos.func_177984_a()).func_177230_c(), this.workPos.func_177984_a())) {
            return AIWorkerState.START_WORKING;
        }
        if (!(this.world.func_180495_p(this.workPos.func_177984_a()).func_177230_c() instanceof AirBlock)) {
            this.mineBlock(this.workPos.func_177984_a());
            return this.getState();
        }
        for (ItemEntity item : this.world.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.worker.func_180425_c()).func_72321_a(4.0, 1.0, 4.0).func_72321_a(-4.0, -1.0, -4.0))) {
            if (item == null) continue;
            this.worker.getCitizenItemHandler().tryPickupItemEntity(item);
        }
        this.worker.getCitizenExperienceHandler().addExperience(1.0);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    public Class<BuildingPlantation> getExpectedBuildingClass() {
        return BuildingPlantation.class;
    }

    @Override
    protected IAIState decide() {
        int plantInInv;
        IAIState nextState = super.decide();
        if (nextState != AIWorkerState.START_WORKING) {
            return nextState;
        }
        BuildingPlantation plantation = (BuildingPlantation)this.getOwnBuilding();
        List<BlockPos> list = plantation.getPosForPhase(this.world);
        for (BlockPos pos : list) {
            if (!this.isAtLeastThreeHigh(pos)) continue;
            this.workPos = pos;
            return AIWorkerState.PLANTATION_FARM;
        }
        Item current = plantation.getCurrentPhase();
        int plantInBuilding = InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), itemStack -> itemStack.func_77969_a(new ItemStack((IItemProvider)current)));
        if (plantInBuilding + (plantInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.func_77969_a(new ItemStack((IItemProvider)current)))) <= 0) {
            this.requestPlantable(current);
            return AIWorkerState.START_WORKING;
        }
        if (plantInInv == 0 && plantInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(itemStack -> itemStack.func_77969_a(new ItemStack((IItemProvider)current)), Math.min(plantInBuilding, PLANT_TO_REQUEST));
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        for (BlockPos pos : list) {
            if (!(this.world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof AirBlock)) continue;
            this.workPos = pos;
            return AIWorkerState.PLANTATION_PLANT;
        }
        UnlockAbilityResearchEffect researchEffect = plantation.getColony().getResearchManager().getResearchEffects().getEffect("Plant 2", UnlockAbilityResearchEffect.class);
        if (researchEffect != null && researchEffect.getEffect().booleanValue()) {
            plantation.nextPhase();
        }
        return AIWorkerState.START_WORKING;
    }

    private void requestPlantable(Item current) {
        if (!((BuildingPlantation)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData(), q -> q.getRequest() instanceof Stack && ((Stack)q.getRequest()).getStack().func_77973_b() == current)) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((IItemProvider)current, PLANT_TO_REQUEST.intValue())));
        }
    }

    private boolean isAtLeastThreeHigh(BlockPos pos) {
        return !(this.world.func_180495_p(pos.func_177981_b(1)).func_177230_c() instanceof AirBlock) && !(this.world.func_180495_p(pos.func_177981_b(2)).func_177230_c() instanceof AirBlock) && !(this.world.func_180495_p(pos.func_177981_b(3)).func_177230_c() instanceof AirBlock);
    }
}

