/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.sifter;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.coremod.colony.jobs.JobSifter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSifter
extends AbstractEntityAIInteract<JobSifter, BuildingSifter> {
    private static final int MAX_LEVEL = 50;
    private static final int TICK_DELAY = 10;
    private static final int CHANCE_TO_DUMP_INV = 10;
    protected int progress = 0;

    public EntityAIWorkSifter(@NotNull JobSifter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 10), new AITarget((IAIState)AIWorkerState.START_WORKING, AIWorkerState.SIFT, 1), new AITarget((IAIState)AIWorkerState.SIFT, this::sift, 10));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingSifter> getExpectedBuildingClass() {
        return BuildingSifter.class;
    }

    private IAIState checkForSievableBlock(ItemStorage storage, BuildingSifter sifterBuilding) {
        Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && new Stack((ItemStack)stack).matches(storage.getItemStack());
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate)) {
            if (InventoryUtils.hasItemInProvider((ICapabilityProvider)sifterBuilding, predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            int requestQty = Math.min((sifterBuilding.getDailyQuantity() - sifterBuilding.getCurrentDailyQuantity()) * 2, 64);
            if (requestQty <= 0) {
                return AIWorkerState.START_WORKING;
            }
            ItemStack stack2 = storage.getItemStack();
            stack2.func_190920_e(requestQty);
            this.checkIfRequestForItemExistOrCreate(stack2);
            return AIWorkerState.NEEDS_ITEM;
        }
        return this.getState();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    protected IAIState sift() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        WorkerUtil.faceBlock(((BuildingSifter)this.getOwnBuilding()).getPosition(), this.worker);
        ++this.progress;
        BuildingSifter sifterBuilding = (BuildingSifter)this.getOwnBuilding();
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        if (sifterBuilding.getCurrentDailyQuantity() >= sifterBuilding.getDailyQuantity()) {
            return AIWorkerState.START_WORKING;
        }
        IAIState check = this.checkForSievableBlock(sifterBuilding.getSievableBlock(), sifterBuilding);
        if (this.progress > 50 - Math.min(this.getSecondarySkillLevel() / 5 + 1, 50)) {
            this.progress = 0;
            if (check == AIWorkerState.SIFT) {
                ItemStack result;
                sifterBuilding.setCurrentDailyQuantity(sifterBuilding.getCurrentDailyQuantity() + 1);
                if (sifterBuilding.getCurrentDailyQuantity() >= sifterBuilding.getDailyQuantity() || this.worker.getRandom().nextInt(100) < 10) {
                    this.incrementActionsDoneAndDecSaturation();
                }
                if (!(result = IColonyManager.getInstance().getCompatibilityManager().getRandomSieveResultForMeshAndBlock(sifterBuilding.getMesh().getA(), sifterBuilding.getSievableBlock(), 1 + (int)Math.round((double)this.getPrimarySkillLevel() / 10.0))).func_190926_b()) {
                    InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), result);
                }
                InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), sifterBuilding.getSievableBlock().getItemStack());
                if (this.worker.getRandom().nextDouble() * 100.0 < sifterBuilding.getMesh().getB()) {
                    sifterBuilding.resetMesh();
                    this.worker.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.sifter.meshbroke", new Object[0]));
                }
                this.worker.decreaseSaturationForContinuousAction();
                this.worker.getCitizenExperienceHandler().addExperience(0.2);
                return AIWorkerState.START_WORKING;
            }
            return check;
        }
        if (check == AIWorkerState.SIFT) {
            Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(sifterBuilding.getMesh().getA().getItemStack().func_77946_l(), sifterBuilding.getID()), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(sifterBuilding.getSievableBlock().getItemStack().func_77946_l(), sifterBuilding.getID().func_177977_b()), (Entity)this.worker);
            this.worker.func_184609_a(Hand.MAIN_HAND);
            SoundUtils.playSoundAtCitizen(this.world, ((BuildingSifter)this.getOwnBuilding()).getID(), SoundEvents.field_187746_da);
        }
        return this.getState();
    }
}

