/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.smelter;

import com.google.common.reflect.TypeToken;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSmeltery;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIUsesFurnace;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSmelter
extends AbstractEntityAIUsesFurnace<JobSmelter, BuildingSmeltery> {
    private static final int HIT_DELAY = 20;
    private static final int PROGRESS_MULTIPLIER = 50;
    private static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 5;
    private static final int CHEST_MAT_AMOUNT = 8;
    private static final int LEGS_MAT_AMOUNT = 7;
    private static final int HEAD_MAT_AMOUNT = 5;
    private static final int FEET_MAT_AMOUNT = 4;
    private static final double BASE_XP_GAIN = 5.0;
    public static final String ORE_LIST = "ores";
    private static final VisibleCitizenStatus SMELTING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/smelting.png"), "com.minecolonies.gui.visiblestatus.smelting");
    private int progress = 0;
    private static final int[] ENCHANTED_BOOK_CHANCE = new int[]{0, 10, 25, 40, 60};
    private static final int MAX_ENCHANTED_BOOK_CHANCE = 100;

    public EntityAIWorkSmelter(@NotNull JobSmelter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.SMELTER_SMELTING_ITEMS, this::smeltStuff, 20));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingSmeltery> getExpectedBuildingClass() {
        return BuildingSmeltery.class;
    }

    private IAIState smeltStuff() {
        int slot;
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.smeltingdown", new Object[0])});
        this.worker.getCitizenData().setVisibleStatus(SMELTING);
        if (this.walkToBuilding()) {
            return this.getState();
        }
        if (ItemStackUtils.isEmpty(this.worker.func_184586_b(Hand.MAIN_HAND)).booleanValue()) {
            this.progress = 0;
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), EntityAIWorkSmelter::isSmeltableToolOrWeapon) <= 0) {
                if (!InventoryUtils.hasItemInProvider(this.getOwnBuilding(), EntityAIWorkSmelter::isSmeltableToolOrWeapon)) {
                    return AIWorkerState.START_WORKING;
                }
                InventoryUtils.transferItemStackIntoNextFreeSlotFromProvider(this.getOwnBuilding(), InventoryUtils.findFirstSlotInProviderNotEmptyWith(this.getOwnBuilding(), EntityAIWorkSmelter::isSmeltableToolOrWeapon), (IItemHandler)this.worker.getInventoryCitizen());
            }
            if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), EntityAIWorkSmelter::isSmeltableToolOrWeapon)) == -1) {
                return AIWorkerState.START_WORKING;
            }
            this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, slot);
        }
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(((BuildingSmeltery)this.getOwnBuilding()).getPosition());
        if (this.progress >= this.getRequiredProgressForMakingRawMaterial()) {
            this.progress = 0;
            slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), EntityAIWorkSmelter::isSmeltableToolOrWeapon);
            if (slot == -1) {
                this.worker.func_184611_a(Hand.MAIN_HAND, ItemStackUtils.EMPTY);
                return AIWorkerState.START_WORKING;
            }
            ItemStack stack = this.worker.getInventoryCitizen().extractItem(slot, 1, false);
            Tuple<ItemStack, Integer> materialTuple = EntityAIWorkSmelter.getMaterialAndAmount(stack);
            ItemStack material = (ItemStack)materialTuple.func_76341_a();
            if (!ItemStackUtils.isEmpty(material).booleanValue()) {
                material.func_190920_e(((Integer)materialTuple.func_76340_b()).intValue());
                this.worker.getInventoryCitizen().insertItem(slot, material, false);
                if (((BuildingSmeltery)this.getOwnBuilding()).getBuildingLevel() > 0 && stack.func_77948_v() && ENCHANTED_BOOK_CHANCE[((BuildingSmeltery)this.getOwnBuilding()).getBuildingLevel() - 1] < new Random().nextInt(100)) {
                    ItemStack book = this.extractEnchantFromItem(stack);
                    this.worker.getInventoryCitizen().insertItem(InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), ItemStack::func_190926_b), book, false);
                }
                this.incrementActionsDoneAndDecSaturation();
            } else {
                this.worker.getInventoryCitizen().insertItem(slot, stack, false);
            }
            this.worker.decreaseSaturationForAction();
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.worker.func_184611_a(Hand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.START_WORKING;
        }
        ++this.progress;
        return this.getState();
    }

    private static Tuple<ItemStack, Integer> getMaterialAndAmount(ItemStack stack) {
        int amount = 1;
        Ingredient material = Ingredient.field_193370_a;
        if (stack.func_77973_b() instanceof SwordItem) {
            material = ((SwordItem)stack.func_77973_b()).func_200891_e().func_200924_f();
        } else if (stack.func_77973_b() instanceof ToolItem) {
            material = ((ToolItem)stack.func_77973_b()).func_200891_e().func_200924_f();
        } else if (stack.func_77973_b() instanceof ArmorItem) {
            material = ((ArmorItem)stack.func_77973_b()).func_200880_d().func_200898_c();
            EquipmentSlotType eq = ((ArmorItem)stack.func_77973_b()).func_185083_B_();
            if (eq == EquipmentSlotType.CHEST) {
                amount = 8;
            } else if (eq == EquipmentSlotType.LEGS) {
                amount = 7;
            } else if (eq == EquipmentSlotType.HEAD) {
                amount = 5;
            } else if (eq == EquipmentSlotType.FEET) {
                amount = 4;
            }
        }
        if (material.func_203189_d()) {
            return new Tuple((Object)ItemStack.field_190927_a, (Object)amount);
        }
        return new Tuple((Object)material.func_193365_a()[0], (Object)amount);
    }

    @Override
    protected void extractFromFurnace(FurnaceTileEntity furnace) {
        ItemStack copyStack;
        ItemStack ingots = new InvWrapper((IInventory)furnace).extractItem(2, 64, false);
        int multiplier = ((BuildingSmeltery)this.getOwnBuilding()).ingotMultiplier((int)((double)this.getSecondarySkillLevel() / 2.0), this.worker.getRandom());
        for (int amount = ingots.func_190916_E() * multiplier; amount > 0; amount -= copyStack.func_190916_E()) {
            copyStack = ingots.func_77946_l();
            if (amount < ingots.func_77976_d()) {
                copyStack.func_190920_e(amount);
            } else {
                copyStack.func_190920_e(ingots.func_77976_d());
            }
            ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)this.worker.getInventoryCitizen(), copyStack);
            if (!ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                resultStack.func_190920_e(resultStack.func_190916_E() + amount / multiplier);
                new InvWrapper((IInventory)furnace).setStackInSlot(2, resultStack);
                return;
            }
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.worker.decreaseSaturationForAction();
        }
    }

    @Override
    protected IAIState checkForAdditionalJobs() {
        int amountOfTools = InventoryUtils.getCountFromBuilding(this.getOwnBuilding(), EntityAIWorkSmelter::isSmeltableToolOrWeapon) + InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), EntityAIWorkSmelter::isSmeltableToolOrWeapon);
        if (amountOfTools > 0) {
            return AIWorkerState.SMELTER_SMELTING_ITEMS;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.idling", new Object[0])});
        this.setDelay(50);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        return new SmeltableOre(64 * ((BuildingSmeltery)this.getOwnBuilding()).getFurnaces().size());
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.IS_SMELTABLE.and(itemStack -> IColonyManager.getInstance().getCompatibilityManager().isOre(stack)).test(stack);
    }

    @Override
    public void requestSmeltable() {
        if (!((BuildingSmeltery)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(this.getSmeltAbleClass().getClass())) && !((BuildingSmeltery)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData(), req -> req.getShortDisplayString().getString().equals(LanguageHandler.format((String)"com.minecolonies.coremod.request.smeltableore", (Object[])new Object[0])))) {
            Map<String, List<ItemStorage>> allowedItems = ((BuildingSmeltery)this.getOwnBuilding()).getCopyOfAllowedItems();
            if (allowedItems.containsKey(ORE_LIST)) {
                List<ItemStack> requests = IColonyManager.getInstance().getCompatibilityManager().getSmeltableOres().stream().filter(storage -> !((List)allowedItems.get(ORE_LIST)).contains(storage)).map(ItemStorage::getItemStack).collect(Collectors.toList());
                if (requests.isEmpty()) {
                    if (this.worker.getCitizenData() != null) {
                        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.noore", new Object[0]), ChatPriority.BLOCKING));
                    }
                } else {
                    this.worker.getCitizenData().createRequestAsync(new StackList(requests, "com.minecolonies.coremod.request.smeltableore", 64 * ((BuildingSmeltery)this.getOwnBuilding()).getFurnaces().size(), 1));
                }
            } else {
                this.worker.getCitizenData().createRequestAsync(this.getSmeltAbleClass());
            }
        }
    }

    private static boolean isSmeltableToolOrWeapon(ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && (stack.func_77973_b() instanceof SwordItem || stack.func_77973_b() instanceof ToolItem || stack.func_77973_b() instanceof ArmorItem) && !stack.func_77973_b().isDamaged(stack);
    }

    private int getRequiredProgressForMakingRawMaterial() {
        return 50 / Math.min((int)((double)this.getPrimarySkillLevel() / 2.0) + 1, 50) * 5;
    }

    private ItemStack extractEnchantFromItem(ItemStack item) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)item);
        ItemStack books = new ItemStack((IItemProvider)Items.field_151134_bR);
        for (Map.Entry entry : enchants.entrySet()) {
            EnchantedBookItem.func_92115_a((ItemStack)books, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        this.worker.decreaseSaturationForAction();
        return books;
    }
}

