/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Disease;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.CircleParticleEffectMessage;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class EntityAISickTask
extends Goal {
    private static final int MIN_DIST_TO_HUT = 5;
    private static final int MIN_DIST_TO_HOSPITAL = 3;
    private static final long MINIMUM_DISTANCE_TO_HOSPITAL = 10L;
    private static final int REQUIRED_TIME_TO_CURE = 60;
    private static final int CHANCE_FOR_RANDOM_CURE = 10;
    private static final int GOING_TO_BED_ATTEMPTS = 20;
    private int waitingTicks = 0;
    private BlockPos usedBed;
    private final EntityCitizen citizen;
    private DiseaseState currentState = DiseaseState.IDLE;
    private BlockPos placeToPath;
    private int delayTicks = 0;

    public EntityAISickTask(EntityCitizen citizen) {
        this.citizen = citizen;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.SLEEP && !this.citizen.func_70608_bn()) {
            return false;
        }
        if (this.currentState != DiseaseState.IDLE) {
            return true;
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null && !this.citizen.getCitizenJobHandler().getColonyJob().canAIBeInterrupted()) {
            return false;
        }
        return this.citizen.getCitizenDiseaseHandler().isSick();
    }

    public void func_75246_d() {
        if (++this.delayTicks != 20) {
            return;
        }
        this.delayTicks = 0;
        ICitizenData citizenData = this.citizen.getCitizenData();
        if (citizenData == null) {
            return;
        }
        IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
        if (job != null) {
            job.setActive(false);
        }
        this.citizen.func_195064_c(new EffectInstance(Effects.field_76421_d, 600));
        switch (this.currentState) {
            case CHECK_FOR_CURE: {
                this.currentState = this.checkForCure(citizenData);
                return;
            }
            case GO_TO_HUT: {
                this.currentState = this.goToHut(citizenData);
                return;
            }
            case SEARCH_HOSPITAL: {
                this.currentState = this.searchHospital(citizenData);
                return;
            }
            case GO_TO_HOSPITAL: {
                this.currentState = this.goToHospital();
                return;
            }
            case WAIT_FOR_CURE: {
                this.currentState = this.waitForCure(citizenData);
                return;
            }
            case APPLY_CURE: {
                this.currentState = this.applyCure(citizenData);
                return;
            }
            case FIND_EMPTY_BED: {
                this.currentState = this.findEmptyBed();
                return;
            }
        }
        this.reset();
    }

    private DiseaseState findEmptyBed() {
        if (this.usedBed == null && this.citizen.getCitizenData() != null) {
            this.usedBed = this.citizen.getCitizenData().getBedPos();
            if (this.citizen.getCitizenData().getBedPos().equals((Object)BlockPos.field_177992_a)) {
                this.usedBed = null;
            }
        }
        BlockPos hospitalPos = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestHospital(this.citizen);
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
        if (hospital instanceof BuildingHospital) {
            if (this.usedBed != null && !((BuildingHospital)hospital).getBedList().contains(this.usedBed)) {
                this.usedBed = null;
            }
            if (this.usedBed == null) {
                for (BlockPos pos : ((BuildingHospital)hospital).getBedList()) {
                    World world = this.citizen.field_70170_p;
                    BlockState state = world.func_180495_p(pos);
                    if (!(state = state.func_177230_c().getExtendedState(state, (IBlockReader)world, pos)).func_177230_c().func_203417_a(BlockTags.field_219747_F) || ((Boolean)state.func_177229_b((IProperty)BedBlock.field_176471_b)).booleanValue() || !((BedPart)state.func_177229_b((IProperty)BedBlock.field_176472_a)).equals((Object)BedPart.HEAD) || !world.func_175623_d(pos.func_177984_a())) continue;
                    this.usedBed = pos;
                    ((BuildingHospital)hospital).registerPatient(this.usedBed, this.citizen.getCivilianID());
                    return DiseaseState.FIND_EMPTY_BED;
                }
                if (this.usedBed == null) {
                    return DiseaseState.WAIT_FOR_CURE;
                }
            }
            if (this.citizen.isWorkerAtSiteWithMove(this.usedBed, 3)) {
                ++this.waitingTicks;
                if (!this.citizen.getCitizenSleepHandler().trySleep(this.usedBed)) {
                    ((BuildingHospital)hospital).registerPatient(this.usedBed, 0);
                    this.citizen.getCitizenData().setBedPos(BlockPos.field_177992_a);
                    this.usedBed = null;
                }
            }
        }
        if (this.waitingTicks > 20) {
            this.waitingTicks = 0;
            return DiseaseState.WAIT_FOR_CURE;
        }
        return DiseaseState.FIND_EMPTY_BED;
    }

    private DiseaseState applyCure(ICitizenData citizenData) {
        if (this.checkForCure(citizenData) != DiseaseState.APPLY_CURE) {
            return DiseaseState.CHECK_FOR_CURE;
        }
        List<ItemStack> list = IColonyManager.getInstance().getCompatibilityManager().getDisease(this.citizen.getCitizenDiseaseHandler().getDisease()).getCure();
        this.citizen.func_184611_a(Hand.MAIN_HAND, list.get(this.citizen.getRandom().nextInt(list.size())));
        this.citizen.func_184609_a(Hand.MAIN_HAND);
        this.citizen.func_184185_a(SoundEvents.field_187682_dG, 1.0f, (float)SoundUtils.getRandomPitch(this.citizen.getRandom()));
        Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.citizen.func_213303_ch().func_72441_c(0.0, 2.0, 0.0), ParticleTypes.field_197632_y, this.waitingTicks), (Entity)this.citizen);
        ++this.waitingTicks;
        if (this.waitingTicks < 60) {
            return DiseaseState.APPLY_CURE;
        }
        this.cure(citizenData);
        return DiseaseState.IDLE;
    }

    private void cure(ICitizenData citizenData) {
        Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(this.citizen.getCitizenDiseaseHandler().getDisease());
        if (disease != null) {
            for (ItemStack cure : disease.getCure()) {
                int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, stack -> stack.func_77969_a(cure));
                if (slot == -1) continue;
                citizenData.getInventory().extractItem(slot, 1, false);
            }
        }
        if (this.usedBed != null) {
            BlockPos hospitalPos = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBestHospital(this.citizen);
            IColony colony = this.citizen.getCitizenColonyHandler().getColony();
            IBuilding hospital = colony.getBuildingManager().getBuilding(hospitalPos);
            ((BuildingHospital)hospital).registerPatient(this.usedBed, 0);
            this.usedBed = null;
            this.citizen.getCitizenData().setBedPos(BlockPos.field_177992_a);
        }
        this.citizen.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        citizenData.markDirty();
        this.citizen.getCitizenDiseaseHandler().cure();
        this.citizen.func_70606_j(this.citizen.func_110138_aP());
        this.reset();
    }

    private DiseaseState waitForCure(ICitizenData citizenData) {
        IBuilding building;
        BlockPos hospital;
        IColony colony = citizenData.getColony();
        this.placeToPath = colony.getBuildingManager().getBestHospital(this.citizen);
        if (this.placeToPath == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        DiseaseState state = this.checkForCure(citizenData);
        if (state == DiseaseState.APPLY_CURE) {
            return DiseaseState.APPLY_CURE;
        }
        if (state == DiseaseState.IDLE) {
            this.reset();
            return DiseaseState.IDLE;
        }
        if (this.citizen.getRandom().nextInt(10000) < 10) {
            this.cure(citizenData);
            return DiseaseState.IDLE;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() && (hospital = colony.getBuildingManager().getBestHospital(this.citizen)) != null && (building = colony.getBuildingManager().getBuilding(hospital)) instanceof BuildingHospital && !((BuildingHospital)building).getBedList().contains(this.citizen.getCitizenSleepHandler().getBedLocation())) {
            this.citizen.getCitizenSleepHandler().onWakeUp();
        }
        if (!this.citizen.getCitizenSleepHandler().isAsleep() && BlockPosUtil.getDistance2D(this.placeToPath, this.citizen.func_180425_c()) > 10L) {
            return DiseaseState.GO_TO_HOSPITAL;
        }
        if (!this.citizen.getCitizenSleepHandler().isAsleep()) {
            return DiseaseState.FIND_EMPTY_BED;
        }
        return DiseaseState.WAIT_FOR_CURE;
    }

    private DiseaseState goToHut(ICitizenData data) {
        IBuildingWorker buildingWorker = data.getWorkBuilding();
        if (buildingWorker == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() || this.citizen.isWorkerAtSiteWithMove(buildingWorker.getPosition(), 5)) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        return DiseaseState.GO_TO_HUT;
    }

    private DiseaseState goToHospital() {
        if (this.placeToPath == null) {
            return DiseaseState.SEARCH_HOSPITAL;
        }
        if (this.citizen.getCitizenSleepHandler().isAsleep() || this.citizen.getNavigator().func_75500_f() && this.citizen.isWorkerAtSiteWithMove(this.placeToPath, 3)) {
            return DiseaseState.WAIT_FOR_CURE;
        }
        return DiseaseState.SEARCH_HOSPITAL;
    }

    private DiseaseState searchHospital(ICitizenData citizenData) {
        IColony colony = citizenData.getColony();
        this.placeToPath = colony.getBuildingManager().getBestHospital(this.citizen);
        if (this.placeToPath == null) {
            String id = this.citizen.getCitizenDiseaseHandler().getDisease();
            if (id.isEmpty()) {
                return DiseaseState.IDLE;
            }
            Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(id);
            citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.nohospital", new Object[]{disease.getName(), disease.getCureString()}), (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.nohospital", new Object[0]), ChatPriority.BLOCKING));
            return DiseaseState.IDLE;
        }
        if (!this.citizen.getCitizenDiseaseHandler().getDisease().isEmpty()) {
            Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(this.citizen.getCitizenDiseaseHandler().getDisease());
            citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.waitingforcure", new Object[]{disease.getName(), disease.getCureString()}), (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.waitingforcure", new Object[0]), ChatPriority.BLOCKING));
        }
        return DiseaseState.GO_TO_HOSPITAL;
    }

    private DiseaseState checkForCure(ICitizenData citizenData) {
        String id = this.citizen.getCitizenDiseaseHandler().getDisease();
        if (id.isEmpty()) {
            if ((double)this.citizen.func_110143_aJ() > 6.0) {
                this.reset();
                this.currentState = DiseaseState.IDLE;
                return DiseaseState.IDLE;
            }
            return DiseaseState.GO_TO_HUT;
        }
        Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(id);
        for (ItemStack cure : disease.getCure()) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.citizen, stack -> stack.func_77969_a(cure));
            if (slot != -1) continue;
            if (this.citizen.getCitizenDiseaseHandler().isSick()) {
                return DiseaseState.GO_TO_HUT;
            }
            this.reset();
            this.currentState = DiseaseState.IDLE;
            return DiseaseState.IDLE;
        }
        return DiseaseState.APPLY_CURE;
    }

    private void reset() {
        this.waitingTicks = 0;
        this.citizen.func_184597_cx();
        this.citizen.func_184602_cy();
        this.citizen.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        this.placeToPath = null;
        this.currentState = DiseaseState.CHECK_FOR_CURE;
    }

    public void func_75249_e() {
        this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SICK);
    }

    public static enum DiseaseState {
        IDLE,
        CHECK_FOR_CURE,
        GO_TO_HUT,
        SEARCH_HOSPITAL,
        GO_TO_HOSPITAL,
        WAIT_FOR_CURE,
        FIND_EMPTY_BED,
        APPLY_CURE;

    }
}

