/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.interactionhandling.SimpleNotificationInteraction;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.research.AdditionModifierResearchEffect;
import java.util.Optional;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CitizenSleepHandler
implements ICitizenSleepHandler {
    private static final double Y_DIFF_WEIGHT = 1.5;
    private static final double TIME_PER_BLOCK = 6.0;
    private static final double MAX_NO_COMPLAIN_DISTANCE = 160.0;
    private final AbstractEntityCitizen citizen;

    public CitizenSleepHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public boolean isAsleep() {
        return (Boolean)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_IS_ASLEEP);
    }

    private void setIsAsleep(boolean isAsleep) {
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setAsleep(isAsleep);
        }
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_IS_ASLEEP, (Object)isAsleep);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getBedOrientationInDegrees() {
        BlockState state;
        BlockState blockState = state = this.getBedLocation() == null ? null : this.citizen.field_70170_p.func_180495_p(this.getBedLocation());
        if (state != null && state.func_177230_c().isBed(state, (IBlockReader)this.citizen.field_70170_p, this.getBedLocation(), (Entity)this.citizen)) {
            switch (state.func_177230_c().getBedDirection(state, (IWorldReader)this.citizen.field_70170_p, this.getBedLocation())) {
                case SOUTH: {
                    return 90.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
                case EAST: {
                    return 180.0f;
                }
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean trySleep(BlockPos bedLocation) {
        boolean isBed;
        BlockState state = WorldUtil.isEntityBlockLoaded((IWorld)this.citizen.field_70170_p, bedLocation) ? this.citizen.field_70170_p.func_180495_p(bedLocation) : null;
        boolean bl = isBed = state != null && state.func_177230_c().isBed(state, (IBlockReader)this.citizen.field_70170_p, bedLocation, (Entity)this.citizen);
        if (!isBed) {
            return false;
        }
        this.citizen.updatePose(Pose.SLEEPING);
        this.citizen.getNavigator().func_75499_g();
        this.citizen.func_70107_b((double)bedLocation.func_177958_n() + 0.5, (float)bedLocation.func_177956_o() + 0.8f, (double)bedLocation.func_177952_p() + 0.5);
        this.citizen.func_213369_d(bedLocation);
        this.citizen.func_213317_d(Vec3d.field_186680_a);
        this.citizen.field_70160_al = true;
        this.citizen.getCitizenItemHandler().removeHeldItem();
        this.setIsAsleep(true);
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setBedPos(bedLocation);
        }
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_BED_POS, (Object)bedLocation);
        this.citizen.getCitizenData().getColony().getCitizenManager().onCitizenSleep();
        return true;
    }

    @Override
    public void onWakeUp() {
        this.notifyCitizenHandlersOfWakeUp();
        if (!this.isAsleep()) {
            return;
        }
        this.citizen.updatePose(Pose.STANDING);
        this.citizen.func_213372_dw();
        this.spawnCitizenFromBed();
    }

    private void notifyCitizenHandlersOfWakeUp() {
        IBuilding homeBuilding;
        if (this.citizen.getCitizenColonyHandler().getWorkBuilding() != null) {
            this.citizen.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.working", new Object[0])});
            this.citizen.getCitizenColonyHandler().getWorkBuilding().onWakeUp();
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            this.citizen.getCitizenJobHandler().getColonyJob().onWakeUp();
        }
        if ((homeBuilding = this.citizen.getCitizenColonyHandler().getHomeBuilding()) != null) {
            homeBuilding.onWakeUp();
        }
    }

    private void spawnCitizenFromBed() {
        BlockPos spawn;
        if (!this.getBedLocation().equals((Object)BlockPos.field_177992_a) && this.citizen.field_70170_p.func_180495_p(this.getBedLocation()).func_177230_c().func_203417_a(BlockTags.field_219747_F)) {
            Optional spawnVec = BedBlock.func_220172_a(ModEntities.CITIZEN, (IWorldReader)this.citizen.field_70170_p, (BlockPos)this.getBedLocation(), (int)0);
            spawn = spawnVec.map(BlockPos::new).orElseGet(() -> this.getBedLocation().func_177984_a());
        } else {
            spawn = this.citizen.func_180425_c();
        }
        if (spawn != null && !spawn.equals((Object)BlockPos.field_177992_a)) {
            this.citizen.func_70107_b((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 0.5, (double)spawn.func_177952_p() + 0.5);
        }
        this.setIsAsleep(false);
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setBedPos(new BlockPos(0, 0, 0));
        }
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
    }

    @Override
    public BlockPos findHomePos() {
        BlockPos pos = this.citizen.func_213384_dI();
        if (pos.equals((Object)BlockPos.field_177992_a)) {
            if (this.citizen.getCitizenColonyHandler().getColony().hasTownHall()) {
                return this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getTownHall().getPosition();
            }
            return this.citizen.getCitizenColonyHandler().getColony().getCenter();
        }
        return pos;
    }

    @Override
    public BlockPos getBedLocation() {
        return (BlockPos)this.citizen.func_184212_Q().func_187225_a(AbstractEntityCitizen.DATA_BED_POS);
    }

    @Override
    public float getRenderOffsetX() {
        Direction Direction2;
        if (!this.isAsleep()) {
            return 0.0f;
        }
        BlockState state = WorldUtil.isEntityBlockLoaded((IWorld)this.citizen.field_70170_p, this.getBedLocation()) ? this.citizen.field_70170_p.func_180495_p(this.getBedLocation()) : null;
        boolean isBed = state != null && state.func_177230_c().isBed(state, (IBlockReader)this.citizen.field_70170_p, this.getBedLocation(), (Entity)this.citizen);
        Direction direction = Direction2 = isBed && state.func_177230_c() instanceof HorizontalBlock ? (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D) : null;
        if (Direction2 == null) {
            return 0.0f;
        }
        return -1.5f * (float)Direction2.func_82601_c();
    }

    @Override
    public float getRenderOffsetZ() {
        Direction Direction2;
        if (!this.isAsleep()) {
            return 0.0f;
        }
        BlockState state = WorldUtil.isEntityBlockLoaded((IWorld)this.citizen.field_70170_p, this.getBedLocation()) ? this.citizen.field_70170_p.func_180495_p(this.getBedLocation()) : null;
        boolean isBed = state != null && state.func_177230_c().isBed(state, (IBlockReader)this.citizen.field_70170_p, this.getBedLocation(), (Entity)this.citizen);
        Direction direction = Direction2 = isBed && state.func_177230_c() instanceof HorizontalBlock ? (Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D) : null;
        if (Direction2 == null) {
            return 0.0f;
        }
        return -1.5f * (float)Direction2.func_82599_e();
    }

    @Override
    public boolean shouldGoSleep() {
        BlockPos homePos = this.findHomePos();
        BlockPos citizenPos = this.citizen.func_180425_c();
        int additionalDist = 0;
        if (this.citizen.getCitizenData().getJob() instanceof JobMiner && this.citizen.getCitizenData().getWorkBuilding().getPosition().func_177956_o() - 20 > citizenPos.func_177956_o()) {
            BlockPos workPos = this.citizen.getCitizenData().getWorkBuilding().getID();
            additionalDist = (int)BlockPosUtil.getDistance2D(citizenPos, workPos) + Math.abs(citizenPos.func_177956_o() - workPos.func_177956_o()) * 3;
            citizenPos = workPos;
        }
        int xDiff = Math.abs(homePos.func_177958_n() - citizenPos.func_177958_n());
        int zDiff = Math.abs(homePos.func_177952_p() - citizenPos.func_177952_p());
        int yDiff = (int)((double)Math.abs(homePos.func_177956_o() - citizenPos.func_177956_o()) * 1.5);
        double timeNeeded = (Math.sqrt(xDiff * xDiff + zDiff * zDiff + yDiff * yDiff) + (double)additionalDist) * 6.0;
        AdditionModifierResearchEffect effect = this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffect("Working day h", AdditionModifierResearchEffect.class);
        double timeLeft = (effect == null ? 12600.0 : 12600.0 + effect.getEffect() * 1000.0) - (double)(this.citizen.field_70170_p.func_72820_D() % 24000L);
        if (timeLeft <= 0.0 || timeLeft - timeNeeded <= 0.0) {
            double workHomeDistance;
            if (this.citizen.getCitizenData().getWorkBuilding() != null && (workHomeDistance = Math.sqrt(BlockPosUtil.getDistanceSquared(homePos, this.citizen.getCitizenData().getWorkBuilding().getID()))) > 160.0) {
                this.citizen.getCitizenData().triggerInteraction(new SimpleNotificationInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.hometoofar", new Object[0]), ChatPriority.IMPORTANT));
            }
            return true;
        }
        return false;
    }
}

