/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs.aitasks;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.coremod.MineColonies;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class EntityAIAttackArcher
extends Goal {
    private static final int MAX_ATTACK_DELAY = 80;
    private static final double ARROW_PIERCE_DIFFICULTY = 3.0;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double HALF_ROTATION = 180.0;
    private static final double ATTACK_SPEED = 1.1;
    private static final double AIM_HEIGHT = 2.0;
    private static final double ARROW_SPEED = 1.4;
    private static final double HIT_CHANCE = 10.0;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = (double)0.2f;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private static final double SPEED_FOR_DIST = 35.0;
    private final AbstractEntityMinecoloniesMob entity;
    private LivingEntity target;
    private int lastAttack = 0;
    private int tickTimer = 0;

    public EntityAIAttackArcher(AbstractEntityMinecoloniesMob creatureIn) {
        this.entity = creatureIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        this.target = this.entity.func_70638_az() != null ? this.entity.func_70638_az() : this.entity.func_94060_bK();
        return this.target != null;
    }

    public boolean func_75253_b() {
        this.target = this.entity.func_70638_az();
        if (this.target != null && this.target.func_70089_S() && this.entity.func_70089_S() && this.entity.func_70685_l((Entity)this.target)) {
            this.attack(this.target);
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.attack(this.target);
    }

    private void attack(LivingEntity target) {
        if (this.tickTimer > 0) {
            --this.tickTimer;
            --this.lastAttack;
            return;
        }
        this.tickTimer = 10;
        if ((double)this.entity.func_70032_d((Entity)target) >= 20.0 * Math.max(this.entity.getDifficulty(), 2.0) && !EntityUtils.isFlying(target) || !this.entity.func_70685_l((Entity)target)) {
            this.entity.getNavigator().func_75497_a((Entity)target, 1.1);
        } else {
            if ((double)this.entity.func_70032_d((Entity)target) < 20.0) {
                this.entity.getNavigator().func_75499_g();
            }
            if (this.lastAttack <= 0 && this.entity.func_70685_l((Entity)target)) {
                AbstractArrowEntity arrowEntity = (AbstractArrowEntity)ModEntities.MC_NORMAL_ARROW.func_200721_a(target.field_70170_p);
                arrowEntity.func_212361_a((Entity)this.entity);
                ItemStack bow = this.entity.func_184586_b(Hand.MAIN_HAND);
                if (bow.func_77973_b() instanceof BowItem) {
                    arrowEntity = ((BowItem)bow.func_77973_b()).customeArrow(arrowEntity);
                }
                arrowEntity.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u + 1.0, this.entity.field_70161_v);
                double xVector = target.field_70165_t - this.entity.field_70165_t;
                double yVector = target.func_174813_aQ().field_72338_b + (double)target.func_213302_cg() / 2.0 - arrowEntity.field_70163_u;
                double zVector = target.field_70161_v - this.entity.field_70161_v;
                double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
                double dist3d = MathHelper.func_76133_a((double)(yVector * yVector + xVector * xVector + zVector * zVector));
                arrowEntity.func_70239_b(this.entity.func_110148_a(RaiderMobUtils.MOB_ATTACK_DAMAGE).func_111126_e());
                if (this.entity.getDifficulty() > 3.0) {
                    arrowEntity.func_213872_b((byte)2);
                }
                if (EntityUtils.isFlying(target)) {
                    arrowEntity.func_70015_d(200);
                    arrowEntity.func_70239_b(20.0);
                    this.lastAttack = 10;
                } else {
                    this.lastAttack = this.getAttackDelay();
                }
                arrowEntity.func_70186_c(xVector, yVector + distance * (double)0.2f, zVector, (float)(1.4 + dist3d / 35.0), 10.0f);
                this.entity.func_70625_a((Entity)target, 180.0f, 180.0f);
                this.entity.func_70671_ap().func_75651_a((Entity)target, 180.0f, 180.0f);
                CompatibilityUtils.addEntity(CompatibilityUtils.getWorldFromEntity((Entity)this.entity), (Entity)arrowEntity);
                this.entity.func_184609_a(Hand.MAIN_HAND);
                this.entity.func_184185_a(SoundEvents.field_187866_fi, 1.0f, (float)this.getRandomPitch());
            }
        }
        if (this.lastAttack > 0) {
            --this.lastAttack;
        }
    }

    protected int getAttackDelay() {
        return 80 - (Integer)MineColonies.getConfig().getCommon().barbarianHordeDifficulty.get() * 4;
    }

    private double getRandomPitch() {
        return 1.0 / (this.entity.func_70681_au().nextDouble() * 0.4 + 0.8);
    }
}

