/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs.aitasks;

import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.entity.pathfinding.GeneralEntityWalkToProxy;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EntityAIWalkToRandomHuts
extends Goal {
    private static final int THREE_MINUTES_TICKS = 3600;
    protected final AbstractEntityMinecoloniesMob entity;
    protected final World world;
    protected final double speed;
    private BlockPos targetBlock;
    private GeneralEntityWalkToProxy proxy;
    private int lastIndex = -1;
    private int stuckTime = 1;
    private static int UPDATE_INTERVAL = 40;
    int tickTimer = 0;
    private int campFireWalkTimer = 0;
    boolean hadPath = false;

    public EntityAIWalkToRandomHuts(AbstractEntityMinecoloniesMob creatureIn, double speedIn) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.world = creatureIn.func_130014_f_();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.campFireWalkTimer = this.world.field_73012_v.nextInt(1000);
        this.proxy = new GeneralEntityWalkToProxy(this.entity);
    }

    public boolean func_75250_a() {
        if (!this.entity.func_70089_S() || this.entity.getColony() == null || this.entity.func_70638_az() != null && !EntityUtils.isFlying(this.entity.func_70638_az()) || this.entity.func_94060_bK() != null && !EntityUtils.isFlying(this.entity.func_70638_az())) {
            return false;
        }
        if (this.entity.getColony() != null) {
            IColonyEvent event = this.entity.getColony().getEventManager().getEventByID(this.entity.getEventID());
            if (event == null) {
                return false;
            }
            if (event.getStatus() == EventStatus.PREPARING && event instanceof HordeRaidEvent) {
                this.walkToCampFire();
                return false;
            }
        }
        return true;
    }

    public void func_75246_d() {
        if (++this.tickTimer < UPDATE_INTERVAL) {
            return;
        }
        this.tickTimer = 0;
        if (this.isEntityAtSiteWithMove(this.targetBlock, 2)) {
            this.targetBlock = this.getRandomBuilding();
            this.resetStuckCounters();
        }
    }

    private void resetStuckCounters() {
        this.stuckTime = 0;
        this.lastIndex = -1;
        this.entity.setStuckCounter(0);
    }

    public void func_75249_e() {
        this.targetBlock = this.getRandomBuilding();
        this.hadPath = false;
        this.resetStuckCounters();
    }

    public void func_75251_c() {
        this.targetBlock = this.getRandomBuilding();
        this.hadPath = false;
        this.resetStuckCounters();
    }

    private boolean isEntityAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.entity.func_70644_a(Constants.LEVITATION_EFFECT)) {
            return true;
        }
        if (this.proxy.walkToBlock(site, range, true)) {
            return true;
        }
        if (this.entity.getNavigator().func_75505_d() == null || this.entity.getNavigator().func_75505_d().func_75879_b()) {
            this.lastIndex = -1;
            if (!this.hadPath) {
                ++this.stuckTime;
            }
        } else {
            if (this.entity.getNavigator().func_75505_d().func_75873_e() == this.lastIndex) {
                ++this.stuckTime;
            } else if (this.entity.getNavigator().func_75505_d().func_75873_e() > 5) {
                this.resetStuckCounters();
            }
            this.lastIndex = this.entity.getNavigator().func_75505_d().func_75873_e();
        }
        boolean bl = this.hadPath = this.entity.getNavigator().func_75505_d() != null && !this.entity.getNavigator().func_75505_d().func_75879_b();
        return this.stuckTime * UPDATE_INTERVAL > 3600;
    }

    private BlockPos getRandomBuilding() {
        if (this.entity.getColony() == null) {
            return null;
        }
        return this.entity.getColony().getRaiderManager().getRandomBuilding();
    }

    private void walkToCampFire() {
        this.campFireWalkTimer -= 4;
        if (this.campFireWalkTimer < 0) {
            BlockPos campFire = ((HordeRaidEvent)this.entity.getColony().getEventManager().getEventByID(this.entity.getEventID())).getRandomCampfire();
            if (campFire == null) {
                return;
            }
            this.campFireWalkTimer = this.world.field_73012_v.nextInt(1000);
            this.targetBlock = BlockPosUtil.getRandomPosition(this.world, campFire, BlockPos.field_177992_a, 3, 6);
            if (this.targetBlock != null && this.targetBlock != BlockPos.field_177992_a) {
                this.isEntityAtSiteWithMove(this.targetBlock, 3);
            }
        }
    }
}

