/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.datagenerators.sounds.SoundsJson;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.coremod.generation.DataGeneratorConstants;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import org.jetbrains.annotations.NotNull;

public class DefaultSoundProvider
implements IDataProvider {
    private final DataGenerator generator;

    public DefaultSoundProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        JsonObject sounds = new JsonObject();
        ArrayList<String> defaultMaleSounds = new ArrayList<String>();
        defaultMaleSounds.add("minecolonies:mob/citizen/male/say1");
        defaultMaleSounds.add("minecolonies:mob/citizen/male/say2");
        defaultMaleSounds.add("minecolonies:mob/citizen/male/say3");
        ArrayList<String> defaultFemaleSounds = new ArrayList<String>();
        defaultFemaleSounds.add("minecolonies:mob/citizen/female/say1");
        defaultFemaleSounds.add("minecolonies:mob/citizen/female/say2");
        defaultFemaleSounds.add("minecolonies:mob/citizen/female/say3");
        ArrayList<String> childSounds = new ArrayList<String>();
        childSounds.add("minecolonies:mob/citizen/child/laugh1");
        childSounds.add("minecolonies:mob/citizen/child/laugh2");
        for (JobEntry job : IJobRegistry.getInstance().getValues()) {
            if (!job.getRegistryName().func_110624_b().equals("minecolonies") || job.getRegistryName().func_110623_a().equals("placeholder")) continue;
            for (EventType soundEvents : EventType.values()) {
                sounds.add("mob." + job.getRegistryName().func_110623_a() + ".male." + soundEvents.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), defaultMaleSounds));
                sounds.add("mob." + job.getRegistryName().func_110623_a() + ".female." + soundEvents.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), defaultFemaleSounds));
            }
        }
        for (EventType eventType : EventType.values()) {
            sounds.add("mob.citizen.male." + eventType.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), defaultMaleSounds));
            sounds.add("mob.citizen.female." + eventType.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), defaultFemaleSounds));
        }
        for (EventType eventType : EventType.values()) {
            sounds.add("mob.child.male." + eventType.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), childSounds));
            sounds.add("mob.child.female." + eventType.name().toLowerCase(Locale.US), (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), childSounds));
        }
        for (Enum enum_ : RaiderType.values()) {
            sounds.add("mob." + enum_.name().toLowerCase(Locale.US) + ".death", (JsonElement)SoundsJson.createSoundJson((String)"hostile", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/barbarian/death")));
            sounds.add("mob." + enum_.name().toLowerCase(Locale.US) + ".say", (JsonElement)SoundsJson.createSoundJson((String)"hostile", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/barbarian/say")));
            sounds.add("mob." + enum_.name().toLowerCase(Locale.US) + ".hurt", (JsonElement)SoundsJson.createSoundJson((String)"hostile", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/barbarian/hurt1", (Object)"minecolonies:mob/barbarian/hurt2", (Object)"minecolonies:mob/barbarian/hurt3", (Object)"minecolonies:mob/barbarian/hurt4")));
        }
        sounds.add("mob.citizen.snore", (JsonElement)SoundsJson.createSoundJson((String)"neutral", (JsonObject)this.getDefaultProperties(), (List)ImmutableList.of((Object)"minecolonies:mob/citizen/snore")));
        JsonObject tavernProperties = this.getDefaultProperties();
        tavernProperties.addProperty("attenuation_distance", (Number)23);
        tavernProperties.addProperty("stream", Boolean.valueOf(true));
        tavernProperties.addProperty("comment", "Credits to Darren Curtis - Fireside Tales");
        sounds.add("tile.tavern.tavern_theme", (JsonElement)SoundsJson.createSoundJson((String)"music", (JsonObject)tavernProperties, (List)ImmutableList.of((Object)"minecolonies:tile/tavern/tavern_theme")));
        JsonObject desertRaidProperties = this.getDefaultProperties();
        desertRaidProperties.addProperty("stream", Boolean.valueOf(true));
        sounds.add("raid.desert.desert_raid", (JsonElement)SoundsJson.createSoundJson((String)"music", (JsonObject)desertRaidProperties, (List)ImmutableList.of((Object)"minecolonies:raid/desert/desert_raid")));
        JsonObject desertRaidStartProperties = this.getDefaultProperties();
        desertRaidStartProperties.addProperty("stream", Boolean.valueOf(true));
        sounds.add("raid.desert.desert_raid_warning", (JsonElement)SoundsJson.createSoundJson((String)"music", (JsonObject)desertRaidStartProperties, (List)ImmutableList.of((Object)"minecolonies:raid/desert/desert_raid_warning")));
        JsonObject jsonObject = this.getDefaultProperties();
        jsonObject.addProperty("stream", Boolean.valueOf(true));
        sounds.add("raid.desert.desert_raid_victory", (JsonElement)SoundsJson.createSoundJson((String)"music", (JsonObject)jsonObject, (List)ImmutableList.of((Object)"minecolonies:raid/desert/desert_raid_victory")));
        JsonObject amazonRaidProperties = this.getDefaultProperties();
        amazonRaidProperties.addProperty("stream", Boolean.valueOf(true));
        sounds.add("raid.amazon.amazon_raid", (JsonElement)SoundsJson.createSoundJson((String)"music", (JsonObject)amazonRaidProperties, (List)ImmutableList.of((Object)"minecolonies:raid/amazon/amazon_raid")));
        Path savePath = this.generator.func_200391_b().resolve("assets/minecolonies/").resolve("sounds.json");
        IDataProvider.func_218426_a((Gson)DataGeneratorConstants.GSON, (DirectoryCache)cache, (JsonElement)sounds, (Path)savePath);
    }

    @NotNull
    public String func_200397_b() {
        return "Default Sound Json Provider";
    }

    private JsonObject getDefaultProperties() {
        JsonObject properties = new JsonObject();
        properties.addProperty("stream", Boolean.valueOf(false));
        return properties;
    }
}

