/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSupplyChestDeployer
extends AbstractItemMinecolonies {
    private static final String SUPPLY_SHIP_STRUCTURE_NAME = "supplyship";
    private static final int OFFSET_DISTANCE = 14;
    private static final int OFFSET_LEFT = 5;
    private static final int OFFSET_Y = -2;
    private static final int SCAN_HEIGHT = 7;

    public ItemSupplyChestDeployer(Item.Properties properties) {
        super("supplychestdeployer", properties.func_200917_a(1).func_200916_a(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ctx.func_195991_k().field_72995_K) {
            if (!((Boolean)MineColonies.getConfig().getCommon().allowOtherDimColonies.get()).booleanValue() && ctx.func_195991_k().func_201675_m().func_186058_p().func_186068_a() != 0) {
                return ActionResultType.FAIL;
            }
            this.placeSupplyShip(ctx.func_195995_a(), ctx.func_195999_j().func_174811_aO());
        }
        return ActionResultType.FAIL;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            if (!((Boolean)MineColonies.getConfig().getCommon().allowOtherDimColonies.get()).booleanValue() && worldIn.func_201675_m().func_186058_p().func_186068_a() != 0) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)playerIn, (String)"com.minecolonies.coremod.dimension.no", (Object[])new Object[0]);
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
            this.placeSupplyShip(null, playerIn.func_174811_aO());
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    private void placeSupplyShip(@Nullable BlockPos pos, @NotNull Direction direction) {
        int rotations;
        BlockPos tempPos;
        if (pos == null) {
            MineColonies.proxy.openBuildToolWindow(null, SUPPLY_SHIP_STRUCTURE_NAME, 0);
            return;
        }
        switch (direction) {
            case SOUTH: {
                tempPos = pos.func_177982_a(5, -2, 14);
                rotations = 3;
                break;
            }
            case NORTH: {
                tempPos = pos.func_177982_a(-5, -2, -14);
                rotations = 1;
                break;
            }
            case EAST: {
                tempPos = pos.func_177982_a(14, -2, -5);
                rotations = 2;
                break;
            }
            default: {
                tempPos = pos.func_177982_a(-14, -2, 5);
                rotations = 0;
            }
        }
        MineColonies.proxy.openBuildToolWindow(tempPos, SUPPLY_SHIP_STRUCTURE_NAME, rotations);
    }

    public static boolean canShipBePlaced(@NotNull World world, @NotNull BlockPos pos, BlockPos size, @NotNull List<PlacementError> placementErrorList, PlayerEntity placer) {
        int x;
        int z;
        for (z = pos.func_177952_p() - size.func_177952_p() / 2 + 1; z < pos.func_177952_p() + size.func_177952_p() / 2 + 1; ++z) {
            for (x = pos.func_177958_n() - size.func_177958_n() / 2 + 1; x < pos.func_177958_n() + size.func_177958_n() / 2 + 1; ++x) {
                ItemSupplyChestDeployer.checkIfWaterAndNotInColony(world, new BlockPos(x, pos.func_177956_o() + 2, z), placementErrorList, placer);
            }
        }
        for (z = pos.func_177952_p() - size.func_177952_p() / 2 + 1; z < pos.func_177952_p() + size.func_177952_p() / 2 + 1; ++z) {
            for (x = pos.func_177958_n() - size.func_177958_n() / 2 + 1; x < pos.func_177958_n() + size.func_177958_n() / 2 + 1; ++x) {
                if (world.func_175623_d(new BlockPos(x, pos.func_177956_o() + 7, z))) continue;
                PlacementError placementError = new PlacementError(PlacementError.PlacementErrorType.NEEDS_AIR_ABOVE, new BlockPos(x, pos.func_177956_o() + 7, z));
                placementErrorList.add(placementError);
            }
        }
        return placementErrorList.isEmpty();
    }

    private static void checkIfWaterAndNotInColony(World world, BlockPos pos, @NotNull List<PlacementError> placementErrorList, PlayerEntity placer) {
        PlacementError placementError;
        boolean isWater = BlockUtils.isWater((BlockState)world.func_180495_p(pos));
        boolean notInAnyColony = ItemSupplyChestDeployer.hasPlacePermission(world, pos, placer);
        if (!isWater) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.NOT_WATER, pos);
            placementErrorList.add(placementError);
        }
        if (!notInAnyColony) {
            placementError = new PlacementError(PlacementError.PlacementErrorType.INSIDE_COLONY, pos);
            placementErrorList.add(placementError);
        }
    }

    private static boolean hasPlacePermission(World world, BlockPos pos, PlayerEntity placer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
        return colony == null || colony.getPermissions().hasPermission(placer, Action.PLACE_BLOCKS);
    }
}

