/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.client.BlockParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.CircleParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.ColonyStylesMessage;
import com.minecolonies.coremod.network.messages.client.CompostParticleMessage;
import com.minecolonies.coremod.network.messages.client.CreateColonyMessage;
import com.minecolonies.coremod.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.OpenSuggestionWindowMessage;
import com.minecolonies.coremod.network.messages.client.PlayMusicMessage;
import com.minecolonies.coremod.network.messages.client.ServerUUIDMessage;
import com.minecolonies.coremod.network.messages.client.SleepingParticleMessage;
import com.minecolonies.coremod.network.messages.client.StopMusicMessage;
import com.minecolonies.coremod.network.messages.client.StreamParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.UpdateChunkCapabilityMessage;
import com.minecolonies.coremod.network.messages.client.UpdateChunkRangeCapabilityMessage;
import com.minecolonies.coremod.network.messages.client.UpdateClientWithRecipesMessage;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewBuildingViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewCitizenViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveBuildingMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveCitizenMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewWorkOrderMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyVisitorViewDataMessage;
import com.minecolonies.coremod.network.messages.client.colony.PlayMusicAtPosMessage;
import com.minecolonies.coremod.network.messages.client.colony.building.guard.GuardMobAttackListMessage;
import com.minecolonies.coremod.network.messages.server.BuildToolPasteMessage;
import com.minecolonies.coremod.network.messages.server.BuildToolPlaceMessage;
import com.minecolonies.coremod.network.messages.server.ClickGuiButtonTriggerMessage;
import com.minecolonies.coremod.network.messages.server.DecorationBuildRequestMessage;
import com.minecolonies.coremod.network.messages.server.DecorationControllerUpdateMessage;
import com.minecolonies.coremod.network.messages.server.DirectPlaceMessage;
import com.minecolonies.coremod.network.messages.server.FieldPlotResizeMessage;
import com.minecolonies.coremod.network.messages.server.OpenGuiWindowTriggerMessage;
import com.minecolonies.coremod.network.messages.server.RemoveFromRallyingListMessage;
import com.minecolonies.coremod.network.messages.server.ToggleBannerRallyGuardsMessage;
import com.minecolonies.coremod.network.messages.server.TransferRecipeCrafingTeachingMessage;
import com.minecolonies.coremod.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import com.minecolonies.coremod.network.messages.server.colony.ColonyDeleteOwnMessage;
import com.minecolonies.coremod.network.messages.server.colony.ColonyFlagChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.GuardScepterMessage;
import com.minecolonies.coremod.network.messages.server.colony.HireMercenaryMessage;
import com.minecolonies.coremod.network.messages.server.colony.HireSpiesMessage;
import com.minecolonies.coremod.network.messages.server.colony.InteractionResponse;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.server.colony.TeamColonyColorChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.TeleportToColonyMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleHelpMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleHousingMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleJobMessage;
import com.minecolonies.coremod.network.messages.server.colony.ToggleMoveInMessage;
import com.minecolonies.coremod.network.messages.server.colony.TownHallRenameMessage;
import com.minecolonies.coremod.network.messages.server.colony.UpdateRequestStateMessage;
import com.minecolonies.coremod.network.messages.server.colony.WorkOrderChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.AddMinimumStockToBuildingMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.AssignFilterableItemMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildingSetStyleMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.ChangeDeliveryPriorityMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.ForcePickupMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.HireFireMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.HutRenameMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.OpenCraftingGUIMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.RecallCitizenHutMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.RemoveMinimumStockFromBuildingMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.TransferItemsRequestMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.beekeeper.BeekeeperScepterMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.beekeeper.BeekeeperSetHarvestHoneycombsMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.composter.ComposterRetrievalMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.cowboy.CowboySetMilkCowsMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.crusher.CrusherSetModeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.enchanter.EnchanterWorkerSetMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.AssignFieldMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.AssignmentModeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.RequestFertilizerMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.guard.GuardRecalculateMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.guard.GuardTaskMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.guard.MobEntryChangeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.herder.HerderSetBreedingMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.home.AssignUnassignMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.lumberjack.LumberjackReplantSaplingToggleMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.lumberjack.LumberjackRestrictionToggleMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.lumberjack.LumberjackScepterMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.miner.MinerSetLevelMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.plantation.PlantationSetPhaseMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.postbox.PostBoxRequestMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.shepherd.ShepherdSetDyeSheepsMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.sifter.SifterSettingsMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.university.TryResearchMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.warehouse.SortWarehouseMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.warehouse.UpgradeWarehouseMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.BuildingHiringModeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.ChangeRecipePriorityMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.RecallCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.AdjustSkillCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.PauseCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.RecallSingleCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.RestartCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.citizen.TransferItemsToCitizenRequestMessage;
import com.minecolonies.coremod.network.messages.splitting.SplitPacketMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkChannel {
    private static final String LATEST_PROTO_VER = "1.0";
    private static final String ACCEPTED_PROTO_VERS = "1.0";
    private final SimpleChannel rawChannel;
    private final Map<Integer, NetworkingMessageEntry<?>> messagesTypes = Maps.newHashMap();
    private final Map<Class<? extends IMessage>, Integer> messageTypeToIdMap = Maps.newHashMap();
    private final Cache<Integer, Map<Integer, byte[]>> messageCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).concurrencyLevel(8).build();
    private final AtomicInteger messageCounter = new AtomicInteger();

    public NetworkChannel(String channelName) {
        this.rawChannel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("minecolonies", channelName), () -> "1.0", "1.0"::equals, "1.0"::equals);
    }

    public void registerCommonMessages() {
        this.setupInternalMessages();
        int idx = 0;
        this.registerMessage(++idx, ServerUUIDMessage.class, ServerUUIDMessage::new);
        this.registerMessage(++idx, ColonyViewMessage.class, ColonyViewMessage::new);
        this.registerMessage(++idx, ColonyViewCitizenViewMessage.class, ColonyViewCitizenViewMessage::new);
        this.registerMessage(++idx, ColonyViewRemoveCitizenMessage.class, ColonyViewRemoveCitizenMessage::new);
        this.registerMessage(++idx, ColonyViewBuildingViewMessage.class, ColonyViewBuildingViewMessage::new);
        this.registerMessage(++idx, ColonyViewRemoveBuildingMessage.class, ColonyViewRemoveBuildingMessage::new);
        this.registerMessage(++idx, PermissionsMessage.View.class, PermissionsMessage.View::new);
        this.registerMessage(++idx, ColonyStylesMessage.class, ColonyStylesMessage::new);
        this.registerMessage(++idx, ColonyViewWorkOrderMessage.class, ColonyViewWorkOrderMessage::new);
        this.registerMessage(++idx, ColonyViewRemoveWorkOrderMessage.class, ColonyViewRemoveWorkOrderMessage::new);
        this.registerMessage(++idx, UpdateChunkCapabilityMessage.class, UpdateChunkCapabilityMessage::new);
        this.registerMessage(++idx, GuardMobAttackListMessage.class, GuardMobAttackListMessage::new);
        this.registerMessage(++idx, BeekeeperSetHarvestHoneycombsMessage.class, BeekeeperSetHarvestHoneycombsMessage::new);
        this.registerMessage(++idx, PermissionsMessage.Permission.class, PermissionsMessage.Permission::new);
        this.registerMessage(++idx, PermissionsMessage.AddPlayer.class, PermissionsMessage.AddPlayer::new);
        this.registerMessage(++idx, PermissionsMessage.RemovePlayer.class, PermissionsMessage.RemovePlayer::new);
        this.registerMessage(++idx, PermissionsMessage.ChangePlayerRank.class, PermissionsMessage.ChangePlayerRank::new);
        this.registerMessage(++idx, PermissionsMessage.AddPlayerOrFakePlayer.class, PermissionsMessage.AddPlayerOrFakePlayer::new);
        this.registerMessage(++idx, BuildRequestMessage.class, BuildRequestMessage::new);
        this.registerMessage(++idx, OpenInventoryMessage.class, OpenInventoryMessage::new);
        this.registerMessage(++idx, TownHallRenameMessage.class, TownHallRenameMessage::new);
        this.registerMessage(++idx, MinerSetLevelMessage.class, MinerSetLevelMessage::new);
        this.registerMessage(++idx, RecallCitizenMessage.class, RecallCitizenMessage::new);
        this.registerMessage(++idx, BuildToolPlaceMessage.class, BuildToolPlaceMessage::new);
        this.registerMessage(++idx, ToggleJobMessage.class, ToggleJobMessage::new);
        this.registerMessage(++idx, HireFireMessage.class, HireFireMessage::new);
        this.registerMessage(++idx, WorkOrderChangeMessage.class, WorkOrderChangeMessage::new);
        this.registerMessage(++idx, AssignFieldMessage.class, AssignFieldMessage::new);
        this.registerMessage(++idx, AssignmentModeMessage.class, AssignmentModeMessage::new);
        this.registerMessage(++idx, RequestFertilizerMessage.class, RequestFertilizerMessage::new);
        this.registerMessage(++idx, GuardTaskMessage.class, GuardTaskMessage::new);
        this.registerMessage(++idx, GuardRecalculateMessage.class, GuardRecalculateMessage::new);
        this.registerMessage(++idx, MobEntryChangeMessage.class, MobEntryChangeMessage::new);
        this.registerMessage(++idx, GuardScepterMessage.class, GuardScepterMessage::new);
        this.registerMessage(++idx, RecallCitizenHutMessage.class, RecallCitizenHutMessage::new);
        this.registerMessage(++idx, TransferItemsRequestMessage.class, TransferItemsRequestMessage::new);
        this.registerMessage(++idx, MarkBuildingDirtyMessage.class, MarkBuildingDirtyMessage::new);
        this.registerMessage(++idx, ChangeFreeToInteractBlockMessage.class, ChangeFreeToInteractBlockMessage::new);
        this.registerMessage(++idx, LumberjackReplantSaplingToggleMessage.class, LumberjackReplantSaplingToggleMessage::new);
        this.registerMessage(++idx, LumberjackRestrictionToggleMessage.class, LumberjackRestrictionToggleMessage::new);
        this.registerMessage(++idx, LumberjackScepterMessage.class, LumberjackScepterMessage::new);
        this.registerMessage(++idx, CreateColonyMessage.class, CreateColonyMessage::new);
        this.registerMessage(++idx, ColonyDeleteOwnMessage.class, ColonyDeleteOwnMessage::new);
        this.registerMessage(++idx, ColonyViewRemoveMessage.class, ColonyViewRemoveMessage::new);
        this.registerMessage(++idx, BeekeeperScepterMessage.class, BeekeeperScepterMessage::new);
        this.registerMessage(++idx, ToggleHousingMessage.class, ToggleHousingMessage::new);
        this.registerMessage(++idx, ToggleMoveInMessage.class, ToggleMoveInMessage::new);
        this.registerMessage(++idx, AssignUnassignMessage.class, AssignUnassignMessage::new);
        this.registerMessage(++idx, OpenCraftingGUIMessage.class, OpenCraftingGUIMessage::new);
        this.registerMessage(++idx, AddRemoveRecipeMessage.class, AddRemoveRecipeMessage::new);
        this.registerMessage(++idx, ChangeRecipePriorityMessage.class, ChangeRecipePriorityMessage::new);
        this.registerMessage(++idx, ChangeDeliveryPriorityMessage.class, ChangeDeliveryPriorityMessage::new);
        this.registerMessage(++idx, ForcePickupMessage.class, ForcePickupMessage::new);
        this.registerMessage(++idx, UpgradeWarehouseMessage.class, UpgradeWarehouseMessage::new);
        this.registerMessage(++idx, BuildToolPasteMessage.class, BuildToolPasteMessage::new);
        this.registerMessage(++idx, TransferItemsToCitizenRequestMessage.class, TransferItemsToCitizenRequestMessage::new);
        this.registerMessage(++idx, UpdateRequestStateMessage.class, UpdateRequestStateMessage::new);
        this.registerMessage(++idx, BuildingSetStyleMessage.class, BuildingSetStyleMessage::new);
        this.registerMessage(++idx, CowboySetMilkCowsMessage.class, CowboySetMilkCowsMessage::new);
        this.registerMessage(++idx, HerderSetBreedingMessage.class, HerderSetBreedingMessage::new);
        this.registerMessage(++idx, RecallSingleCitizenMessage.class, RecallSingleCitizenMessage::new);
        this.registerMessage(++idx, AssignFilterableItemMessage.class, AssignFilterableItemMessage::new);
        this.registerMessage(++idx, TeamColonyColorChangeMessage.class, TeamColonyColorChangeMessage::new);
        this.registerMessage(++idx, ColonyFlagChangeMessage.class, ColonyFlagChangeMessage::new);
        this.registerMessage(++idx, ToggleHelpMessage.class, ToggleHelpMessage::new);
        this.registerMessage(++idx, PauseCitizenMessage.class, PauseCitizenMessage::new);
        this.registerMessage(++idx, RestartCitizenMessage.class, RestartCitizenMessage::new);
        this.registerMessage(++idx, SortWarehouseMessage.class, SortWarehouseMessage::new);
        this.registerMessage(++idx, PostBoxRequestMessage.class, PostBoxRequestMessage::new);
        this.registerMessage(++idx, ComposterRetrievalMessage.class, ComposterRetrievalMessage::new);
        this.registerMessage(++idx, CrusherSetModeMessage.class, CrusherSetModeMessage::new);
        this.registerMessage(++idx, HireMercenaryMessage.class, HireMercenaryMessage::new);
        this.registerMessage(++idx, ShepherdSetDyeSheepsMessage.class, ShepherdSetDyeSheepsMessage::new);
        this.registerMessage(++idx, SifterSettingsMessage.class, SifterSettingsMessage::new);
        this.registerMessage(++idx, HutRenameMessage.class, HutRenameMessage::new);
        this.registerMessage(++idx, BuildingHiringModeMessage.class, BuildingHiringModeMessage::new);
        this.registerMessage(++idx, DecorationBuildRequestMessage.class, DecorationBuildRequestMessage::new);
        this.registerMessage(++idx, DecorationControllerUpdateMessage.class, DecorationControllerUpdateMessage::new);
        this.registerMessage(++idx, DirectPlaceMessage.class, DirectPlaceMessage::new);
        this.registerMessage(++idx, TeleportToColonyMessage.class, TeleportToColonyMessage::new);
        this.registerMessage(++idx, EnchanterWorkerSetMessage.class, EnchanterWorkerSetMessage::new);
        this.registerMessage(++idx, InteractionResponse.class, InteractionResponse::new);
        this.registerMessage(++idx, TryResearchMessage.class, TryResearchMessage::new);
        this.registerMessage(++idx, HireSpiesMessage.class, HireSpiesMessage::new);
        this.registerMessage(++idx, AddMinimumStockToBuildingMessage.class, AddMinimumStockToBuildingMessage::new);
        this.registerMessage(++idx, RemoveMinimumStockFromBuildingMessage.class, RemoveMinimumStockFromBuildingMessage::new);
        this.registerMessage(++idx, PlantationSetPhaseMessage.class, PlantationSetPhaseMessage::new);
        this.registerMessage(++idx, FieldPlotResizeMessage.class, FieldPlotResizeMessage::new);
        this.registerMessage(++idx, AdjustSkillCitizenMessage.class, AdjustSkillCitizenMessage::new);
        this.registerMessage(++idx, BlockParticleEffectMessage.class, BlockParticleEffectMessage::new);
        this.registerMessage(++idx, CompostParticleMessage.class, CompostParticleMessage::new);
        this.registerMessage(++idx, ItemParticleEffectMessage.class, ItemParticleEffectMessage::new);
        this.registerMessage(++idx, LocalizedParticleEffectMessage.class, LocalizedParticleEffectMessage::new);
        this.registerMessage(++idx, UpdateChunkRangeCapabilityMessage.class, UpdateChunkRangeCapabilityMessage::new);
        this.registerMessage(++idx, OpenSuggestionWindowMessage.class, OpenSuggestionWindowMessage::new);
        this.registerMessage(++idx, UpdateClientWithRecipesMessage.class, UpdateClientWithRecipesMessage::new);
        this.registerMessage(++idx, CircleParticleEffectMessage.class, CircleParticleEffectMessage::new);
        this.registerMessage(++idx, StreamParticleEffectMessage.class, StreamParticleEffectMessage::new);
        this.registerMessage(++idx, SleepingParticleMessage.class, SleepingParticleMessage::new);
        this.registerMessage(++idx, VanillaParticleMessage.class, VanillaParticleMessage::new);
        this.registerMessage(++idx, StopMusicMessage.class, StopMusicMessage::new);
        this.registerMessage(++idx, PlayMusicMessage.class, PlayMusicMessage::new);
        this.registerMessage(++idx, PlayMusicAtPosMessage.class, PlayMusicAtPosMessage::new);
        this.registerMessage(++idx, ColonyVisitorViewDataMessage.class, ColonyVisitorViewDataMessage::new);
        this.registerMessage(++idx, TransferRecipeCrafingTeachingMessage.class, TransferRecipeCrafingTeachingMessage::new);
        this.registerMessage(++idx, OpenGuiWindowTriggerMessage.class, OpenGuiWindowTriggerMessage::new);
        this.registerMessage(++idx, ClickGuiButtonTriggerMessage.class, ClickGuiButtonTriggerMessage::new);
        this.registerMessage(++idx, RemoveFromRallyingListMessage.class, RemoveFromRallyingListMessage::new);
        this.registerMessage(++idx, ToggleBannerRallyGuardsMessage.class, ToggleBannerRallyGuardsMessage::new);
    }

    private void setupInternalMessages() {
        this.rawChannel.registerMessage(0, SplitPacketMessage.class, IMessage::toBytes, buf -> {
            SplitPacketMessage msg = new SplitPacketMessage();
            msg.fromBytes((PacketBuffer)buf);
            return msg;
        }, (msg, ctxIn) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)ctxIn.get();
            LogicalSide packetOrigin = ctx.getDirection().getOriginationSide();
            ctx.setPacketHandled(true);
            msg.onExecute(ctx, packetOrigin.equals((Object)LogicalSide.CLIENT));
        });
    }

    private <MSG extends IMessage> void registerMessage(int id, Class<MSG> msgClazz, Supplier<MSG> msgCreator) {
        this.messagesTypes.put(id, new NetworkingMessageEntry(msgCreator));
        this.messageTypeToIdMap.put(msgClazz, id);
    }

    public void sendToServer(IMessage msg) {
        this.handleSplitting(msg, arg_0 -> ((SimpleChannel)this.rawChannel).sendToServer(arg_0));
    }

    public void sendToPlayer(IMessage msg, ServerPlayerEntity player) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.PLAYER.with(() -> player), s));
    }

    public void sendToOrigin(IMessage msg, NetworkEvent.Context ctx) {
        ServerPlayerEntity player = ctx.getSender();
        if (player != null) {
            this.sendToPlayer(msg, player);
        } else {
            this.sendToServer(msg);
        }
    }

    public void sendToDimension(IMessage msg, DimensionType dim) {
        this.rawChannel.send(PacketDistributor.DIMENSION.with(() -> dim), (Object)msg);
    }

    public void sendToPosition(IMessage msg, PacketDistributor.TargetPoint pos) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.NEAR.with(() -> pos), s));
    }

    public void sendToEveryone(IMessage msg) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.ALL.noArg(), s));
    }

    public void sendToTrackingEntity(IMessage msg, Entity entity) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), s));
    }

    public void sendToTrackingEntityAndSelf(IMessage msg, Entity entity) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), s));
    }

    public void sendToTrackingChunk(IMessage msg, Chunk chunk) {
        this.handleSplitting(msg, s -> this.rawChannel.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), s));
    }

    private void handleSplitting(IMessage msg, Consumer<IMessage> splitMessageConsumer) {
        int extra;
        int messageId = this.messageTypeToIdMap.getOrDefault(msg.getClass(), -1);
        if (messageId == -1) {
            throw new IllegalArgumentException("The message is unknown to this channel!");
        }
        ByteBuf buffer = Unpooled.buffer();
        PacketBuffer innerPacketBuffer = new PacketBuffer(buffer);
        msg.toBytes(innerPacketBuffer);
        byte[] data = buffer.array();
        buffer.release();
        int max_packet_size = 943718;
        int packetIndex = 0;
        int comId = this.messageCounter.getAndIncrement();
        for (int currentIndex = 0; currentIndex < data.length; currentIndex += extra) {
            this.getMessagesTypes().get(messageId).onSplitting(packetIndex);
            extra = Math.min(943718, data.length - currentIndex);
            byte[] subPacketData = Arrays.copyOfRange(data, currentIndex, currentIndex + extra);
            SplitPacketMessage splitPacketMessage = new SplitPacketMessage(comId, packetIndex++, currentIndex + extra >= data.length, messageId, subPacketData);
            splitMessageConsumer.accept(splitPacketMessage);
        }
    }

    public Cache<Integer, Map<Integer, byte[]>> getMessageCache() {
        return this.messageCache;
    }

    public Map<Integer, NetworkingMessageEntry<?>> getMessagesTypes() {
        return this.messagesTypes;
    }

    public final class NetworkingMessageEntry<MSG extends IMessage> {
        private final AtomicBoolean hasWarned = new AtomicBoolean(true);
        private final Supplier<MSG> creator;

        private NetworkingMessageEntry(Supplier<MSG> creator) {
            this.creator = creator;
        }

        public Supplier<MSG> getCreator() {
            return this.creator;
        }

        public void onSplitting(int packetIndex) {
            if (packetIndex != 1) {
                return;
            }
            if (this.hasWarned.getAndSet(false)) {
                Log.getLogger().warn("Splitting message: " + ((IMessage)this.creator.get()).getClass() + " it is too big to send normally. This message is only printed once");
            }
        }
    }
}

