/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.network.PacketUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.permissions.Permissions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionsMessage {
    private static final String COLONY_DOES_NOT_EXIST = "Colony #%d does not exist.";

    public static class RemovePlayer
    implements IMessage {
        private int colonyID;
        private UUID playerID;
        private int dimension;

        public RemovePlayer() {
        }

        public RemovePlayer(@NotNull IColonyView colony, UUID player) {
            this.colonyID = colony.getID();
            this.playerID = player;
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            PacketUtils.writeUUID(buf, this.playerID);
            buf.writeInt(this.dimension);
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.playerID = PacketUtils.readUUID(buf);
            this.dimension = buf.readInt();
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
                return;
            }
            ServerPlayerEntity player = ctxIn.getSender();
            Player permissionsPlayer = colony.getPermissions().getPlayers().get(this.playerID);
            if (permissionsPlayer.getRank() == Rank.HOSTILE && colony.getPermissions().hasPermission((PlayerEntity)player, Action.EDIT_PERMISSIONS) || permissionsPlayer.getRank() != Rank.HOSTILE && colony.getPermissions().hasPermission((PlayerEntity)player, Action.EDIT_PERMISSIONS) && colony.getPermissions().getRank((PlayerEntity)player).ordinal() < colony.getPermissions().getRank(this.playerID).ordinal() || player.func_110124_au().equals(this.playerID)) {
                colony.getPermissions().removePlayer(this.playerID);
            }
        }
    }

    public static class ChangePlayerRank
    implements IMessage {
        private int colonyID;
        private UUID playerID;
        private Type type;
        private int dimension;

        public ChangePlayerRank() {
        }

        public ChangePlayerRank(@NotNull IColonyView colony, UUID player, Type type) {
            this.colonyID = colony.getID();
            this.playerID = player;
            this.type = type;
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            PacketUtils.writeUUID(buf, this.playerID);
            buf.func_180714_a(this.type.name());
            buf.writeInt(this.dimension);
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.playerID = PacketUtils.readUUID(buf);
            this.type = Type.valueOf(buf.func_150789_c(Short.MAX_VALUE));
            this.dimension = buf.readInt();
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony == null || colony.getWorld() == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
                return;
            }
            ServerPlayerEntity player = ctxIn.getSender();
            if (colony.getPermissions().hasPermission((PlayerEntity)player, Action.EDIT_PERMISSIONS)) {
                if (this.type == Type.PROMOTE && colony.getPermissions().getRank((PlayerEntity)player).ordinal() < colony.getPermissions().getRank(this.playerID).ordinal()) {
                    colony.getPermissions().setPlayerRank(this.playerID, Permissions.getPromotionRank(colony.getPermissions().getRank(this.playerID)), colony.getWorld());
                } else if (this.type == Type.DEMOTE && (colony.getPermissions().getRank((PlayerEntity)player).ordinal() < colony.getPermissions().getRank(this.playerID).ordinal() || player.func_110124_au().equals(this.playerID))) {
                    colony.getPermissions().setPlayerRank(this.playerID, Permissions.getDemotionRank(colony.getPermissions().getRank(this.playerID)), colony.getWorld());
                }
            }
        }

        public static enum Type {
            PROMOTE,
            DEMOTE;

        }
    }

    public static class AddPlayerOrFakePlayer
    implements IMessage {
        private int colonyID;
        private String playerName;
        private UUID id;
        private int dimension;

        public AddPlayerOrFakePlayer() {
        }

        public AddPlayerOrFakePlayer(@NotNull IColonyView colony, String playerName, UUID id) {
            this.colonyID = colony.getID();
            this.playerName = playerName;
            this.id = id;
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.func_180714_a(this.playerName);
            PacketUtils.writeUUID(buf, this.id);
            buf.writeInt(this.dimension);
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.playerName = buf.func_150789_c(Short.MAX_VALUE);
            this.id = PacketUtils.readUUID(buf);
            this.dimension = buf.readInt();
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony != null && colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.CAN_PROMOTE) && colony.getWorld() != null) {
                colony.getPermissions().addPlayer(this.id, this.playerName, Rank.NEUTRAL);
            } else {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
            }
        }
    }

    public static class AddPlayer
    implements IMessage {
        private int colonyID;
        private String playerName;
        private int dimension;

        public AddPlayer() {
        }

        public AddPlayer(@NotNull IColonyView colony, String player) {
            this.colonyID = colony.getID();
            this.playerName = player;
            this.dimension = colony.getDimension();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.func_180714_a(this.playerName);
            buf.writeInt(this.dimension);
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.playerName = buf.func_150789_c(Short.MAX_VALUE);
            this.dimension = buf.readInt();
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony != null && colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.CAN_PROMOTE) && colony.getWorld() != null) {
                colony.getPermissions().addPlayer(this.playerName, Rank.NEUTRAL, colony.getWorld());
            } else {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
            }
        }
    }

    public static class Permission
    implements IMessage {
        private int colonyID;
        private MessageType type;
        private Rank rank;
        private Action action;
        private int dimension;

        public Permission() {
        }

        public Permission(@NotNull IColonyView colony, MessageType type, Rank rank, Action action) {
            this.colonyID = colony.getID();
            this.type = type;
            this.rank = rank;
            this.action = action;
            this.dimension = colony.getDimension();
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.SERVER;
        }

        @Override
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColony colony = IColonyManager.getInstance().getColonyByDimension(this.colonyID, this.dimension);
            if (colony == null) {
                Log.getLogger().error(String.format(PermissionsMessage.COLONY_DOES_NOT_EXIST, this.colonyID), (Throwable)new Exception());
                return;
            }
            if (!colony.getPermissions().hasPermission((PlayerEntity)ctxIn.getSender(), Action.EDIT_PERMISSIONS)) {
                return;
            }
            switch (this.type) {
                case SET_PERMISSION: {
                    colony.getPermissions().setPermission(this.rank, this.action);
                    break;
                }
                case REMOVE_PERMISSION: {
                    colony.getPermissions().removePermission(this.rank, this.action);
                    break;
                }
                case TOGGLE_PERMISSION: {
                    colony.getPermissions().togglePermission(this.rank, this.action);
                    break;
                }
                default: {
                    Log.getLogger().error(String.format("Invalid MessageType %s", this.type.toString()), (Throwable)new Exception());
                }
            }
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.func_180714_a(this.type.name());
            buf.func_180714_a(this.rank.name());
            buf.func_180714_a(this.action.name());
            buf.writeInt(this.dimension);
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            this.colonyID = buf.readInt();
            this.type = MessageType.valueOf(buf.func_150789_c(Short.MAX_VALUE));
            this.rank = Rank.valueOf(buf.func_150789_c(Short.MAX_VALUE));
            this.action = Action.valueOf(buf.func_150789_c(Short.MAX_VALUE));
            this.dimension = buf.readInt();
        }
    }

    public static class View
    implements IMessage {
        private int colonyID;
        private PacketBuffer data;
        private int dimension;

        public View() {
        }

        public View(@NotNull Colony colony, @NotNull Rank viewerRank) {
            this.colonyID = colony.getID();
            this.data = new PacketBuffer(Unpooled.buffer());
            colony.getPermissions().serializeViewNetworkData(this.data, viewerRank);
            this.dimension = colony.getDimension();
        }

        @Override
        public void fromBytes(@NotNull PacketBuffer buf) {
            PacketBuffer newBuf = new PacketBuffer(buf.retain());
            this.colonyID = newBuf.readInt();
            this.dimension = newBuf.readInt();
            this.data = newBuf;
        }

        @Override
        @Nullable
        public LogicalSide getExecutionSide() {
            return LogicalSide.CLIENT;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
            IColonyManager.getInstance().handlePermissionsViewMessage(this.colonyID, this.data, this.dimension);
            this.data.release();
        }

        @Override
        public void toBytes(@NotNull PacketBuffer buf) {
            buf.writeInt(this.colonyID);
            buf.writeInt(this.dimension);
            buf.writeBytes((ByteBuf)this.data);
        }
    }

    public static enum MessageType {
        SET_PERMISSION,
        REMOVE_PERMISSION,
        TOGGLE_PERMISSION;

    }
}

