/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewWorkOrderMessage
implements IMessage {
    private int colonyId;
    private int dimension;
    private PacketBuffer workOrderBuffer;

    public ColonyViewWorkOrderMessage() {
    }

    public ColonyViewWorkOrderMessage(@NotNull Colony colony, @NotNull List<IWorkOrder> workOrderList) {
        this.colonyId = colony.getID();
        this.workOrderBuffer = new PacketBuffer(Unpooled.buffer());
        this.workOrderBuffer.writeInt(workOrderList.size());
        for (IWorkOrder workOrder : workOrderList) {
            workOrder.serializeViewNetworkData(this.workOrderBuffer);
        }
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        PacketBuffer newbuf = new PacketBuffer(buf.retain());
        this.colonyId = newbuf.readInt();
        this.dimension = newbuf.readInt();
        this.workOrderBuffer = newbuf;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.dimension);
        buf.writeBytes((ByteBuf)this.workOrderBuffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyManager.getInstance().handleColonyViewWorkOrderMessage(this.colonyId, this.workOrderBuffer, this.dimension);
        this.workOrderBuffer.release();
    }
}

