/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony.building.guard;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class GuardMobAttackListMessage
implements IMessage {
    private BlockPos buildingId;
    private int colonyId;
    private List<MobEntryView> mobsToAttack = new ArrayList<MobEntryView>();

    public GuardMobAttackListMessage() {
    }

    public GuardMobAttackListMessage(int colonyId, BlockPos buildingId, List<MobEntryView> mobsToAttack) {
        this.colonyId = colonyId;
        this.buildingId = buildingId;
        this.mobsToAttack = new ArrayList<MobEntryView>(mobsToAttack);
    }

    @Override
    public void fromBytes(PacketBuffer byteBuf) {
        this.colonyId = byteBuf.readInt();
        this.buildingId = byteBuf.func_179259_c();
        int mobSize = byteBuf.readInt();
        for (int i = 0; i < mobSize; ++i) {
            MobEntryView mobEntry = MobEntryView.readFromByteBuf(byteBuf);
            this.mobsToAttack.add(mobEntry);
        }
    }

    @Override
    public void toBytes(PacketBuffer byteBuf) {
        byteBuf.writeInt(this.colonyId);
        byteBuf.func_179255_a(this.buildingId);
        byteBuf.writeInt(this.mobsToAttack.size());
        for (MobEntryView entry : this.mobsToAttack) {
            MobEntryView.writeToByteBuf(byteBuf, entry);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        AbstractBuildingGuards.View buildingView;
        IColonyView IColonyView2 = IColonyManager.getInstance().getColonyView(this.colonyId, Minecraft.func_71410_x().field_71441_e.func_201675_m().func_186058_p().func_186068_a());
        if (IColonyView2 != null && (buildingView = (AbstractBuildingGuards.View)IColonyView2.getBuilding(this.buildingId)) != null) {
            buildingView.setMobsToAttack(this.mobsToAttack);
        }
    }
}

