/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class GuardScepterMessage
extends AbstractColonyServerMessage {
    private int taskId;
    private BlockPos buildingId;

    public GuardScepterMessage() {
    }

    public GuardScepterMessage(IBuildingView building, int taskId) {
        super(building.getColony());
        this.taskId = taskId;
        this.buildingId = building.getPosition();
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.taskId = buf.readInt();
        this.buildingId = buf.func_179259_c();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.taskId);
        buf.func_179255_a(this.buildingId);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        CompoundNBT compound;
        ItemStack scepter;
        boolean giveToPlayer = true;
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        if (player.func_184614_ca().func_77973_b() == ModItems.scepterGuard) {
            scepter = player.func_184614_ca();
            giveToPlayer = false;
        } else {
            scepter = new ItemStack((IItemProvider)ModItems.scepterGuard);
        }
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new CompoundNBT());
        }
        if ((compound = scepter.func_77978_p()) == null) {
            return;
        }
        compound.func_74768_a("task", this.taskId);
        int emptySlot = player.field_71071_by.func_70447_i();
        BlockPosUtil.write(compound, "pos", this.buildingId);
        compound.func_74768_a("id", colony.getID());
        if (giveToPlayer) {
            ItemStack item = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
            player.field_71071_by.func_70299_a(emptySlot, item);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, scepter);
        }
        player.field_71071_by.func_70296_d();
    }
}

