/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignFilterableItemMessage
extends AbstractBuildingServerMessage<AbstractFilterableListBuilding> {
    private boolean assign;
    private ItemStorage item;
    private String id;

    public AssignFilterableItemMessage() {
    }

    public AssignFilterableItemMessage(IBuildingView building, String id, ItemStorage item, boolean assign) {
        super(building);
        this.assign = assign;
        this.item = item;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.assign = buf.readBoolean();
        this.item = new ItemStorage(buf.func_150791_c());
        this.id = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.assign);
        buf.func_150788_a(this.item.getItemStack());
        buf.func_180714_a(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractFilterableListBuilding building) {
        if (this.assign) {
            building.addItem(this.id, this.item);
        } else {
            building.removeItem(this.id, this.item);
        }
    }
}

