/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.sifter;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class SifterSettingsMessage
extends AbstractBuildingServerMessage<BuildingSifter> {
    private int quantity;
    private ItemStack block;
    private ItemStack mesh;
    private boolean buy;

    public SifterSettingsMessage() {
    }

    public SifterSettingsMessage(@NotNull BuildingSifter.View building, ItemStorage block, ItemStorage mesh, int dailyQuantity, boolean buy) {
        super(building);
        this.quantity = dailyQuantity;
        this.block = block.getItemStack();
        this.mesh = mesh.getItemStack();
        this.buy = buy;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.quantity = buf.readInt();
        this.block = buf.func_150791_c();
        this.mesh = buf.func_150791_c();
        this.buy = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.quantity);
        buf.func_150788_a(this.block);
        buf.func_150788_a(this.mesh);
        buf.writeBoolean(this.buy);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, BuildingSifter building) {
        ServerPlayerEntity player;
        int qty = this.quantity;
        if (qty > building.getMaxDailyQuantity()) {
            qty = building.getMaxDailyQuantity();
            player = ctxIn.getSender();
            if (player == null) {
                return;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.sifter.toomuch", new Object[]{qty}));
        }
        if (this.buy) {
            player = ctxIn.getSender();
            if (player == null) {
                return;
            }
            if (!player.func_184812_l_()) {
                int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), itemStack -> itemStack.func_77969_a(this.mesh));
                if (slot < 0) {
                    return;
                }
                player.field_71071_by.func_70298_a(slot, 1);
            }
        }
        building.setup(new ItemStorage(this.block), new ItemStorage(this.mesh), qty);
    }
}

