/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.citizen;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class TransferItemsToCitizenRequestMessage
extends AbstractColonyServerMessage {
    private int citizenId;
    private ItemStack itemStack;
    private int quantity;

    public TransferItemsToCitizenRequestMessage() {
    }

    public TransferItemsToCitizenRequestMessage(IColony colony, @NotNull ICitizenDataView citizenDataView, ItemStack itemStack, int quantity) {
        super(colony);
        this.citizenId = citizenDataView.getId();
        this.itemStack = itemStack;
        this.quantity = quantity;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.citizenId = buf.readInt();
        this.itemStack = buf.func_150791_c();
        this.quantity = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.citizenId);
        buf.func_150788_a(this.itemStack);
        buf.writeInt(this.quantity);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        int tempAmount;
        int count;
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        if (citizenData == null) {
            Log.getLogger().warn("TransferItemsRequestMessage citizenData is null");
            return;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            Log.getLogger().warn("TransferItemsRequestMessage entity citizen is null");
            return;
        }
        ServerPlayerEntity player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        boolean isCreative = player.func_184812_l_();
        if (this.quantity <= 0 && !isCreative) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        Map<ItemStorage, ItemStorage> previousContent = null;
        int amountToTake = isCreative ? this.quantity : Math.min(this.quantity, InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack)));
        ArrayList<Object> itemsToPut = new ArrayList<Object>();
        for (tempAmount = amountToTake; tempAmount > 0; tempAmount -= count) {
            count = Math.min(this.itemStack.func_77976_d(), tempAmount);
            ItemStack stack2 = this.itemStack.func_77946_l();
            stack2.func_190920_e(count);
            itemsToPut.add(stack2);
        }
        AbstractEntityCitizen citizen = optionalEntityCitizen.get();
        if (!isCreative && ((Boolean)MineColonies.getConfig().getCommon().debugInventories.get()).booleanValue()) {
            previousContent = InventoryUtils.getAllItemsForProviders(new IItemHandler[]{citizen.getInventoryCitizen(), new InvWrapper((IInventory)player.field_71071_by)});
        }
        tempAmount = 0;
        for (ItemStack itemStack : itemsToPut) {
            ItemStack remainingItemStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)citizen.getInventoryCitizen(), itemStack);
            if (!ItemStackUtils.isEmpty(remainingItemStack).booleanValue()) {
                tempAmount += itemStack.func_190916_E() - remainingItemStack.func_190916_E();
                break;
            }
            tempAmount += itemStack.func_190916_E();
        }
        if (!isCreative) {
            ItemStack itemsTaken;
            for (int amountToRemoveFromPlayer = tempAmount; amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= ItemStackUtils.getSize(itemsTaken)) {
                int n = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack));
                itemsTaken = player.field_71071_by.func_70298_a(n, amountToRemoveFromPlayer);
            }
        }
        if (!isCreative && previousContent != null && ((Boolean)MineColonies.getConfig().getCommon().debugInventories.get()).booleanValue()) {
            InventoryUtils.doStorageSetsMatch(previousContent, InventoryUtils.getAllItemsForProviders(new IItemHandler[]{citizen.getInventoryCitizen(), new InvWrapper((IInventory)player.field_71071_by)}), true);
        }
    }
}

