/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.placementhandlers;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.func_177230_c() instanceof AbstractChestBlock;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        TileEntity entity = world.func_175625_s(pos);
        IColony colony = IColonyManager.getInstance().getClosestColony(world, pos);
        if (colony != null && entity instanceof ChestTileEntity) {
            BuildingWareHouse.handleBuildingOverChest(pos, (ChestTileEntity)entity, world, tileEntityData);
        } else {
            if (!world.func_180501_a(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement((CompoundNBT)tileEntityData, (World)world, (BlockPos)pos, (PlacementSettings)settings);
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundNBT tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        itemList.addAll(PlacementHandlers.getItemsFromTileEntity((CompoundNBT)tileEntityData, (World)world));
        itemList.removeIf(ItemStackUtils::isEmpty);
        return itemList;
    }
}

