/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.research.IResearchRequirement;
import net.minecraft.util.text.TranslationTextComponent;

public class BuildingResearchRequirement
implements IResearchRequirement {
    private final int buildingLevel;
    private final String building;

    public BuildingResearchRequirement(int buildingLevel, String building) {
        this.buildingLevel = buildingLevel;
        this.building = building;
    }

    public String getBuilding() {
        return this.building;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        int sum = 0;
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            if (!building.getSchematicName().equalsIgnoreCase(this.building) || (sum += building.getBuildingLevel()) < this.buildingLevel) continue;
            return true;
        }
        return false;
    }

    @Override
    public TranslationTextComponent getDesc() {
        return new TranslationTextComponent("com.minecolonies.coremod.research.requirement.building.level", new Object[]{this.building, this.buildingLevel});
    }
}

