/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class GlobalResearchTree
implements IGlobalResearchTree {
    private final Map<String, Map<String, IGlobalResearch>> researchTree = new HashMap<String, Map<String, IGlobalResearch>>();

    @Override
    public IGlobalResearch getResearch(String branch, String id) {
        return this.researchTree.get(branch).get(id);
    }

    @Override
    public void addResearch(String branch, IGlobalResearch research) {
        Map<Object, Object> branchMap = this.researchTree.containsKey(branch) ? this.researchTree.get(branch) : new HashMap();
        if (branchMap.containsKey(research.getId())) {
            Log.getLogger().error("Duplicate research key:" + research.getId());
        }
        branchMap.put(research.getId(), research);
        this.researchTree.put(branch, branchMap);
    }

    @Override
    public List<String> getBranches() {
        return new ArrayList<String>(this.researchTree.keySet());
    }

    @Override
    public List<String> getPrimaryResearch(String branch) {
        if (!this.researchTree.containsKey(branch)) {
            return Collections.emptyList();
        }
        return this.researchTree.get(branch).values().stream().filter(research -> research.getParent().isEmpty()).map(IGlobalResearch::getId).collect(Collectors.toList());
    }

    @Override
    public void writeToNBT(CompoundNBT compound) {
        ListNBT citizenTagList = this.researchTree.values().stream().flatMap(map -> map.values().stream()).map(research -> StandardFactoryController.getInstance().serialize(research)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("researchTree", (INBT)citizenTagList);
    }

    @Override
    public void readFromNBT(CompoundNBT compound) {
        this.researchTree.clear();
        NBTUtils.streamCompound(compound.func_150295_c("researchTree", 10)).map(researchCompound -> (IGlobalResearch)StandardFactoryController.getInstance().deserialize((CompoundNBT)researchCompound)).forEach(research -> this.addResearch(research.getBranch(), (IGlobalResearch)research));
    }

    @Override
    public void loadCost() {
        this.researchTree.values().forEach(b -> b.values().forEach(IGlobalResearch::loadCostFromConfig));
    }

    @Override
    public String getEffectIdForResearch(String id) {
        for (String branch : this.getBranches()) {
            IGlobalResearch r = this.getResearch(branch, id);
            if (r == null) continue;
            return r.getEffect().getId();
        }
        return null;
    }
}

