/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.factories.ILocalResearchFactory;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.research.LocalResearch;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class LocalResearchFactory
implements ILocalResearchFactory {
    @Override
    @NotNull
    public TypeToken<LocalResearch> getFactoryOutputType() {
        return TypeToken.of(LocalResearch.class);
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public ILocalResearch getNewInstance(String id, String branch, int depth) {
        return new LocalResearch(id, branch, depth);
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull ILocalResearch research) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("state", research.getState().ordinal());
        compound.func_74778_a("id", research.getId());
        compound.func_74778_a("branch", research.getBranch());
        compound.func_74768_a("progress", research.getProgress());
        compound.func_74768_a("depth", research.getDepth());
        return compound;
    }

    @Override
    @NotNull
    public ILocalResearch deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        int state = nbt.func_74762_e("state");
        String id = nbt.func_74779_i("id");
        String branch = nbt.func_74779_i("branch");
        int depth = nbt.func_74762_e("depth");
        int progress = nbt.func_74762_e("progress");
        ILocalResearch research = this.getNewInstance(id, branch, depth);
        research.setState(ResearchState.values()[state]);
        research.setProgress(progress);
        return research;
    }

    @Override
    public void serialize(IFactoryController controller, ILocalResearch input, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(input.getState().ordinal());
        packetBuffer.func_180714_a(input.getId());
        packetBuffer.func_180714_a(input.getBranch());
        packetBuffer.writeInt(input.getProgress());
        packetBuffer.writeInt(input.getDepth());
    }

    @Override
    public ILocalResearch deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
        int state = buffer.readInt();
        String id = buffer.func_218666_n();
        String branch = buffer.func_218666_n();
        int progress = buffer.readInt();
        int depth = buffer.readInt();
        ILocalResearch research = this.getNewInstance(id, branch, depth);
        research.setState(ResearchState.values()[state]);
        research.setProgress(progress);
        return research;
    }

    @Override
    public short getSerializationId() {
        return 29;
    }
}

