/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.AbstractTileEntityWareHouse;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWareHouse
extends AbstractTileEntityWareHouse {
    public TileEntityWareHouse() {
        super(MinecoloniesTileEntities.WAREHOUSE);
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate, int count) {
        List<Tuple<ItemStack, BlockPos>> targetStacks = this.getMatchingItemStacksInWarehouse(itemStackSelectionPredicate);
        return targetStacks.stream().mapToInt(tuple -> ItemStackUtils.getSize((ItemStack)tuple.getA())).sum() >= count;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count) {
        int totalCountFound = 0;
        for (BlockPos pos : this.getBuilding().getContainers()) {
            if (!WorldUtil.isBlockLoaded((IWorld)this.field_145850_b, pos)) continue;
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (entity instanceof TileEntityRack && !((AbstractTileEntityRack)entity).isEmpty() && (totalCountFound += ((AbstractTileEntityRack)entity).getCount(itemStack, true)) >= count) {
                return true;
            }
            if (!(entity instanceof ChestTileEntity) || (totalCountFound += InventoryUtils.getItemCountInItemHandler((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), item -> item.func_185136_b(itemStack) && item.func_190916_E() >= itemStack.func_190916_E())) < count) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<Tuple<ItemStack, BlockPos>> getMatchingItemStacksInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        ArrayList<Tuple<ItemStack, BlockPos>> found = new ArrayList<Tuple<ItemStack, BlockPos>>();
        if (this.getBuilding() != null) {
            for (BlockPos pos : this.getBuilding().getContainers()) {
                TileEntity entity = this.func_145831_w().func_175625_s(pos);
                if (entity instanceof TileEntityRack && !((AbstractTileEntityRack)entity).isEmpty() && ((AbstractTileEntityRack)entity).getItemCount(itemStackSelectionPredicate) > 0) {
                    TileEntityRack rack = (TileEntityRack)entity;
                    for (ItemStack stack : InventoryUtils.filterItemHandler((IItemHandler)rack.getInventory(), itemStackSelectionPredicate)) {
                        found.add(new Tuple<ItemStack, BlockPos>(stack, pos));
                    }
                }
                if (!(entity instanceof ChestTileEntity) || !InventoryUtils.hasItemInItemHandler((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), itemStackSelectionPredicate)) continue;
                for (ItemStack stack : InventoryUtils.filterItemHandler((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), itemStackSelectionPredicate)) {
                    found.add(new Tuple<ItemStack, BlockPos>(stack, pos));
                }
            }
        }
        return found;
    }

    @Override
    public void dumpInventoryIntoWareHouse(@NotNull InventoryCitizen inventoryCitizen) {
        for (int i = 0; i < inventoryCitizen.getSlots(); ++i) {
            ItemStack stack = inventoryCitizen.getStackInSlot(i);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            TileEntity chest = this.searchRightChestForStack(stack);
            if (chest == null) {
                LanguageHandler.sendPlayersMessage(this.getColony().getMessagePlayerEntities(), (String)"com.minecolonies.coremod.warehouse.full", (Object[])new Object[0]);
                return;
            }
            int index = i;
            chest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handler -> InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((IItemHandler)inventoryCitizen, index, handler));
        }
    }

    @Nullable
    private TileEntity searchRightChestForStack(@NotNull ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getContainers()) {
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (!TileEntityWareHouse.isInRack(stack, entity, false) && !TileEntityWareHouse.isInChest(stack, entity, false)) continue;
            return entity;
        }
        TileEntity chest = this.searchChestWithSimilarItem(stack);
        return chest == null ? this.searchMostEmptySlot() : chest;
    }

    private static boolean isInRack(ItemStack stack, TileEntity entity, boolean includeSimilarMatches) {
        return entity instanceof TileEntityRack && !((AbstractTileEntityRack)entity).isEmpty() && (includeSimilarMatches ? ((TileEntityRack)entity).hasSimilarStack(stack) : ((AbstractTileEntityRack)entity).hasItemStack(stack, 1, false)) && ((TileEntityRack)entity).getFreeSlots() > 0;
    }

    private static boolean isInChest(ItemStack stack, TileEntity entity, boolean ignoreDamageValue) {
        return entity instanceof ChestTileEntity && InventoryUtils.findSlotInItemHandlerNotFullWithItem((IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), stack);
    }

    @Nullable
    private TileEntity searchChestWithSimilarItem(ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getContainers()) {
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (!TileEntityWareHouse.isInRack(stack, entity, true) && !TileEntityWareHouse.isInChest(stack, entity, true)) continue;
            return entity;
        }
        return null;
    }

    @Nullable
    private TileEntity searchMostEmptySlot() {
        int freeSlots = 0;
        TileEntity emptiestChest = null;
        for (BlockPos pos : this.getBuilding().getContainers()) {
            int tempFreeSlots;
            TileEntity entity = this.func_145831_w().func_175625_s(pos);
            if (entity == null) {
                this.getBuilding().removeContainerPosition(pos);
                continue;
            }
            if (entity instanceof TileEntityRack) {
                if (((AbstractTileEntityRack)entity).isEmpty()) {
                    return entity;
                }
                tempFreeSlots = ((AbstractTileEntityRack)entity).getFreeSlots();
                if (freeSlots >= tempFreeSlots) continue;
                freeSlots = tempFreeSlots;
                emptiestChest = entity;
                continue;
            }
            if (!(entity instanceof ChestTileEntity) || InventoryUtils.getFirstOpenSlotFromProvider((ICapabilityProvider)entity) == -1 || freeSlots >= (tempFreeSlots = ((ChestTileEntity)entity).func_70302_i_() - InventoryUtils.getAmountOfStacksInProvider((ICapabilityProvider)entity))) continue;
            freeSlots = tempFreeSlots;
            emptiestChest = entity;
        }
        return emptiestChest;
    }
}

