/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.minecolonies.api.colony.permissions.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerUtils {
    private ServerUtils() {
    }

    @Nullable
    public static PlayerEntity getPlayerFromUUID(@NotNull World world, @NotNull UUID id) {
        for (int i = 0; i < world.func_217369_A().size(); ++i) {
            if (!id.equals(((PlayerEntity)world.func_217369_A().get(i)).func_146103_bH().getId())) continue;
            return (PlayerEntity)world.func_217369_A().get(i);
        }
        return null;
    }

    @NotNull
    public static List<PlayerEntity> getPlayersFromUUID(@Nullable World world, @NotNull Collection<UUID> ids) {
        if (world == null) {
            return Collections.emptyList();
        }
        ArrayList<PlayerEntity> players = new ArrayList<PlayerEntity>();
        for (Object o : world.func_217369_A()) {
            PlayerEntity player;
            if (!(o instanceof PlayerEntity) || !ids.contains((player = (PlayerEntity)o).func_146103_bH().getId())) continue;
            players.add(player);
            if (players.size() != ids.size()) continue;
            return players;
        }
        return players;
    }

    @NotNull
    public static List<PlayerEntity> getPlayersFromPermPlayer(@NotNull List<Player> players, @NotNull World world) {
        ArrayList<PlayerEntity> playerList = new ArrayList<PlayerEntity>();
        for (Player player : players) {
            playerList.add(ServerUtils.getPlayerFromPermPlayer(player, world));
        }
        return playerList;
    }

    @Nullable
    public static PlayerEntity getPlayerFromPermPlayer(@NotNull Player player, @NotNull World world) {
        return ServerUtils.getPlayerFromUUID(player.getID(), world);
    }

    @Nullable
    public static PlayerEntity getPlayerFromUUID(@Nullable UUID uuid, @NotNull World world) {
        if (uuid == null) {
            return null;
        }
        List allPlayers = world.func_73046_m().func_184103_al().func_181057_v();
        for (ServerPlayerEntity player : allPlayers) {
            if (!player.func_110124_au().equals(uuid)) continue;
            return player;
        }
        return null;
    }
}

