/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.util;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.jetbrains.annotations.NotNull;

public final class TeleportHelper {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;

    private TeleportHelper() {
    }

    public static boolean teleportCitizen(AbstractEntityCitizen citizen, World world, BlockPos location) {
        if (citizen == null || world == null) {
            return false;
        }
        BlockPos spawnPoint = EntityUtils.getSpawnPoint(world, location);
        if (spawnPoint == null) {
            return false;
        }
        if (citizen.getCitizenSleepHandler().isAsleep()) {
            citizen.getCitizenSleepHandler().onWakeUp();
        }
        citizen.func_184210_p();
        citizen.func_70012_b((double)spawnPoint.func_177958_n() + 0.5, spawnPoint.func_177956_o(), (double)spawnPoint.func_177952_p() + 0.5, citizen.getRotationYaw(), citizen.getRotationPitch());
        if (citizen.getProxy() != null) {
            citizen.getProxy().reset();
        }
        citizen.getNavigator().func_75499_g();
        if (citizen.getProxy() != null) {
            citizen.getProxy().reset();
        }
        return true;
    }

    public static void homeTeleport(@NotNull ServerPlayerEntity player) {
        IColony colony = IColonyManager.getInstance().getIColonyByOwner(player.func_130014_f_(), (PlayerEntity)player);
        if (colony == null) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[0]);
            return;
        }
        TeleportHelper.colonyTeleport(player, colony);
    }

    public static void surfaceTeleport(@NotNull ServerPlayerEntity player) {
        BlockPos position = new BlockPos(player.func_226277_ct_(), 250.0, player.func_226281_cx_());
        ServerWorld world = player.func_71121_q();
        position = BlockPosUtil.findLand(position, (World)world);
        ChunkPos chunkpos = new ChunkPos(position);
        world.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)player.func_145782_y());
        player.func_184210_p();
        if (player.func_70608_bn()) {
            player.func_225652_a_(true, true);
        }
        player.func_200619_a(world, (double)position.func_177958_n(), (double)position.func_177956_o() + 2.0, (double)position.func_177952_p(), player.field_70177_z, player.field_70125_A);
    }

    public static void colonyTeleportByID(@NotNull ServerPlayerEntity player, int id, int dimension) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(id, dimension);
        if (colony == null) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[0]);
            return;
        }
        TeleportHelper.colonyTeleport(player, colony);
    }

    public static void colonyTeleport(@NotNull ServerPlayerEntity player, @NotNull IColony colony) {
        BlockPos position = colony.getBuildingManager().getTownHall() != null ? colony.getBuildingManager().getTownHall().getPosition() : colony.getCenter();
        ServerWorld world = player.func_184102_h().func_71218_a(DimensionType.func_186069_a((int)colony.getDimension()));
        ChunkPos chunkpos = new ChunkPos(position);
        world.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)player.func_145782_y());
        player.func_184210_p();
        if (player.func_70608_bn()) {
            player.func_225652_a_(true, true);
        }
        player.func_200619_a(world, (double)position.func_177958_n(), (double)position.func_177956_o() + 2.0, (double)position.func_177952_p(), player.field_70177_z, player.field_70125_A);
        LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.command.teleport.success", (Object[])new Object[]{colony.getName()});
    }
}

