/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.IRBlocks;
import cam72cam.immersiverailroading.IRCommand;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.entity.CarFreight;
import cam72cam.immersiverailroading.entity.CarPassenger;
import cam72cam.immersiverailroading.entity.CarTank;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.HandCar;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.gui.overlay.DieselLocomotiveOverlay;
import cam72cam.immersiverailroading.gui.overlay.HandCarOverlay;
import cam72cam.immersiverailroading.gui.overlay.SteamLocomotiveOverlay;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.library.Particles;
import cam72cam.immersiverailroading.multiblock.BoilerRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.CastingMultiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockRegistry;
import cam72cam.immersiverailroading.multiblock.PlateRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.RailRollerMultiblock;
import cam72cam.immersiverailroading.multiblock.SteamHammerMultiblock;
import cam72cam.immersiverailroading.net.BuildableStockSyncPacket;
import cam72cam.immersiverailroading.net.ItemRailUpdatePacket;
import cam72cam.immersiverailroading.net.ItemTrackExchangerUpdatePacket;
import cam72cam.immersiverailroading.net.KeyPressPacket;
import cam72cam.immersiverailroading.net.MRSSyncPacket;
import cam72cam.immersiverailroading.net.MultiblockSelectCraftPacket;
import cam72cam.immersiverailroading.net.PreviewRenderPacket;
import cam72cam.immersiverailroading.net.SoundPacket;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.render.SmokeParticle;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.render.block.RailBaseModel;
import cam72cam.immersiverailroading.render.entity.StockModel;
import cam72cam.immersiverailroading.render.item.ObjItemRender;
import cam72cam.immersiverailroading.render.item.PlateItemModel;
import cam72cam.immersiverailroading.render.item.RailAugmentItemModel;
import cam72cam.immersiverailroading.render.item.RailCastItemRender;
import cam72cam.immersiverailroading.render.item.RailItemRender;
import cam72cam.immersiverailroading.render.item.StockItemComponentModel;
import cam72cam.immersiverailroading.render.item.StockItemModel;
import cam72cam.immersiverailroading.render.item.TrackBlueprintItemModel;
import cam72cam.immersiverailroading.render.item.TrackExchangerModel;
import cam72cam.immersiverailroading.render.multiblock.MBBlueprintRender;
import cam72cam.immersiverailroading.render.multiblock.TileMultiblockRender;
import cam72cam.immersiverailroading.render.rail.RailPreviewRender;
import cam72cam.immersiverailroading.thirdparty.CompatLoader;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailGag;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.IRFuzzy;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.ModCore;
import cam72cam.mod.ModEvent;
import cam72cam.mod.block.BlockType;
import cam72cam.mod.config.ConfigFile;
import cam72cam.mod.entity.EntityRegistry;
import cam72cam.mod.input.Keyboard;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.net.Packet;
import cam72cam.mod.net.PacketDirection;
import cam72cam.mod.render.BlockRender;
import cam72cam.mod.render.EntityRenderer;
import cam72cam.mod.render.GlobalRender;
import cam72cam.mod.render.IEntityRender;
import cam72cam.mod.render.ItemRender;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.Particle;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.ISound;
import cam72cam.mod.text.Command;
import java.io.IOException;
import java.util.function.Function;

public class ImmersiveRailroading
extends ModCore.Mod {
    public static final String MODID = "immersiverailroading";
    public static final int ENTITY_SYNC_DISTANCE = 512;
    private static ImmersiveRailroading instance;

    public ImmersiveRailroading() {
        instance = this;
    }

    public String modID() {
        return MODID;
    }

    public void commonEvent(ModEvent event) {
        CompatLoader.common(event);
        switch (event) {
            case CONSTRUCT: {
                EntityRegistry.register((ModCore.Mod)instance, CarFreight::new, (int)512);
                EntityRegistry.register((ModCore.Mod)instance, CarPassenger::new, (int)512);
                EntityRegistry.register((ModCore.Mod)instance, CarTank::new, (int)512);
                EntityRegistry.register((ModCore.Mod)instance, HandCar::new, (int)512);
                EntityRegistry.register((ModCore.Mod)instance, LocomotiveDiesel::new, (int)512);
                EntityRegistry.register((ModCore.Mod)instance, LocomotiveSteam::new, (int)512);
                EntityRegistry.register((ModCore.Mod)instance, Tender::new, (int)512);
                Packet.register(BuildableStockSyncPacket::new, (PacketDirection)PacketDirection.ServerToClient);
                Packet.register(ItemRailUpdatePacket::new, (PacketDirection)PacketDirection.ClientToServer);
                Packet.register(MRSSyncPacket::new, (PacketDirection)PacketDirection.ServerToClient);
                Packet.register(MultiblockSelectCraftPacket::new, (PacketDirection)PacketDirection.ClientToServer);
                Packet.register(PreviewRenderPacket::new, (PacketDirection)PacketDirection.ServerToClient);
                Packet.register(SoundPacket::new, (PacketDirection)PacketDirection.ServerToClient);
                Packet.register(KeyPressPacket::new, (PacketDirection)PacketDirection.ClientToServer);
                Packet.register(ItemTrackExchangerUpdatePacket::new, (PacketDirection)PacketDirection.ClientToServer);
                IRBlocks.register();
                IRItems.register();
                GuiTypes.register();
                Command.register((Command)new IRCommand());
                break;
            }
            case INITIALIZE: {
                Config.init();
                ConfigFile.sync(Config.class);
                ConfigFile.sync(ConfigGraphics.class);
                ConfigFile.sync(ConfigSound.class);
                try {
                    DefinitionManager.initDefinitions();
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load IR definitions", e);
                }
            }
            case FINALIZE: {
                MultiblockRegistry.register("STEAM_HAMMER", new SteamHammerMultiblock());
                MultiblockRegistry.register("PLATE_MACHINE", new PlateRollerMultiblock());
                MultiblockRegistry.register("RAIL_MACHINE", new RailRollerMultiblock());
                MultiblockRegistry.register("BOILER_MACHINE", new BoilerRollerMultiblock());
                MultiblockRegistry.register("CASTING", new CastingMultiblock());
                IRFuzzy.applyFallbacks();
            }
        }
    }

    public void clientEvent(ModEvent event) {
        switch (event) {
            case CONSTRUCT: {
                BlockRender.register((BlockType)IRBlocks.BLOCK_RAIL, RailBaseModel::getModel, TileRail.class);
                BlockRender.register((BlockType)IRBlocks.BLOCK_RAIL_GAG, RailBaseModel::getModel, TileRailGag.class);
                BlockRender.register((BlockType)IRBlocks.BLOCK_RAIL_PREVIEW, RailPreviewRender::render, TileRailPreview.class);
                BlockRender.register((BlockType)IRBlocks.BLOCK_MULTIBLOCK, TileMultiblockRender::render, TileMultiblock.class);
                ItemRender.register((CustomItem)IRItems.ITEM_PLATE, (ItemRender.IItemModel)new PlateItemModel());
                ItemRender.register((CustomItem)IRItems.ITEM_AUGMENT, (ItemRender.IItemModel)new RailAugmentItemModel());
                ItemRender.register((CustomItem)IRItems.ITEM_RAIL, (ItemRender.IItemModel)new RailItemRender());
                ItemRender.register((CustomItem)IRItems.ITEM_CAST_RAIL, (ItemRender.IItemModel)new RailCastItemRender());
                ItemRender.register((CustomItem)IRItems.ITEM_TRACK_BLUEPRINT, (ItemRender.IItemModel)new TrackBlueprintItemModel());
                ItemRender.register((CustomItem)IRItems.ITEM_ROLLING_STOCK_COMPONENT, (ItemRender.IItemModel)new StockItemComponentModel());
                ItemRender.register((CustomItem)IRItems.ITEM_ROLLING_STOCK, (ItemRender.IItemModel)new StockItemModel());
                ItemRender.register((CustomItem)IRItems.ITEM_LARGE_WRENCH, (ItemRender.IItemModel)ObjItemRender.getModelFor(new Identifier(MODID, "models/item/wrench/wrench.obj"), new Vec3d(0.5, 0.0, 0.5), 2.0f));
                ItemRender.register((CustomItem)IRItems.ITEM_CONDUCTOR_WHISTLE, (ItemRender.IItemModel)ObjItemRender.getModelFor(new Identifier(MODID, "models/item/whistle.obj"), new Vec3d(0.5, 0.75, 0.5), 0.1f));
                ItemRender.register((CustomItem)IRItems.ITEM_GOLDEN_SPIKE, (ItemRender.IItemModel)ObjItemRender.getModelFor(new Identifier(MODID, "models/item/goldenspike/goldenspike.obj"), new Vec3d(0.5, 0.5, 0.5), 0.1f));
                ItemRender.register((CustomItem)IRItems.ITEM_HOOK, (ItemRender.IItemModel)ObjItemRender.getModelFor(new Identifier(MODID, "models/item/brake_stick.obj"), new Vec3d(0.5, 0.0, 0.5), 2.0f));
                ItemRender.register((CustomItem)IRItems.ITEM_SWITCH_KEY, (ItemRender.IItemModel)ObjItemRender.getModelFor(new Identifier(MODID, "models/item/switch_key/switch_key.obj"), new Vec3d(0.5, 0.0, 0.5), 1.0f));
                ItemRender.register((CustomItem)IRItems.ITEM_PAINT_BRUSH, (ItemRender.IItemModel)ObjItemRender.getModelFor(new Identifier(MODID, "models/item/paint_brush.obj"), new Vec3d(0.5, 0.25, 0.5), 3.0f));
                ItemRender.register((CustomItem)IRItems.ITEM_RADIO_CONTROL_CARD, (Identifier)new Identifier(MODID, "items/radio_card"));
                ItemRender.register((CustomItem)IRItems.ITEM_MANUAL, (Identifier)new Identifier(MODID, "items/engineerslexicon"));
                ItemRender.register((CustomItem)IRItems.ITEM_TRACK_EXCHANGER, (ItemRender.IItemModel)new TrackExchangerModel());
                IEntityRender stockRender = (entity, partialTicks) -> {
                    try (OpenGL.With light = OpenGL.bool((int)2896, (boolean)true);
                         OpenGL.With cull = OpenGL.bool((int)2884, (boolean)false);){
                        StockModel renderer = StockRenderCache.getRender(entity.getDefinitionID());
                        if (renderer != null) {
                            renderer.draw((EntityRollingStock)entity, partialTicks);
                        }
                    }
                };
                EntityRenderer.register(LocomotiveSteam.class, (IEntityRender)stockRender);
                EntityRenderer.register(LocomotiveDiesel.class, (IEntityRender)stockRender);
                EntityRenderer.register(CarPassenger.class, (IEntityRender)stockRender);
                EntityRenderer.register(CarFreight.class, (IEntityRender)stockRender);
                EntityRenderer.register(CarTank.class, (IEntityRender)stockRender);
                EntityRenderer.register(Tender.class, (IEntityRender)stockRender);
                EntityRenderer.register(HandCar.class, (IEntityRender)stockRender);
                Function<KeyTypes, Runnable> onKeyPress = type -> () -> new KeyPressPacket((KeyTypes)((Object)type)).sendToServer();
                Keyboard.registerKey((String)"ir_keys.increase_throttle", (Keyboard.KeyCode)Keyboard.KeyCode.NUMPAD8, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.THROTTLE_UP));
                Keyboard.registerKey((String)"ir_keys.zero_throttle", (Keyboard.KeyCode)Keyboard.KeyCode.NUMPAD5, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.THROTTLE_ZERO));
                Keyboard.registerKey((String)"ir_keys.decrease_throttle", (Keyboard.KeyCode)Keyboard.KeyCode.NUMPAD2, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.THROTTLE_DOWN));
                Keyboard.registerKey((String)"ir_keys.increase_brake", (Keyboard.KeyCode)Keyboard.KeyCode.NUMPAD7, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.AIR_BRAKE_UP));
                Keyboard.registerKey((String)"ir_keys.zero_brake", (Keyboard.KeyCode)Keyboard.KeyCode.NUMPAD4, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.AIR_BRAKE_ZERO));
                Keyboard.registerKey((String)"ir_keys.decrease_brake", (Keyboard.KeyCode)Keyboard.KeyCode.NUMPAD1, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.AIR_BRAKE_DOWN));
                Keyboard.registerKey((String)"ir_keys.horn", (Keyboard.KeyCode)Keyboard.KeyCode.NUMPADENTER, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.HORN));
                Keyboard.registerKey((String)"ir_keys.dead_mans_switch", (Keyboard.KeyCode)Keyboard.KeyCode.MULTIPLY, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.DEAD_MANS_SWITCH));
                Keyboard.registerKey((String)"ir_keys.start_stop_engine", (Keyboard.KeyCode)Keyboard.KeyCode.ADD, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.START_STOP_ENGINE));
                Keyboard.registerKey((String)"ir_keys.bell", (Keyboard.KeyCode)Keyboard.KeyCode.SUBTRACT, (String)"key.categories.immersiverailroading", (Runnable)onKeyPress.apply(KeyTypes.BELL));
                Keyboard.registerKey((String)"ir_keys.config", (Keyboard.KeyCode)Keyboard.KeyCode.DIVIDE, (String)"key.categories.immersiverailroading", () -> GuiTypes.CONFIG.open(MinecraftClient.getPlayer()));
                break;
            }
            case SETUP: {
                if (ConfigSound.overrideSoundChannels) {
                    Audio.setSoundChannels((int)300);
                }
                GlobalRender.registerItemMouseover((CustomItem)IRItems.ITEM_TRACK_BLUEPRINT, TrackBlueprintItemModel::renderMouseover);
                GlobalRender.registerItemMouseover((CustomItem)IRItems.ITEM_MANUAL, MBBlueprintRender::renderMouseover);
                GlobalRender.registerOverlay(pt -> {
                    new SteamLocomotiveOverlay().draw();
                    new DieselLocomotiveOverlay().draw();
                    new HandCarOverlay().draw();
                });
                Particles.SMOKE = Particle.register(SmokeParticle::new, SmokeParticle::renderAll);
                break;
            }
            case RELOAD: {
                try {
                    DefinitionManager.initDefinitions();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to load IR definitions", e);
                }
                StockRenderCache.clearRenderCache();
            }
        }
    }

    public void serverEvent(ModEvent event) {
        switch (event) {
            case SETUP: {
                for (EntityRollingStockDefinition def : DefinitionManager.getDefinitions()) {
                    def.clearModel();
                }
                break;
            }
        }
    }

    public static ISound newSound(Identifier oggLocation, boolean repeats, float attenuationDistance, Gauge gauge) {
        return Audio.newSound((Identifier)oggLocation, (boolean)repeats, (float)((float)((double)attenuationDistance * gauge.scale() * ConfigSound.soundDistanceScale)), (float)((float)Math.sqrt(Math.sqrt(gauge.scale()))));
    }
}

