/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.custom.IRidable;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class EntityRidableRollingStock
extends EntityBuildableRollingStock
implements IRidable {
    @TagField(value="payingPassengerPositions", mapper=PassengerMapper.class)
    private final Map<UUID, Vec3d> payingPassengerPositions = new HashMap<UUID, Vec3d>();

    public float getRidingSoundModifier() {
        return this.getDefinition().dampeningAmount;
    }

    @Override
    public ClickResult onClick(Player player, Player.Hand hand) {
        ClickResult clickRes = super.onClick(player, hand);
        if (clickRes != ClickResult.PASS) {
            return clickRes;
        }
        if (player.isCrouching()) {
            return ClickResult.PASS;
        }
        if (this.isPassenger((Entity)player)) {
            return ClickResult.PASS;
        }
        if (this.getWorld().isServer) {
            player.startRiding((Entity)this);
        }
        return ClickResult.ACCEPTED;
    }

    public Vec3d getMountOffset(Entity passenger, Vec3d off) {
        if (passenger.isVillager() && !this.payingPassengerPositions.containsKey(passenger.getUUID())) {
            this.payingPassengerPositions.put(passenger.getUUID(), passenger.getPosition());
        }
        int wiggle = passenger.isVillager() ? 10 : 2;
        off = off.add((Math.random() - 0.5) * (double)wiggle, 0.0, (Math.random() - 0.5) * (double)wiggle);
        off = this.getDefinition().correctPassengerBounds(this.gauge, off, this.shouldRiderSit(passenger));
        return off;
    }

    public boolean canFitPassenger(Entity passenger) {
        return this.getPassengerCount() < this.getDefinition().getMaxPassengers();
    }

    public boolean shouldRiderSit(Entity passenger) {
        if (this.getDefinition().shouldSit != null) {
            return this.getDefinition().shouldSit;
        }
        return this.gauge.shouldSit();
    }

    public Vec3d onPassengerUpdate(Entity passenger, Vec3d offset) {
        if (passenger.isPlayer()) {
            offset = this.playerMovement(passenger.asPlayer(), offset);
        }
        offset = this.getDefinition().correctPassengerBounds(this.gauge, offset, this.shouldRiderSit(passenger));
        return offset;
    }

    private Vec3d playerMovement(Player source, Vec3d offset) {
        Vec3d movement = source.getMovementInput();
        if (movement.length() < 0.1) {
            return offset;
        }
        movement = new Vec3d(movement.x, 0.0, movement.z).rotateMinecraftYaw(source.getRotationYawHead() - this.getRotationYaw());
        offset = offset.add(movement);
        if (this instanceof EntityCoupleableRollingStock) {
            EntityCoupleableRollingStock couplable = (EntityCoupleableRollingStock)this;
            boolean atFront = this.getDefinition().isAtFront(this.gauge, offset);
            boolean atBack = this.getDefinition().isAtRear(this.gauge, offset);
            for (EntityCoupleableRollingStock.CouplerType coupler : EntityCoupleableRollingStock.CouplerType.values()) {
                boolean atCoupler;
                boolean bl = atCoupler = coupler == EntityCoupleableRollingStock.CouplerType.FRONT ? atFront : atBack;
                if (!atCoupler || !couplable.isCoupled(coupler)) continue;
                EntityCoupleableRollingStock coupled = ((EntityCoupleableRollingStock)this).getCoupled(coupler);
                if (coupled != null) {
                    coupled.addPassenger((Entity)source);
                } else if (this.getTickCount() > 20) {
                    ImmersiveRailroading.info((String)"Tried to move between cars (%s, %s), but %s was not found", (Object[])new Object[]{this.getUUID(), couplable.getCoupledUUID(coupler), couplable.getCoupledUUID(coupler)});
                    ((EntityCoupleableRollingStock)this).decouple(coupler);
                }
                return offset;
            }
        }
        return offset;
    }

    public Vec3d onDismountPassenger(Entity passenger, Vec3d offset) {
        offset = new Vec3d(Math.copySign(this.getDefinition().getWidth(this.gauge) / 2.0 + 1.0, offset.x), 0.0, offset.z);
        if (this.getWorld().isServer && passenger.isVillager() && this.payingPassengerPositions.containsKey(passenger.getUUID())) {
            double distanceMoved = passenger.getPosition().distanceTo(this.getPosition());
            int payout = (int)Math.floor(distanceMoved * Config.ConfigBalance.villagerPayoutPerMeter);
            List<ItemStack> payouts = Config.ConfigBalance.getVillagerPayout();
            if (payouts.size() != 0) {
                int type = (int)(Math.random() * 100.0) % payouts.size();
                ItemStack stack = payouts.get(type).copy();
                stack.setCount(payout);
                this.getWorld().dropItem(stack, this.getBlockPosition());
            }
        }
        return offset;
    }

    private static class PassengerMapper
    implements TagMapper<Map<UUID, Vec3d>> {
        private PassengerMapper() {
        }

        public TagMapper.TagAccessor<Map<UUID, Vec3d>> apply(Class<Map<UUID, Vec3d>> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((d, o) -> d.setMap(fieldName, o, UUID::toString, pos -> new TagCompound().setVec3d("pos", pos)), d -> d.getMap(fieldName, UUID::fromString, t -> t.getVec3d("pos")));
        }
    }
}

