/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.mod.entity.CustomEntity;
import cam72cam.mod.entity.DamageType;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.custom.IClickable;
import cam72cam.mod.entity.custom.IKillable;
import cam72cam.mod.entity.custom.ITickable;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.serialization.StrictTagMapper;
import cam72cam.mod.serialization.TagField;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class EntityRollingStock
extends CustomEntity
implements ITickable,
IClickable,
IKillable {
    @TagField(value="defID")
    protected String defID;
    @TagField(value="gauge")
    public Gauge gauge;
    @TagField(value="tag")
    public String tag = "";
    @TagSync
    @TagField(value="texture", mapper=StrictTagMapper.class)
    private String texture = null;

    public void setup(String defID, Gauge gauge, String texture) {
        this.defID = defID;
        this.gauge = gauge;
        this.texture = texture;
    }

    public boolean isImmuneToFire() {
        return true;
    }

    public float getCollisionReduction() {
        return 1.0f;
    }

    public boolean canBePushed() {
        return false;
    }

    public boolean allowsDefaultMovement() {
        return false;
    }

    public String tryJoinWorld() {
        if (DefinitionManager.getDefinition(this.defID) == null) {
            String error = String.format("Missing definition %s, do you have all of the required resource packs?", this.defID);
            ImmersiveRailroading.error((String)error, (Object[])new Object[0]);
            return error;
        }
        return null;
    }

    public EntityRollingStockDefinition getDefinition() {
        return this.getDefinition(EntityRollingStockDefinition.class);
    }

    public <T extends EntityRollingStockDefinition> T getDefinition(Class<T> type) {
        EntityRollingStockDefinition def = DefinitionManager.getDefinition(this.defID);
        if (def == null) {
            try {
                return (T)((EntityRollingStockDefinition)type.getConstructor(String.class, JsonObject.class).newInstance(this.defID, null));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return (T)((EntityRollingStockDefinition)type.cast(def));
    }

    public String getDefinitionID() {
        return this.defID;
    }

    public void onTick() {
        EntityRollingStockDefinition def;
        if (this.getWorld().isServer && this.getTickCount() % 5 == 0 && (def = DefinitionManager.getDefinition(this.defID)) == null) {
            this.kill();
        }
    }

    public ClickResult onClick(Player player, Player.Hand hand) {
        if (player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_PAINT_BRUSH)) {
            ArrayList<String> texNames = new ArrayList<String>(this.getDefinition().textureNames.keySet());
            if (texNames.size() > 1) {
                int idx = texNames.indexOf(this.texture);
                idx = (idx + (player.isCrouching() ? -1 : 1) + texNames.size()) % texNames.size();
                this.texture = (String)texNames.get(idx);
                return ClickResult.ACCEPTED;
            }
            player.sendMessage(ChatText.BRUSH_NO_VARIANTS.getMessage(new Object[0]));
            return ClickResult.ACCEPTED;
        }
        return ClickResult.PASS;
    }

    public void onDamage(DamageType type, Entity source, float amount, boolean bypassesArmor) {
        Player player;
        if (this.getWorld().isClient) {
            return;
        }
        if (type == DamageType.EXPLOSION && (source == null || !source.isMob()) && amount > 5.0f && Config.ConfigDamage.trainMobExplosionDamage) {
            this.kill();
        }
        if (type == DamageType.OTHER && source != null && source.isPlayer() && (player = source.asPlayer()).isCrouching()) {
            this.kill();
        }
    }

    public void onRemoved() {
    }

    protected boolean shouldDropItems(DamageType type, float amount) {
        return type != DamageType.EXPLOSION || amount < 20.0f;
    }

    public void handleKeyPress(Player source, KeyTypes key) {
    }

    public double getWeight() {
        return this.getDefinition().getWeight(this.gauge);
    }

    public void triggerResimulate() {
    }

    public Gauge soundGauge() {
        return this.getDefinition().shouldScalePitch() ? this.gauge : Gauge.from(1.435);
    }

    public String getTexture() {
        return this.texture;
    }
}

