/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.items.ItemRadioCtrlCard;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.library.Particles;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.render.SmokeParticle;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.gui.GuiRegistry;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.serialization.StrictTagMapper;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.sound.ISound;
import cam72cam.mod.world.World;
import java.util.UUID;

public abstract class Locomotive
extends FreightTank {
    public ISound bell;
    private static final float throttleNotch = 0.04f;
    private static final float airBrakeNotch = 0.04f;
    @TagField(value="deadMansSwitch")
    private boolean deadMansSwitch;
    private int deadManChangeTimeout;
    @TagSync
    @TagField(value="THROTTLE")
    private float throttle = 0.0f;
    @TagSync
    @TagField(value="AIR_BRAKE")
    private float airBrake = 0.0f;
    @TagSync
    @TagField(value="HORN")
    protected int hornTime = 0;
    @TagSync
    @TagField(value="HORN_PLAYER", mapper=StrictTagMapper.class)
    protected UUID hornPlayer = null;
    @TagSync
    @TagField(value="BELL")
    private int bellTime = 0;
    private int bellKeyTimeout;

    @Override
    public LocomotiveDefinition getDefinition() {
        return super.getDefinition(LocomotiveDefinition.class);
    }

    @Override
    public GuiRegistry.EntityGUI guiType() {
        return null;
    }

    @Override
    public void handleKeyPress(Player source, KeyTypes key) {
        switch (key) {
            case HORN: {
                this.setHorn(10, source.getUUID());
                break;
            }
            case BELL: {
                if (this.getDefinition().toggleBell) {
                    if (this.bellKeyTimeout != 0) break;
                    this.bellTime = this.bellTime != 0 ? 0 : 10;
                    this.bellKeyTimeout = 10;
                    break;
                }
                this.setBell(10);
                break;
            }
            case THROTTLE_UP: {
                if (!(this.getThrottle() < 1.0f)) break;
                this.setThrottle(this.getThrottle() + 0.04f);
                break;
            }
            case THROTTLE_ZERO: {
                this.setThrottle(0.0f);
                break;
            }
            case THROTTLE_DOWN: {
                if (!(this.getThrottle() > -1.0f)) break;
                this.setThrottle(this.getThrottle() - 0.04f);
                break;
            }
            case AIR_BRAKE_UP: {
                if (!(this.getAirBrake() < 1.0f)) break;
                this.setAirBrake(this.getAirBrake() + 0.04f);
                break;
            }
            case AIR_BRAKE_ZERO: {
                this.setAirBrake(0.0f);
                break;
            }
            case AIR_BRAKE_DOWN: {
                if (!(this.getAirBrake() > 0.0f)) break;
                this.setAirBrake(this.getAirBrake() - 0.04f);
                break;
            }
            case DEAD_MANS_SWITCH: {
                if (this.deadManChangeTimeout != 0) break;
                boolean bl = this.deadMansSwitch = !this.deadMansSwitch;
                if (this.deadMansSwitch) {
                    source.sendMessage(ChatText.DEADMANS_SWITCH_ENABLED.getMessage(new Object[0]));
                } else {
                    source.sendMessage(ChatText.DEADMANS_SWITCH_DISABLED.getMessage(new Object[0]));
                }
                this.deadManChangeTimeout = 5;
                break;
            }
            default: {
                super.handleKeyPress(source, key);
            }
        }
    }

    @Override
    public ClickResult onClick(Player player, Player.Hand hand) {
        if (player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_RADIO_CONTROL_CARD)) {
            if (this.gauge.isModel() || this.getDefinition().getRadioCapability() || !Config.ConfigBalance.RadioEquipmentRequired) {
                ItemRadioCtrlCard.Data data = new ItemRadioCtrlCard.Data(player.getHeldItem(hand));
                if (player.isCrouching()) {
                    player.sendMessage(data.linked == null ? ChatText.RADIO_NOLINK.getMessage(new Object[0]) : ChatText.RADIO_UNLINK.getMessage(new Object[0]));
                    data.linked = null;
                } else {
                    player.sendMessage(data.linked == null ? ChatText.RADIO_LINK.getMessage(new Object[0]) : ChatText.RADIO_RELINK.getMessage(new Object[0]));
                    data.linked = this.getUUID();
                }
                data.write();
            } else {
                player.sendMessage(ChatText.RADIO_CANT_LINK.getMessage(this.getDefinition().name()));
            }
            return ClickResult.ACCEPTED;
        }
        return super.onClick(player, hand);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.getWorld().isServer) {
            if (this.deadManChangeTimeout > 0) {
                --this.deadManChangeTimeout;
            }
            if (this.bellKeyTimeout > 0) {
                --this.bellKeyTimeout;
            }
            if (this.deadMansSwitch && !this.getCurrentSpeed().isZero()) {
                boolean hasDriver = false;
                for (Entity entity : this.getPassengers()) {
                    if (!entity.isPlayer()) continue;
                    hasDriver = true;
                    break;
                }
                if (!hasDriver) {
                    this.setThrottle(0.0f);
                    this.setAirBrake(1.0f);
                }
            }
            if (this.hornTime > 0) {
                --this.hornTime;
            } else if (this.hornPlayer != null) {
                this.hornPlayer = null;
            }
            if (this.bellTime > 0 && !this.getDefinition().toggleBell) {
                --this.bellTime;
            }
        } else if (ConfigSound.soundEnabled && this.bell != null) {
            if (this.bellTime != 0 && !this.bell.isPlaying()) {
                this.bell.setVolume(0.8f);
                this.bell.play(this.getPosition());
            } else if (this.bellTime == 0 && this.bell.isPlaying()) {
                this.bell.stop();
            }
            if (this.bell.isPlaying()) {
                this.bell.setPosition(this.getPosition());
                this.bell.setVelocity(this.getVelocity());
                this.bell.update();
            }
        }
        this.simulateWheelSlip();
    }

    protected abstract int getAvailableHP();

    private double getAppliedTractiveEffort(Speed speed) {
        double locoEfficiency = 0.7f;
        double outputHorsepower = Math.abs(Math.pow(this.getThrottle(), 3.0) * (double)this.getAvailableHP());
        double tractiveEffortNewtons = 2650.0 * (locoEfficiency * outputHorsepower / Math.max(1.4, Math.abs(speed.metric())));
        return tractiveEffortNewtons;
    }

    private void simulateWheelSlip() {
        double tractiveEffortNewtons = this.getAppliedTractiveEffort(this.getCurrentSpeed());
        double staticTractiveEffort = (double)this.getDefinition().getStartingTractionNewtons(this.gauge) * this.slipCoefficient() * Config.ConfigBalance.tractionMultiplier;
        double adhesionFactor = tractiveEffortNewtons / (staticTractiveEffort *= 1.5);
        if (adhesionFactor > 1.0) {
            this.distanceTraveled = (float)((double)this.distanceTraveled + Math.copySign(Math.min((adhesionFactor - 1.0) / 10.0, 1.0), (double)this.getThrottle()));
        }
    }

    public double getTractiveEffortNewtons(Speed speed) {
        if (!this.isBuilt()) {
            return 0.0;
        }
        double tractiveEffortNewtons = this.getAppliedTractiveEffort(speed);
        double staticTractiveEffort = (double)this.getDefinition().getStartingTractionNewtons(this.gauge) * this.slipCoefficient() * Config.ConfigBalance.tractionMultiplier;
        double adhesionFactor = tractiveEffortNewtons / (staticTractiveEffort *= 1.5);
        if (adhesionFactor > 1.0) {
            double us = 0.74;
            double uk = 0.57;
            tractiveEffortNewtons = staticTractiveEffort * (uk / us) / adhesionFactor;
        }
        if (Math.abs(speed.minecraft()) > this.getDefinition().getMaxSpeed(this.gauge).minecraft()) {
            tractiveEffortNewtons = 0.0;
        }
        return Math.copySign(tractiveEffortNewtons, (double)this.getThrottle());
    }

    public float getThrottle() {
        return this.throttle;
    }

    public void setThrottle(float newThrottle) {
        if (this.getThrottle() != newThrottle) {
            this.throttle = newThrottle;
            this.triggerResimulate();
        }
    }

    public void setHorn(int val, UUID uuid) {
        if (this.hornPlayer == null && uuid != null) {
            this.hornPlayer = uuid;
        }
        if (this.hornPlayer == null || this.hornPlayer.equals(uuid)) {
            this.hornTime = val;
        }
    }

    public float getAirBrake() {
        return this.airBrake;
    }

    public void setAirBrake(float newAirBrake) {
        if (this.getAirBrake() != newAirBrake) {
            this.airBrake = newAirBrake;
            this.triggerResimulate();
        }
    }

    public void setBell(int newBell) {
        this.bellTime = newBell;
    }

    public double slipCoefficient() {
        double slipMult = 1.0;
        World world = this.getWorld();
        if (world.isPrecipitating() && world.canSeeSky(this.getBlockPosition())) {
            if (world.isRaining(this.getBlockPosition())) {
                slipMult = 0.6;
            }
            if (world.isSnowing(this.getBlockPosition())) {
                slipMult = 0.4;
            }
        }
        if (this.getCurrentSpeed().metric() != 0.0) {
            double balance = 1.0 - 0.004 * Math.abs(this.getCurrentSpeed().metric());
            slipMult *= balance;
        }
        return slipMult;
    }

    public float ambientTemperature() {
        return this.internal != null ? this.getWorld().getTemperature(this.getBlockPosition()) : 0.0f;
    }

    protected void addSmoke(Vec3d particlePos, Vec3d motion, int lifespan, float darken, float thickness, double diameter) {
        assert (this.getWorld().isClient);
        Particles.SMOKE.accept(new SmokeParticle.SmokeParticleData(this.getWorld(), particlePos, motion, lifespan, darken, thickness, diameter));
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.bell != null) {
            this.bell.stop();
        }
    }
}

