/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.inventory.SlotFilter;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.registry.Quilling;
import cam72cam.immersiverailroading.util.BurnUtil;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.immersiverailroading.util.LiquidUtil;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.fluid.Fluid;
import cam72cam.mod.fluid.FluidStack;
import cam72cam.mod.fluid.ITank;
import cam72cam.mod.gui.GuiRegistry;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import cam72cam.mod.sound.ISound;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LocomotiveSteam
extends Locomotive {
    @TagSync
    @TagField(value="boiler_psi")
    private float boilerPressure = 0.0f;
    @TagSync
    @TagField(value="boiler_temperature")
    private float boilerTemperature;
    @TagSync
    @TagField(value="pressure_valve")
    private boolean pressureValve = false;
    @TagSync
    @TagField(value="burn_time", mapper=SlotTagMapper.class)
    private Map<Integer, Integer> burnTime = new HashMap<Integer, Integer>();
    @TagSync
    @TagField(value="burn_max", mapper=SlotTagMapper.class)
    private Map<Integer, Integer> burnMax = new HashMap<Integer, Integer>();
    private Double driverDiameter;
    private float drainRemainder;
    private Map<String, Boolean> phaseOn = new HashMap<String, Boolean>();
    private List<ISound> sndCache = new ArrayList<ISound>();
    private int sndCacheId = 0;
    private ISound whistle;
    private List<ISound> chimes = new ArrayList<ISound>();
    private float pullString = 0.0f;
    private float soundDampener = 0.0f;
    private ISound idle;
    private ISound pressure;
    private int tickMod = 0;

    public LocomotiveSteam() {
        this.boilerTemperature = this.ambientTemperature();
    }

    @Override
    public LocomotiveSteamDefinition getDefinition() {
        return super.getDefinition(LocomotiveSteamDefinition.class);
    }

    @Override
    public GuiRegistry.EntityGUI guiType() {
        return GuiTypes.STEAM_LOCOMOTIVE;
    }

    private double getDriverDiameter() {
        if (this.driverDiameter == null) {
            this.driverDiameter = 0.0;
            List<RenderComponent> driving = this.getDefinition().getComponents(RenderComponentType.WHEEL_DRIVER_X, this.gauge);
            if (driving != null) {
                for (RenderComponent driver : driving) {
                    this.driverDiameter = Math.max(this.driverDiameter, driver.height());
                }
            }
            if ((driving = this.getDefinition().getComponents(RenderComponentType.WHEEL_DRIVER_REAR_X, this.gauge)) != null) {
                for (RenderComponent driver : driving) {
                    this.driverDiameter = Math.max(this.driverDiameter, driver.height());
                }
            }
        }
        return this.driverDiameter;
    }

    public float getBoilerTemperature() {
        return this.boilerTemperature;
    }

    private void setBoilerTemperature(float temp) {
        this.boilerTemperature = temp;
    }

    public float getBoilerPressure() {
        return this.boilerPressure;
    }

    private void setBoilerPressure(float temp) {
        this.boilerPressure = temp;
    }

    public Map<Integer, Integer> getBurnTime() {
        return this.burnTime;
    }

    public Map<Integer, Integer> getBurnMax() {
        return this.burnMax;
    }

    @Override
    protected int getAvailableHP() {
        if (!Config.isFuelRequired(this.gauge)) {
            return this.getDefinition().getHorsePower(this.gauge);
        }
        return (int)((double)this.getDefinition().getHorsePower(this.gauge) * Math.pow(this.getBoilerPressure() / (float)this.getDefinition().getMaxPSI(this.gauge), 3.0));
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.setBoilerTemperature(this.ambientTemperature());
        this.setBoilerPressure(0.0f);
        for (Integer slot : this.burnTime.keySet()) {
            this.burnTime.put(slot, 0);
        }
    }

    private double getPhase(int spikes, float offsetDegrees, double perc) {
        if (this.getDriverDiameter() == 0.0) {
            return 0.0;
        }
        double circumference = this.getDriverDiameter() * Math.PI;
        double skewDistance = (double)this.distanceTraveled - this.getCurrentSpeed().minecraft() * perc;
        double phase = skewDistance % circumference / circumference;
        phase = Math.abs(Math.cos(phase * Math.PI * (double)spikes + Math.toRadians(offsetDegrees)));
        return phase;
    }

    private double getPhase(int spikes, float offsetDegrees) {
        if (this.getDriverDiameter() == 0.0) {
            return 0.0;
        }
        double circumference = this.getDriverDiameter() * Math.PI;
        double phase = (double)this.distanceTraveled % circumference / circumference;
        phase = Math.abs(Math.cos(phase * Math.PI * (double)spikes + Math.toRadians(offsetDegrees)));
        return phase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onTick() {
        void var2_13;
        super.onTick();
        if (this.getTickCount() < 2) {
            return;
        }
        if (this.getWorld().isClient) {
            List<RenderComponent> steams;
            List<RenderComponent> whistles;
            if (ConfigSound.soundEnabled) {
                if (this.sndCache.size() == 0) {
                    this.whistle = ImmersiveRailroading.newSound(this.getDefinition().whistle, false, 150.0f, this.soundGauge());
                    this.bell = ImmersiveRailroading.newSound(this.getDefinition().bell, true, 150.0f, this.soundGauge());
                    this.whistle.setPitch(1.0f);
                    if (this.getDefinition().quill != null) {
                        for (Quilling.Chime chime : this.getDefinition().quill.chimes) {
                            this.chimes.add(ImmersiveRailroading.newSound(chime.sample, true, 150.0f, this.soundGauge()));
                        }
                    }
                    for (int i = 0; i < 8; ++i) {
                        this.sndCache.add(ImmersiveRailroading.newSound(this.getDefinition().chuff, false, 80.0f, this.soundGauge()));
                    }
                    this.idle = ImmersiveRailroading.newSound(this.getDefinition().idle, true, 40.0f, this.soundGauge());
                    this.idle.setVolume(0.1f);
                    this.pressure = ImmersiveRailroading.newSound(this.getDefinition().pressure, true, 40.0f, this.soundGauge());
                    this.pressure.setVolume(0.3f);
                }
                if (this.hornTime < 1) {
                    this.pullString = 0.0f;
                    this.soundDampener = 0.0f;
                    for (ISound iSound : this.chimes) {
                        if (!iSound.isPlaying()) continue;
                        iSound.stop();
                    }
                } else if (this.getBoilerPressure() > 0.0f || !Config.isFuelRequired(this.gauge)) {
                    if (this.getDefinition().quill == null) {
                        if (!this.whistle.isPlaying()) {
                            this.whistle.play(this.getPosition());
                        }
                    } else {
                        float maxDelta = 0.05f;
                        float f = 0.0f;
                        if (this.hornTime > 5) {
                            if ((double)this.soundDampener < 0.4) {
                                this.soundDampener = 0.4f;
                            }
                            if (this.soundDampener < 1.0f) {
                                this.soundDampener = (float)((double)this.soundDampener + 0.1);
                            }
                            if (this.hornPlayer != null) {
                                for (Entity pass : this.getPassengers()) {
                                    if (!pass.getUUID().equals(this.hornPlayer)) continue;
                                    float newString = (pass.getRotationPitch() + 90.0f) / 180.0f;
                                    f = newString - this.pullString;
                                }
                            } else {
                                f = (float)this.getDefinition().quill.maxPull - this.pullString;
                            }
                        } else {
                            if (this.soundDampener > 0.0f) {
                                this.soundDampener = (float)((double)this.soundDampener - 0.07);
                            }
                            f = -this.pullString;
                        }
                        this.pullString = this.pullString == 0.0f ? (float)((double)this.pullString + (double)f * 0.55) : (this.pullString += Math.max(Math.min(f, maxDelta), -maxDelta));
                        this.pullString = Math.min(this.pullString, (float)this.getDefinition().quill.maxPull);
                        for (int i = 0; i < this.getDefinition().quill.chimes.size(); ++i) {
                            ISound sound = this.chimes.get(i);
                            Quilling.Chime chime = this.getDefinition().quill.chimes.get(i);
                            double perc = this.pullString;
                            perc = Math.min(perc, chime.pull_end);
                            perc -= chime.pull_start;
                            if ((perc /= chime.pull_end - chime.pull_start) > 0.0) {
                                double pitch = (chime.pitch_end - chime.pitch_start) * perc + chime.pitch_start;
                                sound.setPitch((float)pitch);
                                sound.setVolume((float)(perc * (double)this.soundDampener));
                                if (sound.isPlaying()) continue;
                                sound.play(this.getPosition());
                                continue;
                            }
                            if (!sound.isPlaying()) continue;
                            sound.stop();
                        }
                    }
                }
                if (this.getBoilerTemperature() > this.ambientTemperature() + 5.0f) {
                    if (!this.idle.isPlaying()) {
                        this.idle.play(this.getPosition());
                    }
                } else if (this.idle.isPlaying()) {
                    this.idle.stop();
                }
            }
            Vec3d fakeMotion = this.getVelocity();
            List<RenderComponent> smokes = this.getDefinition().getComponents(RenderComponentType.PARTICLE_CHIMNEY_X, this.gauge);
            if (smokes != null && ConfigGraphics.particlesEnabled) {
                double phase = this.getPhase(4, 0.0f);
                for (RenderComponent smoke : smokes) {
                    Vec3d particlePos = this.getPosition().add(VecUtil.rotateWrongYaw(smoke.center(), this.getRotationYaw() + 180.0f));
                    particlePos = particlePos.subtract(fakeMotion);
                    if (this.getTickCount() % 1 != 0) continue;
                    float darken = 0.0f;
                    float thickness = Math.abs(this.getThrottle()) / 2.0f;
                    for (int i : this.burnTime.values()) {
                        darken += i >= 1 ? 1.0f : 0.0f;
                    }
                    if (darken == 0.0f && Config.isFuelRequired(this.gauge)) break;
                    darken = (float)((double)darken / ((double)this.getInventorySize() - 2.0));
                    darken = (float)((double)darken * 0.5);
                    double d = Math.min(1.0, Math.max(0.2, Math.abs(this.getCurrentSpeed().minecraft()) * 2.0));
                    int lifespan = (int)((double)(200.0f * (1.0f + Math.abs(this.getThrottle()))) * d * this.gauge.scale());
                    float verticalSpeed = 0.5f;
                    double size = smoke.width() * (0.8 + d);
                    if (phase != 0.0 && (double)Math.abs(this.getThrottle()) > 0.01 && Math.abs(this.getCurrentSpeed().metric()) / this.gauge.scale() < 30.0) {
                        double phaseSpike = Math.pow(phase, 8.0);
                        size *= 1.0 + phaseSpike * 1.5;
                        verticalSpeed = (float)((double)verticalSpeed * (1.0 + phaseSpike / 2.0));
                    }
                    particlePos = particlePos.subtract(fakeMotion);
                    this.addSmoke(particlePos, new Vec3d(fakeMotion.x, fakeMotion.y + (double)verticalSpeed, fakeMotion.z), lifespan, darken, thickness, size);
                }
            }
            if ((whistles = this.getDefinition().getComponents(RenderComponentType.WHISTLE, this.gauge)) != null && (this.hornTime != 0 || this.whistle != null && this.whistle.isPlaying()) && (this.getBoilerPressure() > 0.0f || !Config.isFuelRequired(this.gauge))) {
                for (RenderComponent whistle : whistles) {
                    Vec3d particlePos = this.getPosition().add(VecUtil.rotateWrongYaw(whistle.center(), this.getRotationYaw() + 180.0f));
                    particlePos = particlePos.subtract(fakeMotion);
                    float darken = 0.0f;
                    float f = 1.0f;
                    double smokeMod = Math.min(1.0, Math.max(0.2, Math.abs(this.getCurrentSpeed().minecraft()) * 2.0));
                    int lifespan = (int)(40.0 * (1.0 + smokeMod * this.gauge.scale()));
                    float verticalSpeed = 0.8f;
                    double size = 0.3 * (0.8 + smokeMod);
                    particlePos = particlePos.subtract(fakeMotion);
                    this.addSmoke(particlePos, new Vec3d(fakeMotion.x, fakeMotion.y + (double)verticalSpeed, fakeMotion.z), lifespan, darken, f, size);
                }
            }
            List<RenderComponent> pistons = this.getDefinition().getComponents(RenderComponentType.PISTON_ROD_SIDE, this.gauge);
            double csm = Math.abs(this.getCurrentSpeed().metric()) / this.gauge.scale();
            if (pistons != null && (this.getBoilerPressure() > 0.0f || !Config.isFuelRequired(this.gauge))) {
                block26: for (RenderComponent renderComponent : pistons) {
                    float phaseOffset;
                    double tickDelt;
                    switch (renderComponent.side) {
                        case "LEFT": {
                            tickDelt = 2.0;
                            phaseOffset = 135.0f;
                            break;
                        }
                        case "RIGHT": {
                            tickDelt = 2.0;
                            phaseOffset = this.getDefinition().getValveGear() != ValveGearType.TRI_WALSCHAERTS ? 45.0f : -105.0f;
                            break;
                        }
                        case "CENTER": {
                            tickDelt = 2.0;
                            phaseOffset = 15.0f;
                            break;
                        }
                        case "LEFT_FRONT": {
                            tickDelt = 1.0;
                            phaseOffset = 135.0f;
                            break;
                        }
                        case "RIGHT_FRONT": {
                            tickDelt = 1.0;
                            phaseOffset = 45.0f;
                            break;
                        }
                        case "LEFT_REAR": {
                            tickDelt = 1.0;
                            phaseOffset = 90.0f;
                            break;
                        }
                        case "RIGHT_REAR": {
                            tickDelt = 1.0;
                            phaseOffset = 0.0f;
                            break;
                        }
                        default: {
                            continue block26;
                        }
                    }
                    double phase = this.getPhase(2, phaseOffset);
                    double phaseSpike = Math.pow(phase, 4.0);
                    if (phaseSpike >= 0.6 && csm > 0.1 && csm < 20.0 && ConfigGraphics.particlesEnabled) {
                        Vec3d particlePos = this.getPosition().add(VecUtil.rotateWrongYaw(renderComponent.min(), this.getRotationYaw() + 180.0f));
                        double accell = 0.3 * this.gauge.scale();
                        if (renderComponent.side.contains("LEFT")) {
                            accell = -accell;
                        }
                        if (renderComponent.side.contains("CENTER")) {
                            accell = 0.0;
                        }
                        Vec3d sideMotion = fakeMotion.add(VecUtil.fromWrongYaw(accell, this.getRotationYaw() + 90.0f));
                        this.addSmoke(particlePos, new Vec3d(sideMotion.x, sideMotion.y + 0.01, sideMotion.z), 80, 0.0f, 0.6f, 0.2);
                    }
                    if (!ConfigSound.soundEnabled) continue;
                    String key = renderComponent.side;
                    if (!this.phaseOn.containsKey(key)) {
                        this.phaseOn.put(key, false);
                    }
                    for (int i = 0; i < 10; ++i) {
                        phase = this.getPhase(2, phaseOffset + 45.0f, 1.0 - (double)i / 10.0);
                        if (!this.phaseOn.get(key).booleanValue()) {
                            if (!(phase > 0.5)) continue;
                            double speed = Math.abs(this.getCurrentSpeed().minecraft());
                            double maxSpeed = Math.abs(this.getDefinition().getMaxSpeed(this.gauge).minecraft());
                            float volume = (float)Math.max(1.0 - speed / maxSpeed, 0.3) * Math.abs(this.getThrottle());
                            volume = (float)Math.sqrt(volume);
                            double fraction = 3.0;
                            float pitch = 0.8f + (float)(speed / maxSpeed / fraction);
                            float delta = (float)(8 - this.tickMod) / 200.0f;
                            ISound snd = this.sndCache.get(this.sndCacheId);
                            snd.setPitch(pitch + delta);
                            snd.setVolume(volume + delta);
                            snd.play(this.getPosition());
                            ++this.sndCacheId;
                            this.sndCacheId %= this.sndCache.size();
                            this.phaseOn.put(key, true);
                            this.tickMod = (int)((double)this.tickMod + tickDelt);
                            if (this.tickMod <= 8) continue;
                            this.tickMod = 0;
                            continue;
                        }
                        if (!(phase < 0.5)) continue;
                        this.phaseOn.put(key, false);
                    }
                }
            }
            if ((steams = this.getDefinition().getComponents(RenderComponentType.PRESSURE_VALVE_X, this.gauge)) != null && this.pressureValve && Config.isFuelRequired(this.gauge)) {
                if (ConfigSound.soundEnabled && ConfigSound.soundPressureValve && !this.pressure.isPlaying()) {
                    this.pressure.play(this.getPosition());
                }
                if (ConfigGraphics.particlesEnabled) {
                    for (RenderComponent steam : steams) {
                        Vec3d particlePos = this.getPosition().add(VecUtil.rotateWrongYaw(steam.center(), this.getRotationYaw() + 180.0f));
                        particlePos = particlePos.subtract(fakeMotion);
                        this.addSmoke(particlePos, new Vec3d(fakeMotion.x, fakeMotion.y + 0.2 * this.gauge.scale(), fakeMotion.z), 40, 0.0f, 0.2f, steam.width());
                    }
                }
            } else if (ConfigSound.soundEnabled && this.pressure.isPlaying()) {
                this.pressure.stop();
            }
            if (ConfigSound.soundEnabled) {
                if (this.whistle.isPlaying()) {
                    this.whistle.setPosition(this.getPosition());
                    this.whistle.setVelocity(this.getVelocity());
                    this.whistle.update();
                }
                for (ISound chime : this.chimes) {
                    if (!chime.isPlaying()) continue;
                    chime.setPosition(this.getPosition());
                    chime.setVelocity(this.getVelocity());
                    chime.update();
                }
                if (this.idle.isPlaying()) {
                    this.idle.setPosition(this.getPosition());
                    this.idle.setVelocity(this.getVelocity());
                    this.idle.update();
                }
                if (this.pressure.isPlaying()) {
                    this.pressure.setPosition(this.getPosition());
                    this.pressure.setVelocity(this.getVelocity());
                    this.pressure.update();
                }
                for (ISound snd : this.sndCache) {
                    if (!snd.isPlaying()) continue;
                    snd.setPosition(this.getPosition());
                    snd.setVelocity(this.getVelocity());
                    snd.update();
                }
            }
            return;
        }
        if (!this.isBuilt()) {
            return;
        }
        FreightTank stock = this;
        EntityCoupleableRollingStock.CouplerType couplerType = EntityCoupleableRollingStock.CouplerType.BACK;
        while (var2_13 != null && stock.getCoupled((EntityCoupleableRollingStock.CouplerType)var2_13) instanceof Tender) {
            EntityCoupleableRollingStock.CouplerType couplerType2;
            Tender tender = (Tender)stock.getCoupled((EntityCoupleableRollingStock.CouplerType)var2_13);
            int desiredDrain = 10;
            if (this.getTankCapacity().MilliBuckets() - this.getServerLiquidAmount() >= 10) {
                this.theTank.drain((ITank)tender.theTank, desiredDrain, false);
            }
            if (this.getTickCount() % 20 == 0 && this.getDefinition().tender_auto_feed) {
                for (int slot = 2; slot < this.cargoItems.getSlotCount(); ++slot) {
                    if (BurnUtil.getBurnTime(this.cargoItems.get(slot)) == 0) continue;
                    for (int tenderSlot = 0; tenderSlot < tender.cargoItems.getSlotCount(); ++tenderSlot) {
                        if (!this.cargoItems.get(slot).is(tender.cargoItems.get(tenderSlot)) || this.cargoItems.get(slot).getLimit() <= this.cargoItems.get(slot).getCount()) continue;
                        ItemStack extracted = tender.cargoItems.extract(tenderSlot, 1, false);
                        this.cargoItems.insert(slot, extracted, false);
                    }
                }
            }
            if ((couplerType2 = tender.getCouplerFor(stock)) == null) break;
            EntityCoupleableRollingStock.CouplerType couplerType3 = couplerType2.opposite();
            stock = tender;
        }
        float boilerTemperature = this.getBoilerTemperature();
        float boilerPressure = this.getBoilerPressure();
        float waterLevelMB = this.getLiquidAmount();
        int burningSlots = 0;
        float waterUsed = 0.0f;
        if (boilerPressure < 0.0f) {
            boilerPressure = 0.0f;
        }
        if (this.getLiquidAmount() > 0) {
            for (int slot = 2; slot < this.cargoItems.getSlotCount(); ++slot) {
                int remainingTime = this.burnTime.getOrDefault(slot, 0);
                if (remainingTime <= 0) {
                    ItemStack itemStack = this.cargoItems.get(slot);
                    if (itemStack.getCount() <= 0 || BurnUtil.getBurnTime(itemStack) == 0) continue;
                    remainingTime = (int)((double)BurnUtil.getBurnTime(itemStack) / this.gauge.scale() * ((double)Config.ConfigBalance.locoSteamFuelEfficiency / 100.0));
                    this.burnTime.put(slot, remainingTime);
                    this.burnMax.put(slot, remainingTime);
                    itemStack.setCount(itemStack.getCount() - 1);
                    this.cargoItems.set(slot, itemStack);
                } else {
                    this.burnTime.put(slot, remainingTime - 1);
                }
                ++burningSlots;
            }
        }
        double energyKCalDeltaTick = 0.0;
        if (burningSlots != 0 && this.getLiquidAmount() > 0) {
            energyKCalDeltaTick += (double)burningSlots * this.coalEnergyKCalTick();
        }
        double d = this.getTankCapacity().Buckets();
        double boilerEdgeM = Math.pow(d, 0.3333333333333333);
        double boilerAreaM = 6.0 * Math.pow(boilerEdgeM, 2.0);
        if (boilerTemperature > 0.0f) {
            double radiatedKwHr = Math.pow(boilerTemperature / 10.0f, 2.0) / 100.0 * boilerAreaM * 2.0;
            double radiatedKCalHr = radiatedKwHr * 859.85;
            double radiatedKCalTick = radiatedKCalHr / 60.0 / 60.0 / 20.0 * (double)Config.ConfigBalance.locoHeatTimeScale;
            energyKCalDeltaTick -= radiatedKCalTick / 1000.0;
        }
        if (energyKCalDeltaTick != 0.0) {
            boilerTemperature = (float)((double)boilerTemperature + energyKCalDeltaTick / (double)((waterLevelMB + 1.0f) / 1000.0f));
        }
        if (boilerTemperature > 100.0f) {
            int maxPSI;
            float heatTransfer = boilerTemperature - 100.0f;
            boilerPressure += heatTransfer;
            if (this.getPercentLiquidFull() > 25) {
                boilerTemperature -= heatTransfer;
            }
            boolean bl = this.pressureValve = boilerPressure > (float)(maxPSI = this.getDefinition().getMaxPSI(this.gauge));
            if (boilerPressure > (float)maxPSI) {
                waterUsed += boilerPressure - (float)maxPSI;
                boilerPressure = maxPSI;
            }
        } else {
            if (boilerPressure > 0.0f) {
                boilerPressure = Math.max(0.0f, boilerPressure - (100.0f - boilerTemperature));
                boilerTemperature = 100.0f;
            }
            this.pressureValve = false;
        }
        float throttle = Math.abs(this.getThrottle());
        if (throttle != 0.0f && boilerPressure > 0.0f) {
            double burnableSlots = this.cargoItems.getSlotCount() - 2;
            double maxKCalTick = burnableSlots * this.coalEnergyKCalTick();
            double maxPressureTick = maxKCalTick / (double)(this.getTankCapacity().MilliBuckets() / 1000);
            float delta = (float)((double)throttle * (maxPressureTick *= 0.8));
            boilerPressure = Math.max(0.0f, boilerPressure - delta);
            waterUsed += delta;
        }
        if (waterUsed != 0.0f) {
            waterUsed *= Config.ConfigBalance.locoWaterUsage;
            if ((waterUsed += this.drainRemainder) > 0.0f && this.theTank.getContents() != null) {
                this.theTank.drain(new FluidStack(this.theTank.getContents().getFluid(), (int)Math.floor(waterUsed)), false);
                this.drainRemainder = waterUsed % 1.0f;
            }
        }
        this.setBoilerPressure(boilerPressure);
        this.setBoilerTemperature(Math.max(boilerTemperature, this.ambientTemperature()));
        if ((double)boilerPressure > (double)this.getDefinition().getMaxPSI(this.gauge) * 1.1 || (double)boilerPressure > (double)this.getDefinition().getMaxPSI(this.gauge) * 0.5 && boilerTemperature > 150.0f) {
            Vec3d pos = this.getPosition();
            if (Config.ConfigDamage.explosionsEnabled) {
                this.createExplosion(pos, boilerPressure / 5.0f, Config.ConfigDamage.explosionEnvDamageEnabled);
            }
            this.getWorld().removeEntity((Entity)this);
        }
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        for (ISound chime : this.chimes) {
            chime.stop();
        }
        if (this.idle != null) {
            this.idle.stop();
        }
        if (this.pressure != null) {
            this.pressure.stop();
        }
    }

    @Override
    protected void initContainerFilter() {
        this.cargoItems.filter.clear();
        this.cargoItems.filter.put(0, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.filter.put(1, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.defaultFilter = SlotFilter.BURNABLE;
    }

    @Override
    public int getInventorySize() {
        return this.getDefinition().getInventorySize(this.gauge) + 2;
    }

    @Override
    public int getInventoryWidth() {
        return this.getDefinition().getInventoryWidth(this.gauge);
    }

    @Override
    protected int[] getContainerInputSlots() {
        return new int[]{0};
    }

    @Override
    protected int[] getContainertOutputSlots() {
        return new int[]{1};
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return this.getDefinition().getTankCapacity(this.gauge);
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return LiquidUtil.getWater();
    }

    private double coalEnergyKCalTick() {
        double coalEnergyDensity = 30000.0;
        double coalEnergyKJ = coalEnergyDensity / 9.0;
        double coalEnergyBTU = coalEnergyKJ * 0.958;
        double coalEnergyKCal = coalEnergyBTU / 3968.0;
        double coalBurnTicks = 1600.0;
        return coalEnergyKCal / coalBurnTicks * (double)Config.ConfigBalance.locoHeatTimeScale;
    }

    private static class SlotTagMapper
    implements TagMapper<Map<Integer, Integer>> {
        private SlotTagMapper() {
        }

        public TagMapper.TagAccessor<Map<Integer, Integer>> apply(Class<Map<Integer, Integer>> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((d, o) -> d.setMap(fieldName, o, Objects::toString, i -> new TagCompound().setInteger("val", i)), d -> d.getMap(fieldName, Integer::parseInt, t -> t.getInteger("val")));
        }
    }
}

