/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items.nbt;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.library.TrackSmoothing;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.serialization.SerializationException;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import cam72cam.mod.serialization.TagSerializer;

public class RailSettings {
    @TagField(value="gauge")
    public final Gauge gauge;
    @TagField(value="type")
    public final TrackItems type;
    @TagField(value="length")
    public final int length;
    @TagField(value="degrees", mapper=DegreesMapper.class)
    public final float degrees;
    @TagField(value="pos_type")
    public final TrackPositionType posType;
    @TagField(value="smoothing", mapper=SmoothingMapper.class)
    public final TrackSmoothing smoothing;
    @TagField(value="direction")
    public final TrackDirection direction;
    @TagField(value="bedItem")
    public final ItemStack railBed;
    @TagField(value="bedFill")
    public final ItemStack railBedFill;
    @TagField(value="isPreview")
    public final boolean isPreview;
    @TagField(value="isGradeCrossing")
    public final boolean isGradeCrossing;
    @TagField(value="track")
    public final String track;

    public RailSettings(Gauge gauge, String track, TrackItems type, int length, float degrees, TrackPositionType posType, TrackSmoothing smoothing, TrackDirection direction, ItemStack railBed, ItemStack railBedFill, boolean isPreview, boolean isGradeCrossing) {
        this.gauge = gauge;
        this.track = track;
        this.type = type;
        this.length = length;
        this.degrees = degrees;
        this.posType = posType;
        this.smoothing = smoothing;
        this.direction = direction;
        this.railBed = railBed;
        this.railBedFill = railBedFill;
        this.isPreview = isPreview;
        this.isGradeCrossing = isGradeCrossing;
    }

    private RailSettings() {
        this.gauge = Gauge.from(1.435);
        this.type = TrackItems.STRAIGHT;
        this.track = "default";
        this.length = 10;
        this.degrees = 90.0f;
        this.posType = TrackPositionType.FIXED;
        this.smoothing = TrackSmoothing.BOTH;
        this.direction = TrackDirection.NONE;
        this.railBed = ItemStack.EMPTY;
        this.railBedFill = ItemStack.EMPTY;
        this.isPreview = false;
        this.isGradeCrossing = false;
    }

    public void write(ItemStack stack) {
        TagCompound data = new TagCompound();
        try {
            TagSerializer.serialize((TagCompound)data, (Object)this, (Class[])new Class[0]);
        }
        catch (SerializationException e) {
            ImmersiveRailroading.catching((Throwable)e);
        }
        stack.setTagCompound(data);
    }

    public static RailSettings from(ItemStack stack) {
        RailSettings res = new RailSettings();
        try {
            TagSerializer.deserialize((TagCompound)stack.getTagCompound(), (Object)res);
        }
        catch (SerializationException e) {
            ImmersiveRailroading.catching((Throwable)e);
        }
        return res;
    }

    public RailSettings withLength(int length) {
        return new RailSettings(this.gauge, this.track, this.type, length, this.degrees, this.posType, this.smoothing, this.direction, this.railBed, this.railBedFill, this.isPreview, this.isGradeCrossing);
    }

    public RailSettings withType(TrackItems type) {
        return new RailSettings(this.gauge, this.track, type, this.length, this.degrees, this.posType, this.smoothing, this.direction, this.railBed, this.railBedFill, this.isPreview, this.isGradeCrossing);
    }

    public RailSettings withTrack(String track) {
        return new RailSettings(this.gauge, track, this.type, this.length, this.degrees, this.posType, this.smoothing, this.direction, this.railBed, this.railBedFill, this.isPreview, this.isGradeCrossing);
    }

    public RailSettings withBed(ItemStack railBed) {
        return new RailSettings(this.gauge, this.track, this.type, this.length, this.degrees, this.posType, this.smoothing, this.direction, railBed, this.railBedFill, this.isPreview, this.isGradeCrossing);
    }

    public RailSettings withBedFill(ItemStack railBedFill) {
        return new RailSettings(this.gauge, this.track, this.type, this.length, this.degrees, this.posType, this.smoothing, this.direction, this.railBed, railBedFill, this.isPreview, this.isGradeCrossing);
    }

    private static class SmoothingMapper
    implements TagMapper<TrackSmoothing> {
        private SmoothingMapper() {
        }

        public TagMapper.TagAccessor<TrackSmoothing> apply(Class<TrackSmoothing> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor<TrackSmoothing>((d, o) -> d.setEnum(fieldName, (Enum)o), nbt -> {
                if (nbt.hasKey(fieldName)) {
                    return (TrackSmoothing)nbt.getEnum(fieldName, type);
                }
                return nbt.getEnum("type", TrackItems.class) == TrackItems.SLOPE ? TrackSmoothing.NEITHER : TrackSmoothing.BOTH;
            }){

                public boolean applyIfMissing() {
                    return true;
                }
            };
        }
    }

    private static class DegreesMapper
    implements TagMapper<Float> {
        private DegreesMapper() {
        }

        public TagMapper.TagAccessor<Float> apply(Class<Float> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor<Float>((d, o) -> d.setFloat(fieldName, o), d -> Float.valueOf(d.hasKey(fieldName) ? d.getFloat(fieldName).floatValue() : (d.hasKey("quarters") ? (float)d.getInteger("quarters").intValue() / 4.0f * 90.0f : 90.0f))){

                public boolean applyIfMissing() {
                    return true;
                }
            };
        }
    }
}

