/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.mod.math.Vec3d;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RenderComponent {
    public final RenderComponentType type;
    public final int id;
    public final String side;
    public final Set<String> modelIDs;
    public final String pos;
    public final double scale;
    public final Vec3d min;
    public final Vec3d max;
    private final boolean wooden;
    private final Vec3d minScaled;
    private final Vec3d maxScaled;
    private final Vec3d centerScaled;
    private final Map<Double, RenderComponent> scaleCache = new HashMap<Double, RenderComponent>();

    public static RenderComponent parse(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups) {
        return RenderComponent.parse(name, def, groups, -1, "", "");
    }

    public static RenderComponent parseID(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, int id) {
        return RenderComponent.parse(name, def, groups, id, "", "");
    }

    public static RenderComponent parseSide(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String side) {
        return RenderComponent.parse(name, def, groups, -1, side, "");
    }

    public static RenderComponent parsePos(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String pos) {
        return RenderComponent.parse(name, def, groups, -1, "", pos);
    }

    public static RenderComponent parsePosID(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String pos, int id) {
        return RenderComponent.parse(name, def, groups, id, "", pos);
    }

    private static RenderComponent parse(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, int id, String side, String pos) {
        HashSet<String> modelIDs = new HashSet<String>();
        String idStr = id != -1 ? "" + id : "";
        boolean wooden = true;
        for (String group : groups) {
            if (!Pattern.matches(name.regex.replace("#SIDE#", side).replaceAll("#ID#", idStr).replaceAll("#POS#", pos), group)) continue;
            modelIDs.add(group);
            if (group.contains("WOOD")) continue;
            wooden = false;
        }
        if (modelIDs.size() == 0) {
            return null;
        }
        Vec3d min = def.getModel().minOfGroup(modelIDs);
        Vec3d max = def.getModel().maxOfGroup(modelIDs);
        groups.removeAll(modelIDs);
        return new RenderComponent(modelIDs, name, id, side, pos, 1.0, wooden, min, max);
    }

    private RenderComponent(Set<String> modelIDs, RenderComponentType type, int id, String side, String pos, double scale, boolean wooden, Vec3d min, Vec3d max) {
        this.modelIDs = modelIDs;
        this.type = type;
        this.id = id;
        this.side = side;
        this.pos = pos;
        this.scale = scale;
        this.wooden = wooden;
        this.min = min;
        this.max = max;
        this.minScaled = min.scale(scale);
        this.maxScaled = max.scale(scale);
        this.centerScaled = new Vec3d((this.minScaled.x + this.maxScaled.x) / 2.0, (this.minScaled.y + this.maxScaled.y) / 2.0, (this.minScaled.z + this.maxScaled.z) / 2.0);
    }

    public Vec3d min() {
        return this.minScaled;
    }

    public Vec3d max() {
        return this.maxScaled;
    }

    public Vec3d center() {
        return this.centerScaled;
    }

    public double height() {
        return this.maxScaled.y - this.minScaled.y;
    }

    public double length() {
        return this.maxScaled.x - this.minScaled.x;
    }

    public double width() {
        return this.maxScaled.z - this.minScaled.z;
    }

    public boolean isWooden() {
        return this.wooden;
    }

    public RenderComponent scale(Gauge gauge) {
        if (!this.scaleCache.containsKey(gauge.scale())) {
            this.scaleCache.put(gauge.scale(), new RenderComponent(this.modelIDs, this.type, this.id, this.side, this.pos, gauge.scale(), this.wooden, this.min, this.max));
        }
        return this.scaleCache.get(gauge.scale());
    }

    public String toString() {
        return String.format("%s%s%s%s%s", new Object[]{this.type, this.id, this.side, this.pos, this.scale});
    }
}

