/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.model.RenderComponent;
import cam72cam.immersiverailroading.render.StockRenderCache;
import cam72cam.immersiverailroading.render.entity.StockModel;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.render.ItemRender;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class StockItemComponentModel
implements ItemRender.IItemModel {
    public StandardModel getModel(World world, ItemStack stack) {
        return new StandardModel().addCustom(() -> StockItemComponentModel.render(stack));
    }

    public static void render(ItemStack stack) {
        ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(stack);
        double itemScale = data.gauge.scale();
        if (data.def == null) {
            ImmersiveRailroading.error((String)"Item %s missing definition!", (Object[])new Object[]{stack});
            stack.setCount(0);
            return;
        }
        StockModel renderer = StockRenderCache.getRender(data.def.defID);
        ArrayList<String> groups = new ArrayList<String>();
        for (RenderComponentType r : data.componentType.render) {
            RenderComponent comp = data.def.getComponent(r, Gauge.from(1.435));
            if (comp == null || r == RenderComponentType.CARGO_FILL_X) continue;
            groups.addAll(comp.modelIDs);
        }
        Vec3d center = renderer.model.centerOfGroups(groups);
        double width = renderer.model.heightOfGroups(groups);
        double length = renderer.model.lengthOfGroups(groups);
        double scale = 1.0;
        if (width != 0.0 || length != 0.0) {
            scale = 0.95 / Math.max(width, length);
        }
        scale *= Math.sqrt(itemScale);
        try (OpenGL.With matrix = OpenGL.matrix();
             OpenGL.With tex = renderer.bindTexture(true);
             OpenGL.With blend = OpenGL.bool((int)3042, (boolean)false);
             OpenGL.With cull = OpenGL.bool((int)2884, (boolean)false);
             OpenGL.With light = OpenGL.bool((int)2896, (boolean)false);){
            GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            GL11.glTranslated((double)(-center.x), (double)(-center.y), (double)(-center.z));
            renderer.drawGroups(groups);
        }
    }
}

