/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.multiblock;

import cam72cam.immersiverailroading.multiblock.RailRollerMultiblock;
import cam72cam.immersiverailroading.render.multiblock.IMultiblockRender;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.mod.model.obj.OBJModel;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.resource.Identifier;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class RailRollerRender
implements IMultiblockRender {
    private OBJRender renderer;
    private List<String> input;
    private List<String> output;
    private List<String> rest;

    @Override
    public void render(TileMultiblock te, float partialTicks) {
        if (this.renderer == null) {
            try {
                this.renderer = new OBJRender(new OBJModel(new Identifier("immersiverailroading", "models/multiblocks/rail_machine.obj"), 0.1f));
                this.input = new ArrayList<String>();
                this.output = new ArrayList<String>();
                this.rest = new ArrayList<String>();
                for (String name : this.renderer.model.groups.keySet()) {
                    if (name.contains("INPUT_CAST")) {
                        this.input.add(name);
                        continue;
                    }
                    if (name.contains("OUTPUT_RAIL")) {
                        this.output.add(name);
                        continue;
                    }
                    this.rest.add(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try (OpenGL.With matrix = OpenGL.matrix();
             OpenGL.With tex = this.renderer.bindTexture();){
            Throwable throwable;
            OpenGL.With m;
            GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
            GL11.glRotated((double)(te.getRotation() - 90.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-1.5, (double)0.0, (double)0.5);
            RailRollerMultiblock.RailRollerInstance tmb = (RailRollerMultiblock.RailRollerInstance)te.getMultiblock();
            int progress = tmb.getCraftProgress();
            if (progress != 0) {
                m = OpenGL.matrix();
                throwable = null;
                try {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)((double)(-(100 - progress)) / 10.0));
                    GL11.glScaled((double)1.0, (double)1.0, (double)Math.max(0.25, Math.sqrt((double)progress / 100.0)));
                    this.renderer.drawGroups(this.input);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (m != null) {
                        if (throwable != null) {
                            try {
                                m.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            m.close();
                        }
                    }
                }
            }
            m = OpenGL.matrix();
            throwable = null;
            try {
                if (progress != 0) {
                    GL11.glTranslated((double)0.0, (double)0.0, (double)((double)progress / 10.0));
                    this.renderer.drawGroups(this.output);
                } else if (tmb.outputFull()) {
                    this.renderer.drawGroups(this.output);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (m != null) {
                    if (throwable != null) {
                        try {
                            m.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        m.close();
                    }
                }
            }
            this.renderer.drawGroups(this.rest);
        }
    }
}

