/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty;

import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.physics.PhysicsAccummulator;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.thirdparty.event.TagEvent;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.mod.math.Vec3i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;

public class CommonAPI {
    private final EntityRollingStock stock;

    public static CommonAPI create(World world, BlockPos pos) {
        return CommonAPI.create(world, pos, EntityRollingStock.class);
    }

    public static CommonAPI create(World world, BlockPos pos, Class<? extends EntityRollingStock> stockClass) {
        EntityRollingStock stock;
        TileRailBase te = (TileRailBase)cam72cam.mod.world.World.get((World)world).getBlockEntity(new Vec3i(pos), TileRailBase.class);
        if (te != null && (stock = te.getStockNearBy(stockClass)) != null) {
            return new CommonAPI(stock);
        }
        return null;
    }

    public CommonAPI(EntityRollingStock stock) {
        this.stock = stock;
    }

    public FluidStack getFluid() {
        return null;
    }

    public Map<String, Object> info() {
        if (this.stock != null) {
            FluidStack fluid;
            HashMap<String, Object> info = new HashMap<String, Object>();
            EntityRollingStockDefinition def = this.stock.getDefinition();
            info.put("id", def.defID);
            info.put("name", def.name());
            info.put("tag", this.stock.tag);
            info.put("weight", this.stock.getWeight());
            Direction dir = Direction.func_176733_a((double)this.stock.getRotationYaw());
            if (this.stock instanceof EntityMoveableRollingStock) {
                EntityMoveableRollingStock movable = (EntityMoveableRollingStock)this.stock;
                info.put("speed", movable.getCurrentSpeed().metric());
                if (movable.getCurrentSpeed().metric() < 0.0) {
                    dir = dir.func_176734_d();
                }
            }
            info.put("direction", dir.toString());
            if (this.stock instanceof EntityRidableRollingStock) {
                info.put("passengers", this.stock.getPassengerCount());
            }
            if (this.stock instanceof Locomotive) {
                Locomotive loco = (Locomotive)this.stock;
                LocomotiveDefinition locoDef = loco.getDefinition();
                info.put("horsepower", locoDef.getHorsePower(loco.gauge));
                info.put("traction", locoDef.getStartingTractionNewtons(loco.gauge));
                info.put("max_speed", locoDef.getMaxSpeed(loco.gauge).metric());
                info.put("brake", Float.valueOf(loco.getAirBrake()));
                info.put("throttle", Float.valueOf(loco.getThrottle()));
                if (loco instanceof LocomotiveSteam) {
                    LocomotiveSteam steam = (LocomotiveSteam)loco;
                    info.put("pressure", Float.valueOf(steam.getBoilerPressure()));
                    info.put("temperature", Float.valueOf(steam.getBoilerTemperature()));
                }
                if (loco instanceof LocomotiveDiesel) {
                    info.put("temperature", Float.valueOf(((LocomotiveDiesel)loco).getEngineTemperature()));
                }
            }
            if ((fluid = this.getFluid()) != null) {
                info.put("fluid_type", fluid.getFluid().getAttributes().getDisplayName(null));
                info.put("fluid_amount", fluid.getAmount());
            } else {
                info.put("fluid_type", null);
                info.put("fluid_amount", 0);
            }
            if (this.stock instanceof FreightTank) {
                info.put("fluid_max", ((FreightTank)this.stock).getTankCapacity().MilliBuckets());
            }
            if (this.stock instanceof Freight) {
                Freight freight = (Freight)this.stock;
                info.put("cargo_percent", freight.getPercentCargoFull());
                info.put("cargo_size", freight.getInventorySize());
            }
            return info;
        }
        return null;
    }

    public Map<String, Object> consist(boolean supportsList) {
        if (!(this.stock instanceof EntityCoupleableRollingStock)) {
            return null;
        }
        EntityCoupleableRollingStock stock = (EntityCoupleableRollingStock)this.stock;
        int traction = 0;
        PhysicsAccummulator acc = new PhysicsAccummulator(stock.getCurrentTickPosAndPrune());
        stock.mapTrain(stock, true, true, acc::accumulate);
        HashMap<String, Object> info = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> locos = new ArrayList<Map<String, Object>>();
        info.put("cars", acc.count);
        info.put("tractive_effort_N", acc.tractiveEffortNewtons);
        info.put("weight_kg", acc.massToMoveKg);
        info.put("speed_km", stock.getCurrentSpeed().metric());
        Direction dir = Direction.func_176733_a((double)stock.getRotationYaw());
        if (stock.getCurrentSpeed().metric() < 0.0) {
            dir = dir.func_176734_d();
        }
        info.put("direction", dir.toString());
        for (EntityCoupleableRollingStock car : stock.getTrain()) {
            if (!(car instanceof Locomotive)) continue;
            LocomotiveDefinition locoDef = ((Locomotive)car).getDefinition();
            traction += locoDef.getStartingTractionNewtons(car.gauge);
            locos.add(new CommonAPI(car).info());
        }
        if (supportsList) {
            info.put("locomotives", locos);
        } else {
            HashMap locomotives = new HashMap();
            for (int i = 0; i < locos.size(); ++i) {
                locomotives.put("" + i, locos.get(i));
            }
            info.put("locomotives", locomotives);
        }
        info.put("total_traction_N", traction);
        return info;
    }

    public String getTag() {
        TagEvent.GetTagEvent tagEvent = new TagEvent.GetTagEvent(this.stock.getUUID());
        MinecraftForge.EVENT_BUS.post((Event)tagEvent);
        if (tagEvent.tag != null) {
            return tagEvent.tag;
        }
        return this.stock.tag;
    }

    public void setTag(String tag) {
        TagEvent.SetTagEvent tagEvent = new TagEvent.SetTagEvent(this.stock.getUUID(), tag);
        MinecraftForge.EVENT_BUS.post((Event)tagEvent);
        this.stock.tag = tag;
    }

    private float normalize(double val) {
        if (Double.isNaN(val)) {
            return 0.0f;
        }
        if (val > 1.0) {
            return 1.0f;
        }
        if (val < -1.0) {
            return -1.0f;
        }
        return (float)val;
    }

    public void setThrottle(double throttle) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setThrottle(this.normalize(throttle));
        }
    }

    public void setAirBrake(double brake) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setAirBrake(this.normalize(brake));
        }
    }

    public void setHorn(int horn) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setHorn(horn, null);
        }
    }

    public void setBell(int bell) {
        if (this.stock instanceof Locomotive) {
            ((Locomotive)this.stock).setBell(bell);
        }
    }

    public Vec3d getPosition() {
        return this.stock.getPosition().internal();
    }

    public UUID getUniqueID() {
        return this.stock.getUUID();
    }
}

