/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import java.util.ArrayList;
import java.util.List;

public class TileRail
extends TileRailBase {
    @TagField(value="info")
    public RailInfo info;
    @TagField(value="drops", typeHint=ItemStack.class, mapper=DropsMapper.class)
    private List<ItemStack> drops;
    private IBoundingBox boundingBox;
    private List<TrackBase> tracks;

    public IBoundingBox getRenderBoundingBox() {
        if (this.info == null) {
            return IBoundingBox.ORIGIN;
        }
        if (this.boundingBox == null) {
            int length = this.info.settings.length;
            if (this.info.settings.type == TrackItems.CUSTOM && !this.info.customInfo.placementPosition.equals((Object)this.info.placementInfo.placementPosition)) {
                length = (int)this.info.customInfo.placementPosition.distanceTo(this.info.placementInfo.placementPosition);
            }
            this.boundingBox = IBoundingBox.ORIGIN.grow(new Vec3d((double)length, (double)length, (double)length));
        }
        return this.boundingBox;
    }

    public double getRenderDistance() {
        return 256.0;
    }

    public void setSwitchState(SwitchState state) {
        if (state != this.info.switchState) {
            this.info = new RailInfo(this.info.settings, this.info.placementInfo, this.info.customInfo, state, this.info.switchForced, this.info.tablePos);
            this.markDirty();
        }
    }

    public void nextTablePos(boolean back) {
        float delta = 5.625f;
        double tablePos = (float)((int)(this.info.tablePos / (double)delta)) * delta + (back ? delta : -delta);
        this.info = new RailInfo(this.info.settings, this.info.placementInfo, this.info.customInfo, this.info.switchState, this.info.switchForced, tablePos);
        this.markDirty();
        List ents = this.getWorld().getEntities(stock -> stock.getPosition().distanceTo(new Vec3d(this.getPos())) < (double)this.info.settings.length, EntityCoupleableRollingStock.class);
        for (EntityCoupleableRollingStock stock2 : ents) {
            stock2.triggerResimulate();
        }
    }

    public void setDrops(List<ItemStack> drops) {
        this.drops = drops;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public void spawnDrops() {
        this.spawnDrops(new Vec3d(this.getPos()));
    }

    public void spawnDrops(Vec3d pos) {
        if (this.getWorld().isServer && this.drops != null && this.drops.size() != 0) {
            for (ItemStack drop : this.drops) {
                this.getWorld().dropItem(drop, pos);
            }
            this.drops = new ArrayList<ItemStack>();
        }
    }

    public double percentFloating() {
        int floating = 0;
        int total = 0;
        if (this.info.settings == null) {
            return 0.0;
        }
        if (this.tracks == null) {
            this.tracks = (this.info.settings.type == TrackItems.SWITCH ? this.info.withType(TrackItems.STRAIGHT) : this.info).getBuilder(this.getWorld(), new Vec3i(this.info.placementInfo.placementPosition).add(this.getPos())).getTracksForFloating();
        }
        for (TrackBase track : this.tracks) {
            Vec3i tpos = track.getPos();
            ++total;
            if (!this.getWorld().isBlockLoaded(tpos)) {
                return 0.0;
            }
            if (track.isDownSolid(false)) continue;
            ++floating;
        }
        return (double)floating / (double)total;
    }

    @Override
    public double getTrackGauge() {
        if (this.info == null) {
            return 0.0;
        }
        return this.info.settings.gauge.value();
    }

    @Override
    public void onBreak() {
        this.spawnDrops();
        super.onBreak();
    }

    @Override
    public ItemStack getRenderRailBed() {
        if (this.info == null) {
            return null;
        }
        return this.info.settings.railBed;
    }

    private static class DropsMapper
    implements TagMapper<List<ItemStack>> {
        private DropsMapper() {
        }

        public TagMapper.TagAccessor<List<ItemStack>> apply(Class<List<ItemStack>> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((nbt, drops) -> {
                if (drops != null && !drops.isEmpty()) {
                    TagCompound dropNBT = new TagCompound();
                    dropNBT.setInteger("count", Integer.valueOf(drops.size()));
                    for (int i = 0; i < drops.size(); ++i) {
                        dropNBT.set("drop_" + i, ((ItemStack)drops.get(i)).toTag());
                    }
                    nbt.set("drops", dropNBT);
                }
            }, nbt -> {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                if (nbt.hasKey("drops")) {
                    TagCompound dropNBT = nbt.get("drops");
                    int count = dropNBT.getInteger("count");
                    for (int i = 0; i < count; ++i) {
                        drops.add(new ItemStack(dropNBT.get("drop_" + i)));
                    }
                }
                return drops;
            });
        }
    }
}

