/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.tile;

import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.net.PreviewRenderPacket;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.block.BlockEntityTickable;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.util.Facing;

public class TileRailPreview
extends BlockEntityTickable {
    private int ticksAlive;
    private RailInfo info;
    @TagField
    private ItemStack item;
    @TagField
    private PlacementInfo placementInfo;
    @TagField
    private PlacementInfo customInfo;
    @TagField
    private boolean isAboveRails = false;

    public ItemStack getItem() {
        return this.item;
    }

    public void setup(ItemStack stack, PlacementInfo info) {
        this.item = stack.copy();
        this.placementInfo = info;
        this.isAboveRails = BlockUtil.isIRRail(this.getWorld(), this.getPos().down()) && (double)((TileRailBase)this.getWorld().getBlockEntity(this.getPos().down(), TileRailBase.class)).getRailHeight() < 0.5;
        this.markDirty();
    }

    public void setItem(ItemStack stack, Player player) {
        this.item = stack.copy();
        RailSettings settings = RailSettings.from(this.item);
        if (settings.direction != TrackDirection.NONE) {
            this.placementInfo = this.placementInfo.withDirection(settings.direction);
        }
        if (!settings.isPreview && this.getRailRenderInfo() != null && this.getRailRenderInfo().build(player, this.isAboveRails() ? this.getPos().down() : this.getPos())) {
            new PreviewRenderPacket(this.getWorld(), this.getPos()).sendToAll();
            if (this.isAboveRails()) {
                this.getWorld().breakBlock(this.getPos());
            }
            return;
        }
        this.markDirty();
    }

    public void load(TagCompound nbt) {
        this.info = null;
    }

    public void setCustomInfo(PlacementInfo info) {
        this.customInfo = info;
        if (this.customInfo != null) {
            RailSettings settings = RailSettings.from(this.item);
            double lx = Math.abs(this.customInfo.placementPosition.x - this.placementInfo.placementPosition.x);
            double lz = Math.abs(this.customInfo.placementPosition.z - this.placementInfo.placementPosition.z);
            switch (settings.type) {
                case TURN: {
                    double length = (lx + lz) / 2.0 + 1.0;
                    settings = settings.withLength((int)Math.round(length *= (double)(90.0f / settings.degrees)));
                    break;
                }
                case STRAIGHT: 
                case SLOPE: {
                    double length = Math.max(lx, lz) + 1.0;
                    settings = settings.withLength((int)Math.round(length));
                }
            }
            settings.write(this.item);
        }
        this.markDirty();
    }

    public void setPlacementInfo(PlacementInfo info) {
        this.placementInfo = info;
        this.markDirty();
    }

    public boolean onClick(Player player, Player.Hand hand, Facing facing, Vec3d hit) {
        if (player.isCrouching()) {
            if (this.getWorld().isServer) {
                this.setPlacementInfo(new PlacementInfo(this.getItem(), player.getYawHead(), hit));
            }
            return false;
        }
        if (!player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_GOLDEN_SPIKE)) {
            GuiTypes.RAIL_PREVIEW.open(player, this.getPos());
            return true;
        }
        return false;
    }

    public ItemStack onPick() {
        if (this.item == null) {
            return ItemStack.EMPTY;
        }
        return this.item;
    }

    public IBoundingBox getBoundingBox() {
        return IBoundingBox.ORIGIN.expand(new Vec3d(1.0, 0.125, 1.0));
    }

    public IBoundingBox getRenderBoundingBox() {
        return IBoundingBox.INFINITE;
    }

    public RailInfo getRailRenderInfo() {
        if (this.getWorld() != null && this.item != null && (this.info == null || this.info.settings == null)) {
            this.info = new RailInfo(this.item, this.placementInfo, this.customInfo);
        }
        return this.info;
    }

    public void markDirty() {
        super.markDirty();
        this.info = new RailInfo(this.item, this.placementInfo, this.customInfo);
        if (this.isMulti() && this.getWorld().isServer) {
            new PreviewRenderPacket(this).sendToAll();
        }
    }

    public boolean isMulti() {
        if (this.getRailRenderInfo().getBuilder(this.getWorld()) instanceof IIterableTrack) {
            return ((IIterableTrack)((Object)this.getRailRenderInfo().getBuilder(this.getWorld()))).getSubBuilders() != null;
        }
        return false;
    }

    public void update() {
        if (this.getWorld().isServer && this.isMulti()) {
            this.getWorld().keepLoaded(this.getPos());
            if (this.ticksAlive % 20 == 0) {
                new PreviewRenderPacket(this).sendToAll();
            }
            ++this.ticksAlive;
        }
    }

    public boolean tryBreak(Player entityPlayer) {
        if (entityPlayer != null && entityPlayer.isCrouching()) {
            if (this.getRailRenderInfo() != null && this.getRailRenderInfo().build(entityPlayer, this.isAboveRails() ? this.getPos().down() : this.getPos())) {
                new PreviewRenderPacket(this.getWorld(), this.getPos()).sendToAll();
                return this.isAboveRails();
            }
            return false;
        }
        new PreviewRenderPacket(this.getWorld(), this.getPos()).sendToAll();
        return true;
    }

    public boolean isAboveRails() {
        return this.isAboveRails;
    }
}

