/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class LayeredIntersection5
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 10;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 9;
    private static final int LOCAL_Z_END = 4;

    public LayeredIntersection5(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.LAYERED_INTERSECTION_5, compoundTag);
    }

    public LayeredIntersection5(int i, int pieceChainLen, Random random, MutableBoundingBox blockBox, Direction direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.LAYERED_INTERSECTION_5, i, pieceChainLen, type);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = new MutableBoundingBox(x, y, z, x, y + 10 - 1, z);
        switch (direction) {
            default: {
                blockBox.field_78893_d = x + 4;
                blockBox.field_78896_c = z - 4;
                break;
            }
            case SOUTH: {
                blockBox.field_78897_a = x - 4;
                blockBox.field_78892_f = z + 4;
                break;
            }
            case WEST: {
                blockBox.field_78897_a = x - 4;
                blockBox.field_78896_c = z - 4;
                break;
            }
            case EAST: {
                blockBox.field_78893_d = x + 4;
                blockBox.field_78892_f = z + 4;
            }
        }
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.EAST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, Direction.WEST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 5, this.field_74887_e.field_78896_c, Direction.EAST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 5, this.field_74887_e.field_78892_f, Direction.WEST, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: 
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 5, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 5, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.func_74877_c(), this.pieceChainLen);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_225577_a_(IWorld world, ChunkGenerator<?> generator, Random random, MutableBoundingBox box, ChunkPos pos) {
        if (this.func_74860_a((IBlockReader)world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 4)) {
            return false;
        }
        float chance = this.mineshaftType == BetterMineshaftStructure.Type.ICE || this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM ? 0.95f : 0.6f;
        this.chanceReplaceNonAir(world, box, random, chance, 0, 0, 0, 4, 9, 4, this.getMainSelector());
        this.fill(world, box, 0, 1, 0, 4, 8, 3, field_202556_l);
        this.fill(world, box, 0, 5, 4, 4, 8, 4, field_202556_l);
        this.fill(world, box, 1, 0, 0, 3, 0, 3, this.getMainBlock());
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH), 2, 1, 0, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH), 2, 1, 1, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)RailShape.EAST_WEST), 0, 1, 2, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)RailShape.EAST_WEST), 1, 1, 2, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)RailShape.EAST_WEST), 3, 1, 2, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)RailShape.EAST_WEST), 4, 1, 2, box);
        this.fill(world, box, 0, 5, 0, 4, 5, 4, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.5f, 0, 5, 0, 4, 5, 4, this.getMainSelector());
        this.fill(world, box, 1, 5, 1, 3, 5, 3, field_202556_l);
        this.fill(world, box, 1, 1, 1, 1, 8, 1, this.getSupportBlock());
        this.fill(world, box, 3, 1, 1, 3, 8, 1, this.getSupportBlock());
        this.fill(world, box, 1, 1, 3, 1, 8, 3, this.getSupportBlock());
        this.fill(world, box, 3, 1, 3, 3, 8, 3, this.getSupportBlock());
        BlockState LADDER = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((IProperty)LadderBlock.field_176382_a, (Comparable)Direction.SOUTH);
        this.fill(world, box, 2, 1, 3, 2, 5, 3, LADDER);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 4, 8, 4);
        this.addVines(world, box, random, this.getVineChance(), 1, 0, 1, 3, 9, 3);
        return true;
    }
}

